/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.apache.commons.io.IOUtils;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;
import org.kse.gui.error.DProblem;
import org.kse.gui.error.Problem;
import org.kse.version.Version;

public class DCheckUpdate
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpCheckUpdate;
    private JLabel jlCheckUpdate;
    private JPanel jpProgress;
    private JProgressBar jpbCheckUpdate;
    private JPanel jpCancel;
    private JButton jbCancel;
    private Thread checker;
    private Version latestVersion;

    public DCheckUpdate(JFrame parent) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents();
    }

    private void initComponents() {
        this.jlCheckUpdate = new JLabel(res.getString("DCheckUpdate.jlCheckUpdate.text"));
        ImageIcon icon = new ImageIcon(this.getClass().getResource("images/chkup.png"));
        this.jlCheckUpdate.setIcon(icon);
        this.jlCheckUpdate.setHorizontalTextPosition(10);
        this.jlCheckUpdate.setIconTextGap(15);
        this.jpCheckUpdate = new JPanel(new FlowLayout(1));
        this.jpCheckUpdate.add(this.jlCheckUpdate);
        this.jpCheckUpdate.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jpbCheckUpdate = new JProgressBar();
        this.jpbCheckUpdate.setIndeterminate(true);
        this.jpbCheckUpdate.setString("DCheckUpdate.jlCheckUpdate.text");
        this.jpProgress = new JPanel(new FlowLayout(1));
        this.jpProgress.add(this.jpbCheckUpdate);
        this.jpProgress.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jbCancel = new JButton(res.getString("DCheckUpdate.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DCheckUpdate.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DCheckUpdate.this.cancelPressed();
            }
        });
        this.jpCancel = PlatformUtil.createDialogButtonPanel(this.jbCancel);
        this.getContentPane().add((Component)this.jpCheckUpdate, "North");
        this.getContentPane().add((Component)this.jpProgress, "Center");
        this.getContentPane().add((Component)this.jpCancel, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                if (DCheckUpdate.this.checker != null && DCheckUpdate.this.checker.isAlive()) {
                    DCheckUpdate.this.checker.interrupt();
                }
                DCheckUpdate.this.closeDialog();
            }
        });
        this.setTitle(res.getString("DCheckUpdate.Title"));
        this.setResizable(false);
        this.pack();
    }

    public void startCheck() {
        this.checker = new Thread(new CheckForUpdate());
        this.checker.setPriority(1);
        this.checker.start();
    }

    private void cancelPressed() {
        if (this.checker != null && this.checker.isAlive()) {
            this.checker.interrupt();
        }
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public Version getLatestVersion() {
        return this.latestVersion;
    }

    private class CheckForUpdate
    implements Runnable {
        private CheckForUpdate() {
        }

        @Override
        public void run() {
            try {
                URL latestVersionUrl = new URL("https://keystore-explorer.org/version.txt");
                String versionString = IOUtils.toString((URL)latestVersionUrl, (String)"ASCII");
                DCheckUpdate.this.latestVersion = new Version(versionString);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DCheckUpdate.this.closeDialog();
                    }
                });
            }
            catch (Exception ex) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (DCheckUpdate.this.isShowing()) {
                            String problemStr = res.getString("DCheckUpdate.NoCheckUpdate.Problem");
                            String[] causes = new String[]{res.getString("DCheckUpdate.UpdateHostUnavailable.Cause"), res.getString("DCheckUpdate.ProxySettingsIncorrect.Cause")};
                            Problem problem = new Problem(problemStr, causes, ex);
                            DProblem dProblem = new DProblem(DCheckUpdate.this, res.getString("DCheckUpdate.ProblemCheckingUpdate.Title"), problem);
                            dProblem.setLocationRelativeTo(DCheckUpdate.this);
                            dProblem.setVisible(true);
                            DCheckUpdate.this.closeDialog();
                        }
                    }
                });
            }
        }
    }
}

