/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.KeyStore;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.kse.crypto.Password;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;
import org.kse.gui.error.DProblem;
import org.kse.gui.error.Problem;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.ssl.SslConnectionInfos;
import org.kse.utilities.ssl.SslUtils;

public class DExaminingSsl
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpExaminingSsl;
    private JLabel jlExaminingSsl;
    private JPanel jpProgress;
    private JProgressBar jpbExaminingSsl;
    private JPanel jpCancel;
    private JButton jbCancel;
    private String sslHost;
    private int sslPort;
    private KeyStore keyStore;
    private char[] password;
    private SslConnectionInfos sslInfos;
    private Thread examiner;

    public DExaminingSsl(JFrame parent, String sslHost, int sslPort, boolean useClientAuth, KeyStoreHistory ksh) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.sslHost = sslHost;
        this.sslPort = sslPort;
        if (useClientAuth) {
            this.keyStore = ksh.getCurrentState().getKeyStore();
            Password pwd = ksh.getCurrentState().getPassword();
            if (pwd != null) {
                this.password = pwd.toCharArray();
            }
        }
        this.initComponents();
    }

    private void initComponents() {
        this.jlExaminingSsl = new JLabel(res.getString("DExaminingSsl.jlExaminingSsl.text"));
        ImageIcon icon = new ImageIcon(this.getClass().getResource("images/exssl.png"));
        this.jlExaminingSsl.setIcon(icon);
        this.jlExaminingSsl.setHorizontalTextPosition(10);
        this.jlExaminingSsl.setIconTextGap(15);
        this.jpExaminingSsl = new JPanel(new FlowLayout(1));
        this.jpExaminingSsl.add(this.jlExaminingSsl);
        this.jpExaminingSsl.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jpbExaminingSsl = new JProgressBar();
        this.jpbExaminingSsl.setIndeterminate(true);
        this.jpProgress = new JPanel(new FlowLayout(1));
        this.jpProgress.add(this.jpbExaminingSsl);
        this.jpProgress.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jbCancel = new JButton(res.getString("DExaminingSsl.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DExaminingSsl.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DExaminingSsl.this.cancelPressed();
            }
        });
        this.jpCancel = PlatformUtil.createDialogButtonPanel(this.jbCancel);
        this.getContentPane().add((Component)this.jpExaminingSsl, "North");
        this.getContentPane().add((Component)this.jpProgress, "Center");
        this.getContentPane().add((Component)this.jpCancel, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                if (DExaminingSsl.this.examiner != null && DExaminingSsl.this.examiner.isAlive()) {
                    DExaminingSsl.this.examiner.interrupt();
                }
                DExaminingSsl.this.closeDialog();
            }
        });
        this.setTitle(res.getString("DExaminingSsl.Title"));
        this.setResizable(false);
        this.pack();
    }

    public void startExamination() {
        this.examiner = new Thread(new ExamineSsl());
        this.examiner.setPriority(1);
        this.examiner.start();
    }

    public SslConnectionInfos getSSLConnectionInfos() {
        return this.sslInfos;
    }

    private void cancelPressed() {
        if (this.examiner != null && this.examiner.isAlive()) {
            this.examiner.interrupt();
        }
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private class ExamineSsl
    implements Runnable {
        private ExamineSsl() {
        }

        @Override
        public void run() {
            try {
                DExaminingSsl.this.sslInfos = SslUtils.readSSLConnectionInfos(DExaminingSsl.this.sslHost, DExaminingSsl.this.sslPort, DExaminingSsl.this.keyStore, DExaminingSsl.this.password);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (DExaminingSsl.this.isShowing()) {
                            DExaminingSsl.this.closeDialog();
                        }
                    }
                });
            }
            catch (Exception ex) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (DExaminingSsl.this.isShowing()) {
                            String problemStr = MessageFormat.format(res.getString("DExaminingSsl.NoExamineSsl.Problem"), DExaminingSsl.this.sslHost, "" + DExaminingSsl.this.sslPort);
                            String[] causes = new String[]{res.getString("DExaminingSsl.SslHostPortIncorrect.Cause"), res.getString("DExaminingSsl.SslHostUnavailable.Cause"), res.getString("DExaminingSsl.ProxySettingsIncorrect.Cause")};
                            Problem problem = new Problem(problemStr, causes, ex);
                            DProblem dProblem = new DProblem(DExaminingSsl.this, res.getString("DExaminingSsl.ProblemExaminingSsl.Title"), problem);
                            dProblem.setLocationRelativeTo(DExaminingSsl.this);
                            dProblem.setVisible(true);
                            DExaminingSsl.this.closeDialog();
                        }
                    }
                });
            }
        }
    }
}

