/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.kse.crypto.ecc.CurveSet;
import org.kse.crypto.ecc.EccUtil;
import org.kse.crypto.keypair.KeyPairType;
import org.kse.crypto.keystore.KeyStoreType;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;
import org.kse.utilities.DialogViewer;

public class DGenerateKeyPair
extends JEscDialog {
    private static final long serialVersionUID = 7178673779995142190L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JRadioButton jrbRSA;
    private JLabel jlRSAKeySize;
    private JSpinner jspRSAKeySize;
    private JRadioButton jrbDSA;
    private JLabel jlDSAKeySize;
    private JSpinner jspDSAKeySize;
    private JRadioButton jrbEC;
    private JLabel jlECCurveSet;
    private JComboBox<String> jcbECCurveSet;
    private JLabel jlECCurve;
    private JComboBox<String> jcbECCurve;
    private JButton jbOK;
    private JButton jbCancel;
    private KeyPairType keyPairType;
    private KeyStoreType keyStoreType;
    private int keyPairSize;
    private boolean success = false;

    public DGenerateKeyPair(JFrame parent, KeyStoreType keyStoreType, KeyPairType keyPairType, int keyPairSize) {
        super((Window)parent, res.getString("DGenerateKeyPair.Title"), Dialog.ModalityType.DOCUMENT_MODAL);
        this.keyPairType = keyPairType;
        this.keyPairSize = keyPairSize;
        this.keyStoreType = keyStoreType;
        this.initComponents();
    }

    private void initComponents() {
        this.jlRSAKeySize = new JLabel(res.getString("DGenerateKeyPair.jlKeySize.text"));
        this.jspRSAKeySize = new JSpinner();
        this.jspRSAKeySize.setToolTipText(res.getString("DGenerateKeyPair.jsKeySize.tooltip"));
        this.jlDSAKeySize = new JLabel(res.getString("DGenerateKeyPair.jlKeySize.text"));
        this.jspDSAKeySize = new JSpinner();
        this.jspDSAKeySize.setToolTipText(res.getString("DGenerateKeyPair.jsKeySize.tooltip"));
        this.jrbRSA = new JRadioButton(res.getString("DGenerateKeyPair.jrbRSA.text"), false);
        PlatformUtil.setMnemonic((AbstractButton)this.jrbRSA, res.getString("DGenerateKeyPair.jrbRSA.mnemonic").charAt(0));
        this.jrbRSA.setToolTipText(res.getString("DGenerateKeyPair.jrbRSA.tooltip"));
        this.jrbDSA = new JRadioButton(res.getString("DGenerateKeyPair.jrbDSA.text"), true);
        PlatformUtil.setMnemonic((AbstractButton)this.jrbDSA, res.getString("DGenerateKeyPair.jrbDSA.mnemonic").charAt(0));
        this.jrbDSA.setToolTipText(res.getString("DGenerateKeyPair.jrbDSA.tooltip"));
        this.jrbEC = new JRadioButton(res.getString("DGenerateKeyPair.jrbEC.text"), true);
        PlatformUtil.setMnemonic((AbstractButton)this.jrbEC, res.getString("DGenerateKeyPair.jrbEC.mnemonic").charAt(0));
        if (EccUtil.isECAvailable(this.keyStoreType)) {
            this.jrbEC.setEnabled(true);
            this.jrbEC.setToolTipText(res.getString("DGenerateKeyPair.jrbEC.tooltip"));
        } else {
            this.jrbEC.setEnabled(false);
            this.jrbEC.setToolTipText(res.getString("DGenerateKeyPair.jrbEC.na.tooltip"));
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.jrbRSA);
        buttonGroup.add(this.jrbDSA);
        buttonGroup.add(this.jrbEC);
        this.jlECCurveSet = new JLabel(res.getString("DGenerateKeyPair.jlECCurveSet.text"));
        this.jlECCurveSet.setToolTipText(res.getString("DGenerateKeyPair.jlECCurveSet.tooltip"));
        this.jcbECCurveSet = new JComboBox();
        this.jcbECCurveSet.setModel(new DefaultComboBoxModel<String>(CurveSet.getAvailableSetNames(this.keyStoreType)));
        this.jcbECCurveSet.setToolTipText(res.getString("DGenerateKeyPair.jcbECCurveSet.tooltip"));
        this.jlECCurve = new JLabel(res.getString("DGenerateKeyPair.jlECCurve.text"));
        this.jlECCurve.setToolTipText(res.getString("DGenerateKeyPair.jlECCurve.tooltip"));
        this.jcbECCurve = new JComboBox();
        this.jcbECCurve.setPrototypeDisplayValue(EccUtil.findLongestCurveName());
        this.jcbECCurve.setToolTipText(res.getString("DGenerateKeyPair.jcbECCurve.tooltip"));
        this.jbCancel = new JButton(res.getString("DGenerateKeyPair.jbCancel.text"));
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbOK = new JButton(res.getString("DGenerateKeyPair.jbOK.text"));
        if (this.keyPairType == KeyPairType.RSA) {
            this.jrbRSA.setSelected(true);
        } else if (this.keyPairType == KeyPairType.DSA) {
            this.jrbDSA.setSelected(true);
        } else if (this.jrbEC.isEnabled()) {
            this.jrbDSA.setSelected(true);
        } else {
            this.jrbRSA.setSelected(true);
        }
        this.loadKeySizes(this.keyPairSize);
        this.loadECNamedCurves((String)this.jcbECCurveSet.getModel().getSelectedItem());
        this.enableDisableElements();
        JPanel jpContent = new JPanel();
        jpContent.setBorder(new TitledBorder(new EtchedBorder(), res.getString("DGenerateKeyPair.jpContent.text")));
        JPanel buttons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout((LayoutManager)new MigLayout("fill", "", "para[]"));
        this.getContentPane().add((Component)jpContent, "wrap unrel");
        this.getContentPane().add((Component)buttons, "growx");
        jpContent.setLayout((LayoutManager)new MigLayout("insets dialog, ", "[][right][]", "[]unrel[]"));
        jpContent.add((Component)this.jrbRSA, "");
        jpContent.add((Component)this.jlRSAKeySize, "");
        jpContent.add((Component)this.jspRSAKeySize, "growx, wrap");
        jpContent.add((Component)this.jrbDSA, "");
        jpContent.add((Component)this.jlDSAKeySize, "");
        jpContent.add((Component)this.jspDSAKeySize, "growx, wrap");
        jpContent.add((Component)this.jrbEC, "");
        jpContent.add((Component)this.jlECCurveSet, "");
        jpContent.add(this.jcbECCurveSet, "growx, wrap");
        jpContent.add((Component)this.jlECCurve, "skip");
        jpContent.add(this.jcbECCurve, "growx");
        this.jcbECCurveSet.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DGenerateKeyPair.this.loadECNamedCurves((String)DGenerateKeyPair.this.jcbECCurveSet.getModel().getSelectedItem());
            }
        });
        this.jrbRSA.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DGenerateKeyPair.this.enableDisableElements();
            }
        });
        this.jrbDSA.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DGenerateKeyPair.this.enableDisableElements();
            }
        });
        this.jrbEC.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DGenerateKeyPair.this.enableDisableElements();
            }
        });
        this.jspRSAKeySize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DGenerateKeyPair.this.correctKeyPairSize();
            }
        });
        this.jspDSAKeySize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DGenerateKeyPair.this.correctKeyPairSize();
            }
        });
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DGenerateKeyPair.this.okPressed();
            }
        });
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DGenerateKeyPair.this.cancelPressed();
            }
        });
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DGenerateKeyPair.this.cancelPressed();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DGenerateKeyPair.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void loadECNamedCurves(String curveSet) {
        CurveSet set = CurveSet.resolveName(curveSet);
        List<String> curveNames = set.getAvailableCurveNames(this.keyStoreType);
        Collections.sort(curveNames);
        this.jcbECCurve.setModel(new DefaultComboBoxModel<String>(curveNames.toArray(new String[curveNames.size()])));
    }

    protected void enableDisableElements() {
        KeyPairType keyPairType = this.getKeyPairType();
        this.jlRSAKeySize.setEnabled(keyPairType == KeyPairType.RSA);
        this.jspRSAKeySize.setEnabled(keyPairType == KeyPairType.RSA);
        this.jlDSAKeySize.setEnabled(keyPairType == KeyPairType.DSA);
        this.jspDSAKeySize.setEnabled(keyPairType == KeyPairType.DSA);
        this.jlECCurve.setEnabled(keyPairType == KeyPairType.EC);
        this.jcbECCurve.setEnabled(keyPairType == KeyPairType.EC);
        this.jlECCurveSet.setEnabled(keyPairType == KeyPairType.EC);
        this.jcbECCurveSet.setEnabled(keyPairType == KeyPairType.EC);
    }

    private void loadKeySizes(int keyPairSize) {
        KeyPairType keyPairType = KeyPairType.RSA;
        keyPairSize = this.validateKeyPairSize(keyPairType, keyPairSize);
        this.jspRSAKeySize.setModel(new SpinnerNumberModel(keyPairSize, keyPairType.minSize(), keyPairType.maxSize(), keyPairType.stepSize()));
        keyPairType = KeyPairType.DSA;
        keyPairSize = this.validateKeyPairSize(keyPairType, keyPairSize);
        this.jspDSAKeySize.setModel(new SpinnerNumberModel(keyPairSize, keyPairType.minSize(), keyPairType.maxSize(), keyPairType.stepSize()));
    }

    private void correctKeyPairSize() {
        int keyPairSize;
        KeyPairType keyPairType = this.getKeyPairType();
        int validatedKeyPairSize = this.validateKeyPairSize(keyPairType, keyPairSize = this.getKeyPairSize());
        if (validatedKeyPairSize != keyPairSize) {
            if (keyPairType == KeyPairType.RSA) {
                this.jspRSAKeySize.getModel().setValue(validatedKeyPairSize);
            } else if (keyPairType == KeyPairType.DSA) {
                this.jspDSAKeySize.getModel().setValue(validatedKeyPairSize);
            }
        }
    }

    private int validateKeyPairSize(KeyPairType keyPairType, int keyPairSize) {
        int maxSize;
        int minSize;
        int stepSize = keyPairType.stepSize();
        if (keyPairSize % stepSize != 0) {
            int difference = keyPairSize % stepSize;
            keyPairSize = difference <= stepSize / 2 ? (keyPairSize -= difference) : (keyPairSize += stepSize - difference);
        }
        if (keyPairSize < (minSize = keyPairType.minSize())) {
            keyPairSize = minSize;
        }
        if (keyPairSize > (maxSize = keyPairType.maxSize())) {
            keyPairSize = maxSize;
        }
        return keyPairSize;
    }

    public int getKeyPairSize() {
        if (this.getKeyPairType() == KeyPairType.RSA) {
            return ((Number)this.jspRSAKeySize.getValue()).intValue();
        }
        if (this.getKeyPairType() == KeyPairType.DSA) {
            return ((Number)this.jspDSAKeySize.getValue()).intValue();
        }
        return this.keyPairSize;
    }

    public String getCurveName() {
        return (String)this.jcbECCurve.getModel().getSelectedItem();
    }

    public KeyPairType getKeyPairType() {
        if (this.jrbRSA.isSelected()) {
            return KeyPairType.RSA;
        }
        if (this.jrbDSA.isSelected()) {
            return KeyPairType.DSA;
        }
        return KeyPairType.EC;
    }

    public boolean isSuccessful() {
        return this.success;
    }

    private void okPressed() {
        this.success = true;
        this.closeDialog();
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) throws Exception {
        DGenerateKeyPair dialog = new DGenerateKeyPair(new JFrame(), KeyStoreType.JKS, KeyPairType.RSA, 1024);
        DialogViewer.run(dialog);
    }
}

