/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.kse.crypto.CryptoException;
import org.kse.crypto.csr.pkcs10.Pkcs10Util;
import org.kse.crypto.privatekey.Pkcs8Util;
import org.kse.crypto.publickey.OpenSslPubUtil;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.CursorUtil;
import org.kse.gui.FileChooserFactory;
import org.kse.gui.JEscDialog;
import org.kse.gui.JavaFXFileChooser;
import org.kse.gui.LnfUtil;
import org.kse.gui.PlatformUtil;
import org.kse.gui.error.DError;
import org.kse.utilities.DialogViewer;
import org.kse.utilities.io.IOUtils;

public class DViewPem
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/resources");
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCopy;
    private JButton jbExport;
    private JPanel jpPem;
    private JScrollPane jspPem;
    private JTextArea jtaPem;
    private X509Certificate cert;
    private PKCS10CertificationRequest pkcs10Csr;
    private PrivateKey privKey;
    private PublicKey pubKey;

    public DViewPem(JFrame parent, String title, X509Certificate cert) throws CryptoException {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.cert = cert;
        this.initComponents();
    }

    public DViewPem(JDialog parent, String title, X509Certificate cert) throws CryptoException {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.cert = cert;
        this.initComponents();
    }

    public DViewPem(JFrame parent, String title, PKCS10CertificationRequest pkcs10Csr) throws CryptoException {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.pkcs10Csr = pkcs10Csr;
        this.initComponents();
    }

    public DViewPem(JDialog parent, String title, PKCS10CertificationRequest pkcs10Csr) throws CryptoException {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.pkcs10Csr = pkcs10Csr;
        this.initComponents();
    }

    public DViewPem(JFrame parent, String title, PrivateKey privateKey) throws CryptoException {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.privKey = privateKey;
        this.initComponents();
    }

    public DViewPem(JDialog parent, String title, PrivateKey privateKey) throws CryptoException {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.privKey = privateKey;
        this.initComponents();
    }

    public DViewPem(JFrame parent, String title, PublicKey publicKey) throws CryptoException {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.pubKey = publicKey;
        this.initComponents();
    }

    public DViewPem(JDialog parent, String title, PublicKey publicKey) throws CryptoException {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.pubKey = publicKey;
        this.initComponents();
    }

    private void initComponents() throws CryptoException {
        this.jbOK = new JButton(res.getString("DViewPem.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DViewPem.this.okPressed();
            }
        });
        this.jbCopy = new JButton(res.getString("DViewPem.jbCopy.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbCopy, res.getString("DViewPem.jbCopy.mnemonic").charAt(0));
        this.jbCopy.setToolTipText(res.getString("DViewPem.jbCopy.tooltip"));
        this.jbCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewPem.this);
                    DViewPem.this.copyPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewPem.this);
                }
            }
        });
        this.jbExport = new JButton(res.getString("DViewPem.jbExport.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbExport, res.getString("DViewPem.jbExport.mnemonic").charAt(0));
        this.jbExport.setToolTipText(res.getString("DViewPem.jbExport.tooltip"));
        this.jbExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewPem.this);
                    DViewPem.this.exportPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewPem.this);
                }
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, null, new JButton[]{this.jbCopy, this.jbExport});
        this.jpPem = new JPanel(new BorderLayout());
        this.jpPem.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jtaPem = new JTextArea(this.getPemString());
        this.jtaPem.setCaretPosition(0);
        this.jtaPem.setEditable(false);
        this.jtaPem.setFont(new Font("Monospaced", 0, LnfUtil.getDefaultFontSize()));
        this.jtaPem.putClientProperty("JTextArea.infoBackground", Boolean.TRUE);
        this.jspPem = PlatformUtil.createScrollPane(this.jtaPem, 22, 32);
        this.jspPem.setPreferredSize(new Dimension(600, 300));
        this.jpPem.add((Component)this.jspPem, "Center");
        this.getContentPane().add((Component)this.jpPem, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DViewPem.this.closeDialog();
            }
        });
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DViewPem.this.jbOK.requestFocus();
            }
        });
    }

    private String getPemString() throws CryptoException {
        if (this.cert != null) {
            return X509CertUtil.getCertEncodedX509Pem(this.cert);
        }
        if (this.pkcs10Csr != null) {
            return Pkcs10Util.getCsrEncodedDerPem(this.pkcs10Csr);
        }
        if (this.privKey != null) {
            return Pkcs8Util.getPem(this.privKey);
        }
        if (this.pubKey != null) {
            return OpenSslPubUtil.getPem(this.pubKey);
        }
        return "";
    }

    private void okPressed() {
        this.closeDialog();
    }

    private void copyPressed() {
        String policy = this.jtaPem.getText();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection copy = new StringSelection(policy);
        clipboard.setContents(copy, copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportPressed() {
        File chosenFile = null;
        FileWriter fw = null;
        String title = res.getString("DViewPem.ExportPem.Title");
        try {
            String message;
            int selected;
            int rtnValue;
            String certPem = this.jtaPem.getText();
            JFileChooser chooser = FileChooserFactory.getX509FileChooser();
            chooser.setCurrentDirectory(CurrentDirectory.get());
            chooser.setDialogTitle(title);
            chooser.setMultiSelectionEnabled(false);
            int n = rtnValue = JavaFXFileChooser.isFxAvailable() ? chooser.showSaveDialog(this) : chooser.showDialog(this, res.getString("DViewPem.ChooseExportFile.button"));
            if (rtnValue != 0) {
                return;
            }
            chosenFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(chosenFile);
            if (chosenFile.isFile() && (selected = JOptionPane.showConfirmDialog(this, message = MessageFormat.format(res.getString("DViewPem.OverWriteFile.message"), chosenFile), title, 0)) != 0) {
                IOUtils.closeQuietly(fw);
                return;
            }
            fw = new FileWriter(chosenFile);
            fw.write(certPem);
            IOUtils.closeQuietly(fw);
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(res.getString("DViewPem.NoWriteFile.message"), chosenFile), title, 2);
            return;
        }
        catch (Exception ex) {
            DError.displayError(this, (Throwable)ex);
            return;
        }
        finally {
            IOUtils.closeQuietly(fw);
        }
        JOptionPane.showMessageDialog(this, res.getString("DViewPem.ExportPemCertificateSuccessful.message"), title, 1);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA", "BC");
        KeyPair keyPair = keyGen.genKeyPair();
        JcaPKCS10CertificationRequestBuilder csrBuilder = new JcaPKCS10CertificationRequestBuilder(new X500Name("cn=test"), keyPair.getPublic());
        PKCS10CertificationRequest csr = csrBuilder.build(new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(keyPair.getPrivate()));
        DViewPem dialog = new DViewPem(new JFrame(), "Title", csr);
        DialogViewer.run(dialog);
    }
}

