/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.kse.crypto.CryptoException;
import org.kse.crypto.KeyInfo;
import org.kse.crypto.keypair.KeyPairUtil;
import org.kse.gui.CursorUtil;
import org.kse.gui.JEscDialog;
import org.kse.gui.LnfUtil;
import org.kse.gui.PlatformUtil;
import org.kse.gui.dialogs.DViewAsn1Dump;
import org.kse.gui.dialogs.DViewAsymmetricKeyFields;
import org.kse.gui.dialogs.DViewPem;
import org.kse.gui.error.DError;
import org.kse.utilities.DialogViewer;
import org.kse.utilities.asn1.Asn1Exception;

public class DViewPrivateKey
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/resources");
    private JLabel jlAlgorithm;
    private JTextField jtfAlgorithm;
    private JLabel jlKeySize;
    private JTextField jtfKeySize;
    private JLabel jlFormat;
    private JTextField jtfFormat;
    private JLabel jlEncoded;
    private JTextArea jtaEncoded;
    private JScrollPane jspEncoded;
    private JButton jbPem;
    private JButton jbFields;
    private JButton jbAsn1;
    private JButton jbOK;
    private PrivateKey privateKey;

    public DViewPrivateKey(JFrame parent, String title, PrivateKey privateKey) throws CryptoException {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.privateKey = privateKey;
        this.initComponents();
    }

    public DViewPrivateKey(JDialog parent, String title, PrivateKey privateKey) throws CryptoException {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.privateKey = privateKey;
        this.initComponents();
    }

    private void initComponents() throws CryptoException {
        this.jlAlgorithm = new JLabel(res.getString("DViewPrivateKey.jlAlgorithm.text"));
        this.jtfAlgorithm = new JTextField();
        this.jtfAlgorithm.setEditable(false);
        this.jtfAlgorithm.setToolTipText(res.getString("DViewPrivateKey.jtfAlgorithm.tooltip"));
        this.jlKeySize = new JLabel(res.getString("DViewPrivateKey.jlKeySize.text"));
        this.jtfKeySize = new JTextField();
        this.jtfKeySize.setEditable(false);
        this.jtfKeySize.setToolTipText(res.getString("DViewPrivateKey.jtfKeySize.tooltip"));
        this.jlFormat = new JLabel(res.getString("DViewPrivateKey.jlFormat.text"));
        this.jtfFormat = new JTextField();
        this.jtfFormat.setEditable(false);
        this.jtfFormat.setToolTipText(res.getString("DViewPrivateKey.jtfFormat.tooltip"));
        this.jlEncoded = new JLabel(res.getString("DViewPrivateKey.jlEncoded.text"));
        this.jtaEncoded = new JTextArea();
        this.jtaEncoded.setFont(new Font("Monospaced", 0, LnfUtil.getDefaultFontSize()));
        this.jtaEncoded.setBackground(this.jtfFormat.getBackground());
        this.jtaEncoded.setEditable(false);
        this.jtaEncoded.setLineWrap(true);
        this.jtaEncoded.setToolTipText(res.getString("DViewPrivateKey.jtfEncoded.tooltip"));
        this.jspEncoded = PlatformUtil.createScrollPane(this.jtaEncoded, 20, 31);
        this.jspEncoded.setBorder(this.jtfFormat.getBorder());
        this.jbPem = new JButton(res.getString("DViewPrivateKey.jbPem.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbPem, res.getString("DViewPrivateKey.jbPem.mnemonic").charAt(0));
        this.jbPem.setToolTipText(res.getString("DViewPrivateKey.jbPem.tooltip"));
        this.jbFields = new JButton(res.getString("DViewPrivateKey.jbFields.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbFields, res.getString("DViewPrivateKey.jbFields.mnemonic").charAt(0));
        this.jbFields.setToolTipText(res.getString("DViewPrivateKey.jbFields.tooltip"));
        this.jbAsn1 = new JButton(res.getString("DViewPrivateKey.jbAsn1.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbAsn1, res.getString("DViewPrivateKey.jbAsn1.mnemonic").charAt(0));
        this.jbAsn1.setToolTipText(res.getString("DViewPrivateKey.jbAsn1.tooltip"));
        this.jbOK = new JButton(res.getString("DViewPrivateKey.jbOK.text"));
        Container pane = this.getContentPane();
        pane.setLayout((LayoutManager)new MigLayout("insets dialog", "[right]unrel[]", "[]unrel[]"));
        pane.add((Component)this.jlAlgorithm, "");
        pane.add((Component)this.jtfAlgorithm, "growx, pushx, wrap");
        pane.add((Component)this.jlKeySize, "");
        pane.add((Component)this.jtfKeySize, "growx, pushx, wrap");
        pane.add((Component)this.jlFormat, "");
        pane.add((Component)this.jtfFormat, "growx, pushx, wrap");
        pane.add((Component)this.jlEncoded, "");
        pane.add((Component)this.jspEncoded, "width 300lp:300lp:300lp, height 100lp:100lp:100lp, wrap");
        pane.add((Component)this.jbPem, "spanx, split");
        pane.add((Component)this.jbFields, "");
        pane.add((Component)this.jbAsn1, "wrap");
        pane.add((Component)new JSeparator(), "spanx, growx, wrap unrel:push");
        pane.add((Component)this.jbOK, "spanx, tag ok");
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DViewPrivateKey.this.okPressed();
            }
        });
        this.jbPem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewPrivateKey.this);
                    DViewPrivateKey.this.pemEncodingPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewPrivateKey.this);
                }
            }
        });
        this.jbFields.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewPrivateKey.this);
                    DViewPrivateKey.this.fieldsPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewPrivateKey.this);
                }
            }
        });
        this.jbAsn1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewPrivateKey.this);
                    DViewPrivateKey.this.asn1DumpPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewPrivateKey.this);
                }
            }
        });
        this.setResizable(false);
        this.populateDialog();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DViewPrivateKey.this.closeDialog();
            }
        });
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DViewPrivateKey.this.jbOK.requestFocus();
            }
        });
    }

    private void populateDialog() throws CryptoException {
        KeyInfo keyInfo = KeyPairUtil.getKeyInfo(this.privateKey);
        this.jtfAlgorithm.setText(keyInfo.getAlgorithm());
        Integer keyLength = keyInfo.getSize();
        if (keyLength != null) {
            this.jtfKeySize.setText(MessageFormat.format(res.getString("DViewPrivateKey.jtfKeySize.text"), "" + keyLength));
        } else {
            this.jtfKeySize.setText(MessageFormat.format(res.getString("DViewPrivateKey.jtfKeySize.text"), "?"));
        }
        this.jtfFormat.setText(this.privateKey.getFormat());
        this.jtaEncoded.setText(new BigInteger(1, this.privateKey.getEncoded()).toString(16).toUpperCase());
        this.jtaEncoded.setCaretPosition(0);
        if (this.privateKey instanceof RSAPrivateKey || this.privateKey instanceof DSAPrivateKey) {
            this.jbFields.setEnabled(true);
        } else {
            this.jbFields.setEnabled(false);
        }
    }

    private void pemEncodingPressed() {
        try {
            DViewPem dViewCsrPem = new DViewPem((JDialog)this, res.getString("DViewPrivateKey.Pem.Title"), this.privateKey);
            dViewCsrPem.setLocationRelativeTo(this);
            dViewCsrPem.setVisible(true);
        }
        catch (CryptoException e) {
            DError.displayError(this, (Throwable)e);
        }
    }

    private void fieldsPressed() {
        if (this.privateKey instanceof RSAPrivateKey) {
            RSAPrivateKey rsaPvk = (RSAPrivateKey)this.privateKey;
            DViewAsymmetricKeyFields dViewAsymmetricKeyFields = new DViewAsymmetricKeyFields((JDialog)this, res.getString("DViewPrivateKey.RsaFields.Title"), rsaPvk);
            dViewAsymmetricKeyFields.setLocationRelativeTo(this);
            dViewAsymmetricKeyFields.setVisible(true);
        } else if (this.privateKey instanceof DSAPrivateKey) {
            DSAPrivateKey dsaPvk = (DSAPrivateKey)this.privateKey;
            DViewAsymmetricKeyFields dViewAsymmetricKeyFields = new DViewAsymmetricKeyFields((JDialog)this, res.getString("DViewPrivateKey.DsaFields.Title"), dsaPvk);
            dViewAsymmetricKeyFields.setLocationRelativeTo(this);
            dViewAsymmetricKeyFields.setVisible(true);
        }
    }

    private void asn1DumpPressed() {
        try {
            DViewAsn1Dump dViewAsn1Dump = new DViewAsn1Dump((JDialog)this, this.privateKey);
            dViewAsn1Dump.setLocationRelativeTo(this);
            dViewAsn1Dump.setVisible(true);
        }
        catch (IOException | Asn1Exception e) {
            DError.displayError(this, (Throwable)e);
        }
    }

    private void okPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("EC", "BC");
        KeyPair keyPair = keyGen.genKeyPair();
        PrivateKey privKey = keyPair.getPrivate();
        DViewPrivateKey dialog = new DViewPrivateKey(new JFrame(), "Title", privKey);
        DialogViewer.run(dialog);
    }
}

