/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;
import org.kse.crypto.CryptoException;
import org.kse.crypto.KeyInfo;
import org.kse.crypto.secretkey.SecretKeyType;
import org.kse.crypto.secretkey.SecretKeyUtil;
import org.kse.gui.JEscDialog;
import org.kse.gui.LnfUtil;
import org.kse.gui.PlatformUtil;
import org.kse.utilities.DialogViewer;

public class DViewSecretKey
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/resources");
    private JLabel jlAlgorithm;
    private JTextField jtfAlgorithm;
    private JLabel jlKeySize;
    private JTextField jtfKeySize;
    private JLabel jlFormat;
    private JTextField jtfFormat;
    private JLabel jlEncoded;
    private JTextArea jtaEncoded;
    private JScrollPane jspEncoded;
    private JButton jbCancel;
    private JButton jbOK;
    private SecretKey secretKey;
    private boolean editable;
    private boolean keyHasChanged = false;

    public DViewSecretKey(JFrame parent, String title, SecretKey secretKey, boolean editable) {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.secretKey = secretKey;
        this.editable = editable;
        this.initComponents();
    }

    public DViewSecretKey(JDialog parent, String title, Dialog.ModalityType modality, SecretKey secretKey, boolean editable) throws CryptoException {
        super((Window)parent, title, modality);
        this.secretKey = secretKey;
        this.editable = editable;
        this.initComponents();
    }

    private void initComponents() {
        this.jlAlgorithm = new JLabel(res.getString("DViewSecretKey.jlAlgorithm.text"));
        this.jtfAlgorithm = new JTextField();
        this.jtfAlgorithm.setEditable(false);
        this.jtfAlgorithm.setToolTipText(res.getString("DViewSecretKey.jtfAlgorithm.tooltip"));
        this.jlKeySize = new JLabel(res.getString("DViewSecretKey.jlKeySize.text"));
        this.jtfKeySize = new JTextField();
        this.jtfKeySize.setEditable(false);
        this.jtfKeySize.setToolTipText(res.getString("DViewSecretKey.jtfKeySize.tooltip"));
        this.jlFormat = new JLabel(res.getString("DViewSecretKey.jlFormat.text"));
        this.jtfFormat = new JTextField();
        this.jtfFormat.setEditable(false);
        this.jtfFormat.setToolTipText(res.getString("DViewSecretKey.jtfFormat.tooltip"));
        this.jlEncoded = new JLabel(res.getString("DViewSecretKey.jlEncoded.text"));
        this.jtaEncoded = new JTextArea();
        this.jtaEncoded.setFont(new Font("Monospaced", 0, LnfUtil.getDefaultFontSize()));
        if (!this.editable) {
            this.jtaEncoded.setBackground(this.jtfFormat.getBackground());
        }
        this.jtaEncoded.setEditable(this.editable);
        this.jtaEncoded.setLineWrap(true);
        this.jtaEncoded.putClientProperty("JTextArea.infoBackground", Boolean.TRUE);
        this.jtaEncoded.setToolTipText(res.getString("DViewSecretKey.jtfEncoded.tooltip"));
        this.jspEncoded = PlatformUtil.createScrollPane(this.jtaEncoded, 20, 31);
        this.jspEncoded.setBorder(this.jtfFormat.getBorder());
        this.jbCancel = new JButton(res.getString("DViewSecretKey.jbCancel.text"));
        this.jbOK = new JButton(res.getString("DViewSecretKey.jbOK.text"));
        Container pane = this.getContentPane();
        pane.setLayout((LayoutManager)new MigLayout("insets dialog, fill", "[right]unrel[]", "[]unrel[]"));
        pane.add((Component)this.jlAlgorithm, "");
        pane.add((Component)this.jtfAlgorithm, "growx, pushx, wrap");
        pane.add((Component)this.jlKeySize, "");
        pane.add((Component)this.jtfKeySize, "growx, pushx, wrap");
        pane.add((Component)this.jlFormat, "");
        pane.add((Component)this.jtfFormat, "growx, pushx, wrap");
        pane.add((Component)this.jlEncoded, "");
        pane.add((Component)this.jspEncoded, "width 260lp:260lp:260lp, height 50lp:50lp:50lp, wrap");
        pane.add((Component)new JSeparator(), "spanx, growx, wrap rel:push");
        if (this.editable) {
            pane.add((Component)this.jbCancel, "spanx, split 2, tag cancel");
            pane.add((Component)this.jbOK, "tag ok");
        } else {
            pane.add((Component)this.jbOK, "spanx, tag ok");
        }
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DViewSecretKey.this.okPressed();
            }
        });
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DViewSecretKey.this.cancelPressed();
            }
        });
        this.setResizable(false);
        this.populateDialog();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DViewSecretKey.this.closeDialog();
            }
        });
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DViewSecretKey.this.jbOK.requestFocus();
            }
        });
    }

    private void populateDialog() {
        KeyInfo keyInfo = SecretKeyUtil.getKeyInfo(this.secretKey);
        String algorithm = keyInfo.getAlgorithm();
        SecretKeyType secretKeyType = SecretKeyType.resolveJce(algorithm);
        if (secretKeyType != null) {
            algorithm = secretKeyType.friendly();
        }
        this.jtfAlgorithm.setText(algorithm);
        Integer keyLength = keyInfo.getSize();
        if (keyLength != null) {
            this.jtfKeySize.setText(MessageFormat.format(res.getString("DViewSecretKey.jtfKeySize.text"), "" + keyLength));
        } else {
            this.jtfKeySize.setText(MessageFormat.format(res.getString("DViewSecretKey.jtfKeySize.text"), "?"));
        }
        this.jtfFormat.setText(this.secretKey.getFormat());
        this.jtaEncoded.setText(new BigInteger(1, this.secretKey.getEncoded()).toString(16).toUpperCase());
        this.jtaEncoded.setCaretPosition(0);
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void okPressed() {
        if (this.editable) {
            String text = this.jtaEncoded.getText();
            try {
                byte[] newKeyRaw = Hex.decode((String)text.replace(':', ' '));
                SecretKeySpec newKey = new SecretKeySpec(newKeyRaw, 0, newKeyRaw.length, this.secretKey.getAlgorithm());
                this.secretKey = newKey;
                this.keyHasChanged = true;
            }
            catch (DecoderException e) {
                JOptionPane.showMessageDialog(this, res.getString("DViewSecretKey.NotAValidHexString.message"), this.getTitle(), 0);
                return;
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
                JOptionPane.showMessageDialog(this, res.getString("DViewSecretKey.NotAValidKey.message"), this.getTitle(), 0);
                return;
            }
        }
        this.closeDialog();
    }

    public boolean keyHasChanged() {
        return this.keyHasChanged;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) throws Exception {
        SecretKey secretKey = SecretKeyUtil.generateSecretKey(SecretKeyType.AES, 256);
        DViewSecretKey dialog = new DViewSecretKey(new JFrame(), "Generate Secret Key", secretKey, true);
        DialogViewer.run(dialog);
    }
}

