/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.io.IOException;
import java.util.ResourceBundle;
import java.util.concurrent.CancellationException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.swing.JFrame;
import org.kse.crypto.Password;
import org.kse.gui.password.DGetPassword;

public class PasswordCallbackHandler
implements CallbackHandler {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/resources");
    private JFrame frame;

    public PasswordCallbackHandler(JFrame frame) {
        this.frame = frame;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof PasswordCallback)) {
                throw new UnsupportedCallbackException(callbacks[i], "Callback not supported " + callbacks[i].getClass().getName());
            }
            this.handlePasswordCallback((PasswordCallback)callbacks[i]);
        }
    }

    private void handlePasswordCallback(PasswordCallback passCb) throws UnsupportedCallbackException {
        DGetPassword dGetPassword = new DGetPassword(this.frame, res.getString("PasswordCallbackHandler.Title"));
        dGetPassword.setLocationRelativeTo(this.frame);
        dGetPassword.setVisible(true);
        Password password = dGetPassword.getPassword();
        if (password == null) {
            throw new CancellationException("Password Callback canceled by user");
        }
        passCb.setPassword(password.toCharArray());
    }
}

