/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.extensions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.kse.gui.PlatformUtil;
import org.kse.gui.dialogs.extensions.DExtension;
import org.kse.gui.error.DError;

public class DBasicConstraints
extends DExtension {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/extensions/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpBasicConstraints;
    private JLabel jlBasicConstraints;
    private JCheckBox jcbSubjectIsCa;
    private JPanel jpPathLengthConstraint;
    private JLabel jlPathLengthConstraint;
    private JTextField jtfPathLengthConstraint;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private byte[] value;

    public DBasicConstraints(JDialog parent) {
        super(parent);
        this.setTitle(res.getString("DBasicConstraints.Title"));
        this.initComponents();
    }

    public DBasicConstraints(JDialog parent, byte[] value) throws IOException {
        super(parent);
        this.setTitle(res.getString("DBasicConstraints.Title"));
        this.initComponents();
        this.prepopulateWithValue(value);
    }

    private void initComponents() {
        this.jlBasicConstraints = new JLabel(res.getString("DBasicConstraints.jlBasicConstraints.text"));
        this.jlBasicConstraints.setBorder(new EmptyBorder(5, 5, 0, 5));
        this.jcbSubjectIsCa = new JCheckBox(res.getString("DBasicConstraints.jcbSubjectIsCa.text"));
        this.jcbSubjectIsCa.setSelected(false);
        this.jcbSubjectIsCa.setBorder(new EmptyBorder(5, 5, 0, 5));
        this.jlPathLengthConstraint = new JLabel(res.getString("DBasicConstraints.jlPathLengthConstraint.text"));
        this.jtfPathLengthConstraint = new JTextField(3);
        this.jpPathLengthConstraint = new JPanel(new FlowLayout(0, 5, 5));
        this.jpPathLengthConstraint.add(this.jlPathLengthConstraint);
        this.jpPathLengthConstraint.add(this.jtfPathLengthConstraint);
        this.jpBasicConstraints = new JPanel(new BorderLayout(5, 5));
        this.jpBasicConstraints.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        this.jpBasicConstraints.add((Component)this.jlBasicConstraints, "North");
        this.jpBasicConstraints.add((Component)this.jcbSubjectIsCa, "Center");
        this.jpBasicConstraints.add((Component)this.jpPathLengthConstraint, "South");
        this.jbOK = new JButton(res.getString("DBasicConstraints.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBasicConstraints.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DBasicConstraints.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBasicConstraints.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBasicConstraints.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpBasicConstraints, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DBasicConstraints.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void prepopulateWithValue(byte[] value) throws IOException {
        BasicConstraints basicConstraints = BasicConstraints.getInstance((Object)value);
        this.jcbSubjectIsCa.setSelected(basicConstraints.isCA());
        if (basicConstraints.getPathLenConstraint() != null) {
            this.jtfPathLengthConstraint.setText("" + basicConstraints.getPathLenConstraint().intValue());
            this.jtfPathLengthConstraint.setCaretPosition(0);
        }
    }

    private void okPressed() {
        boolean ca = this.jcbSubjectIsCa.isSelected();
        int pathLengthConstraint = -1;
        String pathLengthConstraintStr = this.jtfPathLengthConstraint.getText().trim();
        if (pathLengthConstraintStr.length() > 0) {
            try {
                pathLengthConstraint = Integer.parseInt(pathLengthConstraintStr);
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, res.getString("DBasicConstraints.InvalidLengthValue.message"), this.getTitle(), 2);
                return;
            }
            if (pathLengthConstraint < 0) {
                JOptionPane.showMessageDialog(this, res.getString("DBasicConstraints.InvalidLengthValue.message"), this.getTitle(), 2);
                return;
            }
        }
        BasicConstraints basicConstraints = pathLengthConstraint != -1 ? new BasicConstraints(pathLengthConstraint) : new BasicConstraints(ca);
        try {
            this.value = basicConstraints.getEncoded("DER");
        }
        catch (IOException e) {
            DError.displayError(this, (Throwable)e);
            return;
        }
        this.closeDialog();
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

