/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.extensions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;
import org.kse.gui.crypto.customextkeyusage.JCustomExtendedKeyUsage;

public class DCustomExtKeyUsage
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/extensions/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpCustomExtendedKeyUsage;
    private JLabel jlCustomExtendedKeyUsage;
    private JCustomExtendedKeyUsage jCustomExtendedKeyUsage;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private Set<ASN1ObjectIdentifier> customExtUsageOids;

    public DCustomExtKeyUsage(JDialog parent, Set<ASN1ObjectIdentifier> customExtUsageOids) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.setTitle(res.getString("DCustomExtendedKeyUsage.Title"));
        this.customExtUsageOids = customExtUsageOids;
        this.initComponents();
        this.prepopulateWithOidList(customExtUsageOids);
    }

    private void initComponents() {
        this.jlCustomExtendedKeyUsage = new JLabel(res.getString("DCustomExtendedKeyUsage.jlCustomExtendedKeyUsage.text"));
        GridBagConstraints gbc_jlCustomExtendedKeyUsage = new GridBagConstraints();
        gbc_jlCustomExtendedKeyUsage.gridx = 0;
        gbc_jlCustomExtendedKeyUsage.gridy = 1;
        gbc_jlCustomExtendedKeyUsage.gridwidth = 1;
        gbc_jlCustomExtendedKeyUsage.gridheight = 1;
        gbc_jlCustomExtendedKeyUsage.insets = new Insets(5, 5, 5, 5);
        gbc_jlCustomExtendedKeyUsage.anchor = 12;
        this.jCustomExtendedKeyUsage = new JCustomExtendedKeyUsage(res.getString("DCustomExtendedKeyUsage.jCustomExtendedKeyUsage.text"));
        this.jCustomExtendedKeyUsage.setPreferredSize(new Dimension(400, 150));
        GridBagConstraints gbc_jpiCustomExtendedKeyUsage = new GridBagConstraints();
        gbc_jpiCustomExtendedKeyUsage.gridx = 1;
        gbc_jpiCustomExtendedKeyUsage.gridy = 1;
        gbc_jpiCustomExtendedKeyUsage.gridwidth = 1;
        gbc_jpiCustomExtendedKeyUsage.gridheight = 1;
        gbc_jpiCustomExtendedKeyUsage.insets = new Insets(5, 5, 5, 5);
        gbc_jpiCustomExtendedKeyUsage.anchor = 17;
        this.jpCustomExtendedKeyUsage = new JPanel(new GridBagLayout());
        this.jpCustomExtendedKeyUsage.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new EtchedBorder()));
        this.jpCustomExtendedKeyUsage.add((Component)this.jlCustomExtendedKeyUsage, gbc_jlCustomExtendedKeyUsage);
        this.jpCustomExtendedKeyUsage.add((Component)this.jCustomExtendedKeyUsage, gbc_jpiCustomExtendedKeyUsage);
        this.jbOK = new JButton(res.getString("DCustomExtendedKeyUsage.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DCustomExtKeyUsage.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DCustomExtendedKeyUsage.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DCustomExtKeyUsage.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DCustomExtKeyUsage.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpCustomExtendedKeyUsage, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DCustomExtKeyUsage.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void prepopulateWithOidList(Set<ASN1ObjectIdentifier> customExtKeyUsageOids) {
        HashSet<ASN1ObjectIdentifier> oids = new HashSet<ASN1ObjectIdentifier>();
        oids.addAll(customExtKeyUsageOids);
        this.jCustomExtendedKeyUsage.setCustomExtKeyUsages(oids);
    }

    private void okPressed() {
        Set<ASN1ObjectIdentifier> objectIds = this.jCustomExtendedKeyUsage.getCustomExtKeyUsages();
        if (objectIds.size() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DCustomExtendedKeyUsage.ValueReq.message"), this.getTitle(), 2);
            return;
        }
        this.customExtUsageOids = objectIds;
        this.closeDialog();
    }

    public Set<ASN1ObjectIdentifier> getObjectIds() {
        return this.customExtUsageOids;
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

