/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.extensions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.PrivateKeyUsagePeriod;
import org.kse.gui.PlatformUtil;
import org.kse.gui.datetime.JDateTime;
import org.kse.gui.dialogs.extensions.DExtension;
import org.kse.gui.error.DError;

public class DPrivateKeyUsagePeriod
extends DExtension {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/extensions/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpPrivateKeyUsagePeriod;
    private JLabel jlNotBefore;
    private JDateTime jdtNotBefore;
    private JLabel jlNotAfter;
    private JDateTime jdtNotAfter;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private byte[] value;

    public DPrivateKeyUsagePeriod(JDialog parent) {
        super(parent);
        this.setTitle(res.getString("DPrivateKeyUsagePeriod.Title"));
        this.initComponents();
    }

    public DPrivateKeyUsagePeriod(JDialog parent, byte[] value) throws IOException {
        super(parent);
        this.setTitle(res.getString("DPrivateKeyUsagePeriod.Title"));
        this.initComponents();
        this.prepopulateWithValue(value);
    }

    private void initComponents() {
        this.jlNotBefore = new JLabel(res.getString("DPrivateKeyUsagePeriod.jlNotBefore.text"));
        GridBagConstraints gbc_jlNotBefore = new GridBagConstraints();
        gbc_jlNotBefore.gridx = 0;
        gbc_jlNotBefore.gridy = 0;
        gbc_jlNotBefore.gridwidth = 1;
        gbc_jlNotBefore.gridheight = 1;
        gbc_jlNotBefore.insets = new Insets(5, 5, 5, 5);
        gbc_jlNotBefore.anchor = 13;
        this.jdtNotBefore = new JDateTime(res.getString("DPrivateKeyUsagePeriod.jdtNotBefore.text"));
        this.jdtNotBefore.setToolTipText(res.getString("DPrivateKeyUsagePeriod.jdtNotBefore.tooltip"));
        GridBagConstraints gbc_jdtNotBefore = new GridBagConstraints();
        gbc_jdtNotBefore.gridx = 1;
        gbc_jdtNotBefore.gridy = 0;
        gbc_jdtNotBefore.gridwidth = 1;
        gbc_jdtNotBefore.gridheight = 1;
        gbc_jdtNotBefore.insets = new Insets(5, 5, 5, 5);
        gbc_jdtNotBefore.anchor = 17;
        this.jlNotAfter = new JLabel(res.getString("DPrivateKeyUsagePeriod.jlNotAfter.text"));
        GridBagConstraints gbc_jlNotAfter = new GridBagConstraints();
        gbc_jlNotAfter.gridx = 0;
        gbc_jlNotAfter.gridy = 1;
        gbc_jlNotAfter.gridwidth = 1;
        gbc_jlNotAfter.gridheight = 1;
        gbc_jlNotAfter.insets = new Insets(5, 5, 5, 5);
        gbc_jlNotAfter.anchor = 13;
        this.jdtNotAfter = new JDateTime(res.getString("DPrivateKeyUsagePeriod.jdtNotAfter.text"));
        this.jdtNotAfter.setToolTipText(res.getString("DPrivateKeyUsagePeriod.jdtNotAfter.tooltip"));
        GridBagConstraints gbc_jdtNotAfter = new GridBagConstraints();
        gbc_jdtNotAfter.gridx = 1;
        gbc_jdtNotAfter.gridy = 1;
        gbc_jdtNotAfter.gridwidth = 1;
        gbc_jdtNotAfter.gridheight = 1;
        gbc_jdtNotAfter.insets = new Insets(5, 5, 5, 5);
        gbc_jdtNotAfter.anchor = 17;
        this.jpPrivateKeyUsagePeriod = new JPanel(new FlowLayout());
        this.jpPrivateKeyUsagePeriod.add(this.jlNotBefore);
        this.jpPrivateKeyUsagePeriod.add(this.jdtNotBefore);
        this.jpPrivateKeyUsagePeriod.add(this.jlNotAfter);
        this.jpPrivateKeyUsagePeriod.add(this.jdtNotAfter);
        this.jpPrivateKeyUsagePeriod = new JPanel(new GridBagLayout());
        this.jpPrivateKeyUsagePeriod.add((Component)this.jlNotBefore, gbc_jlNotBefore);
        this.jpPrivateKeyUsagePeriod.add((Component)this.jdtNotBefore, gbc_jdtNotBefore);
        this.jpPrivateKeyUsagePeriod.add((Component)this.jlNotAfter, gbc_jlNotAfter);
        this.jpPrivateKeyUsagePeriod.add((Component)this.jdtNotAfter, gbc_jdtNotAfter);
        this.jpPrivateKeyUsagePeriod.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new EtchedBorder()));
        this.jbOK = new JButton(res.getString("DPrivateKeyUsagePeriod.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DPrivateKeyUsagePeriod.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DPrivateKeyUsagePeriod.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DPrivateKeyUsagePeriod.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DPrivateKeyUsagePeriod.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpPrivateKeyUsagePeriod, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DPrivateKeyUsagePeriod.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void prepopulateWithValue(byte[] value) throws IOException {
        ASN1GeneralizedTime notAfter;
        PrivateKeyUsagePeriod privateKeyUsagePeriod = PrivateKeyUsagePeriod.getInstance((Object)value);
        ASN1GeneralizedTime notBefore = privateKeyUsagePeriod.getNotBefore();
        if (notBefore != null) {
            try {
                this.jdtNotBefore.setDateTime(notBefore.getDate());
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
        if ((notAfter = privateKeyUsagePeriod.getNotAfter()) != null) {
            try {
                this.jdtNotAfter.setDateTime(notAfter.getDate());
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
    }

    private void okPressed() {
        Date notBefore = this.jdtNotBefore.getDateTime();
        Date notAfter = this.jdtNotAfter.getDateTime();
        if (notBefore == null && notAfter == null) {
            JOptionPane.showMessageDialog(this, res.getString("DPrivateKeyUsagePeriod.ValueReq.message"), this.getTitle(), 2);
            return;
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (notBefore != null) {
            DERGeneralizedTime notBeforeGenTime = new DERGeneralizedTime(notBefore);
            v.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)notBeforeGenTime));
        }
        if (notAfter != null) {
            DERGeneralizedTime notAfterGenTime = new DERGeneralizedTime(notAfter);
            v.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)notAfterGenTime));
        }
        PrivateKeyUsagePeriod privateKeyUsagePeriod = PrivateKeyUsagePeriod.getInstance((Object)new DERSequence(v));
        try {
            this.value = privateKeyUsagePeriod.getEncoded("DER");
        }
        catch (IOException e) {
            DError.displayError(this, (Throwable)e);
            return;
        }
        this.closeDialog();
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

