/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.extensions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.kse.crypto.x509.SubjectInfoAccess;
import org.kse.gui.PlatformUtil;
import org.kse.gui.crypto.accessdescription.JAccessDescriptions;
import org.kse.gui.dialogs.extensions.DExtension;
import org.kse.gui.error.DError;

public class DSubjectInformationAccess
extends DExtension {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/extensions/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpAccessDescriptions;
    private JLabel jlAccessDescriptions;
    private JAccessDescriptions jadAccessDescriptions;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private byte[] value;

    public DSubjectInformationAccess(JDialog parent) {
        super(parent);
        this.setTitle(res.getString("DSubjectInformationAccess.Title"));
        this.initComponents();
    }

    public DSubjectInformationAccess(JDialog parent, byte[] value) throws IOException {
        super(parent);
        this.setTitle(res.getString("DSubjectInformationAccess.Title"));
        this.initComponents();
        this.prepopulateWithValue(value);
    }

    private void initComponents() {
        this.jlAccessDescriptions = new JLabel(res.getString("DSubjectInformationAccess.jlAccessDescriptions.text"));
        GridBagConstraints gbc_jlAccessDescriptions = new GridBagConstraints();
        gbc_jlAccessDescriptions.gridx = 0;
        gbc_jlAccessDescriptions.gridy = 0;
        gbc_jlAccessDescriptions.gridwidth = 1;
        gbc_jlAccessDescriptions.gridheight = 1;
        gbc_jlAccessDescriptions.insets = new Insets(5, 5, 5, 5);
        gbc_jlAccessDescriptions.anchor = 12;
        this.jadAccessDescriptions = new JAccessDescriptions(res.getString("DSubjectInformationAccess.AccessDescription.Title"));
        GridBagConstraints gbc_jadAccessDescriptions = new GridBagConstraints();
        gbc_jadAccessDescriptions.gridx = 1;
        gbc_jadAccessDescriptions.gridy = 0;
        gbc_jadAccessDescriptions.gridwidth = 1;
        gbc_jadAccessDescriptions.gridheight = 1;
        gbc_jadAccessDescriptions.insets = new Insets(5, 5, 5, 5);
        gbc_jadAccessDescriptions.anchor = 17;
        this.jpAccessDescriptions = new JPanel(new GridBagLayout());
        this.jpAccessDescriptions.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        this.jpAccessDescriptions.add((Component)this.jlAccessDescriptions, gbc_jlAccessDescriptions);
        this.jpAccessDescriptions.add((Component)this.jadAccessDescriptions, gbc_jadAccessDescriptions);
        this.jbOK = new JButton(res.getString("DSubjectInformationAccess.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSubjectInformationAccess.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DSubjectInformationAccess.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSubjectInformationAccess.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSubjectInformationAccess.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpAccessDescriptions, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DSubjectInformationAccess.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void prepopulateWithValue(byte[] value) throws IOException {
        SubjectInfoAccess subjectInformationAccess = SubjectInfoAccess.getInstance(value);
        this.jadAccessDescriptions.setAccessDescriptions(subjectInformationAccess.getAccessDescriptionList());
    }

    private void okPressed() {
        List<AccessDescription> accessDescriptions = this.jadAccessDescriptions.getAccessDescriptions();
        if (accessDescriptions.size() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DSubjectInformationAccess.ValueReq.message"), this.getTitle(), 2);
            return;
        }
        SubjectInfoAccess subjectInformationAccess = new SubjectInfoAccess(accessDescriptions);
        try {
            this.value = subjectInformationAccess.getEncoded("DER");
        }
        catch (IOException e) {
            DError.displayError(this, (Throwable)e);
            return;
        }
        this.closeDialog();
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

