/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.extensions;

import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.kse.crypto.x509.X509Ext;

public class ExtensionsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/extensions/resources");
    private String[] columnNames = new String[3];
    private Object[][] data;

    public ExtensionsTableModel() {
        this.columnNames[0] = res.getString("ExtensionsTableModel.CriticalColumn");
        this.columnNames[1] = res.getString("ExtensionsTableModel.NameColumn");
        this.columnNames[2] = res.getString("ExtensionsTableModel.OidColumn");
        this.data = new Object[0][0];
    }

    public void load(X509Extension extensions) {
        X509Ext ext;
        byte[] value;
        Set<String> critExts = extensions.getCriticalExtensionOIDs();
        Set<String> nonCritExts = extensions.getNonCriticalExtensionOIDs();
        ArrayList<X509Ext> sortedExts = new ArrayList<X509Ext>();
        for (String extOid : critExts) {
            value = extensions.getExtensionValue(extOid);
            ext = new X509Ext(new ASN1ObjectIdentifier(extOid), value, true);
            sortedExts.add(ext);
        }
        for (String extOid : nonCritExts) {
            value = extensions.getExtensionValue(extOid);
            ext = new X509Ext(new ASN1ObjectIdentifier(extOid), value, false);
            sortedExts.add(ext);
        }
        Collections.sort(sortedExts, new ExtensionNameComparator());
        this.data = new Object[sortedExts.size()][3];
        int i = 0;
        for (X509Ext ext2 : sortedExts) {
            this.loadRow(ext2, i);
            ++i;
        }
        this.fireTableDataChanged();
    }

    private void loadRow(X509Ext extension, int row) {
        this.data[row][0] = extension.isCriticalExtension();
        String name = extension.getName();
        this.data[row][1] = name == null ? "" : name;
        this.data[row][2] = extension.getOid();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.data[row][col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
        }
        return ASN1ObjectIdentifier.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    private class ExtensionNameComparator
    implements Comparator<X509Ext> {
        private ExtensionNameComparator() {
        }

        @Override
        public int compare(X509Ext ext1, X509Ext ext2) {
            int result;
            String name1 = ext1.getName();
            String name2 = ext2.getName();
            if (name1 == null) {
                name1 = "-";
            }
            if (name2 == null) {
                name2 = "-";
            }
            if ((result = name1.compareToIgnoreCase(name2)) == 0) {
                result = ext1.getOid().getId().compareToIgnoreCase(ext2.getOid().getId());
            }
            return result;
        }
    }
}

