/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.sign;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.jar.JarFile;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;
import org.kse.crypto.CryptoException;
import org.kse.crypto.digest.DigestType;
import org.kse.crypto.keypair.KeyPairType;
import org.kse.crypto.signing.JarSigner;
import org.kse.crypto.signing.SignatureType;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.CursorUtil;
import org.kse.gui.FileChooserFactory;
import org.kse.gui.JEscDialog;
import org.kse.gui.JavaFXFileChooser;
import org.kse.gui.MiGUtil;
import org.kse.gui.PlatformUtil;
import org.kse.gui.dialogs.DialogHelper;
import org.kse.gui.error.DError;
import org.kse.gui.error.DProblem;
import org.kse.gui.error.Problem;
import org.kse.utilities.DialogViewer;
import org.kse.utilities.io.FileNameUtil;
import org.kse.utilities.io.IOUtils;
import org.kse.utilities.net.URLs;

public class DSignJar
extends JEscDialog {
    private static final long serialVersionUID = -5095469699284737624L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/sign/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JLabel jlInputJar;
    private JTextField jtfInputJar;
    private JButton jbInputJarBrowse;
    private JLabel jlSignDirectly;
    private JCheckBox jcbSignDirectly;
    private JLabel jlOutputJar;
    private JTextField jtfOutputJar;
    private JButton jbOutputJarBrowse;
    private JLabel jlSignatureName;
    private JTextField jtfSignatureName;
    private JLabel jlSignatureAlgorithm;
    private JComboBox<SignatureType> jcbSignatureAlgorithm;
    private JLabel jlDigestAlgorithm;
    private JComboBox<DigestType> jcbDigestAlgorithm;
    private JLabel jlAddTimestamp;
    private JCheckBox jcbAddTimestamp;
    private JLabel jlTimestampServerUrl;
    private JComboBox<String> jcbTimestampServerUrl;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private PrivateKey signPrivateKey;
    private KeyPairType signKeyPairType;
    private File inputJarFile;
    private File outputJarFile;
    private String signatureName;
    private SignatureType signatureType;
    private DigestType digestType;
    private String tsaUrl;

    public DSignJar(JFrame parent, PrivateKey signPrivateKey, KeyPairType signKeyPairType, String signatureName) throws CryptoException {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.signPrivateKey = signPrivateKey;
        this.signKeyPairType = signKeyPairType;
        this.setTitle(res.getString("DSignJar.Title"));
        this.initComponents(signatureName);
    }

    private void initComponents(String signatureName) throws CryptoException {
        this.jlInputJar = new JLabel(res.getString("DSignJar.jlInputJar.text"));
        this.jtfInputJar = new JTextField(30);
        this.jtfInputJar.setCaretPosition(0);
        this.jtfInputJar.setToolTipText(res.getString("DSignJar.jtfInputJar.tooltip"));
        this.jbInputJarBrowse = new JButton(res.getString("DSignJar.jbInputJarBrowse.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbInputJarBrowse, res.getString("DSignJar.jbInputJarBrowse.mnemonic").charAt(0));
        this.jbInputJarBrowse.setToolTipText(res.getString("DSignJar.jbInputJarBrowse.tooltip"));
        this.jlSignDirectly = new JLabel(res.getString("DSignJar.jlSignDirectly.text"));
        this.jcbSignDirectly = new JCheckBox();
        this.jcbSignDirectly.setSelected(true);
        this.jcbSignDirectly.setToolTipText(res.getString("DSignJar.jcbSignDirectly.tooltip"));
        this.jlOutputJar = new JLabel(res.getString("DSignJar.jlOutputJar.text"));
        this.jtfOutputJar = new JTextField(30);
        this.jtfOutputJar.setEnabled(false);
        this.jtfOutputJar.setCaretPosition(0);
        this.jtfOutputJar.setToolTipText(res.getString("DSignJar.jtfOutputJar.tooltip"));
        this.jbOutputJarBrowse = new JButton(res.getString("DSignJar.jbOutputJarBrowse.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbOutputJarBrowse, res.getString("DSignJar.jbOutputJarBrowse.mnemonic").charAt(0));
        this.jbOutputJarBrowse.setToolTipText(res.getString("DSignJar.jbOutputJarBrowse.tooltip"));
        this.jbOutputJarBrowse.setEnabled(false);
        this.jlSignatureName = new JLabel(res.getString("DSignJar.jlSignatureName.text"));
        this.jtfSignatureName = new JTextField(this.convertSignatureName(signatureName), 15);
        this.jtfSignatureName.setCaretPosition(0);
        this.jtfSignatureName.setToolTipText(res.getString("DSignJar.jtfSignatureName.tooltip"));
        this.jlSignatureAlgorithm = new JLabel(res.getString("DSignJar.jlSignatureAlgorithm.text"));
        this.jcbSignatureAlgorithm = new JComboBox();
        DialogHelper.populateSigAlgs(this.signKeyPairType, this.signPrivateKey, this.jcbSignatureAlgorithm);
        this.jcbSignatureAlgorithm.setToolTipText(res.getString("DSignJar.jcbSignatureAlgorithm.tooltip"));
        this.jlDigestAlgorithm = new JLabel(res.getString("DSignJar.jlDigestAlgorithm.text"));
        this.jcbDigestAlgorithm = new JComboBox();
        this.populateDigestAlgs();
        this.jcbDigestAlgorithm.setToolTipText(res.getString("DSignJar.jcbDigestAlgorithm.tooltip"));
        this.jlAddTimestamp = new JLabel(res.getString("DSignJar.jlAddTimestamp.text"));
        this.jcbAddTimestamp = new JCheckBox();
        this.jcbAddTimestamp.setSelected(false);
        this.jcbAddTimestamp.setToolTipText(res.getString("DSignJar.jcbAddTimestamp.tooltip"));
        this.jlTimestampServerUrl = new JLabel(res.getString("DSignJar.jlTimestampServerUrl.text"));
        this.jcbTimestampServerUrl = new JComboBox();
        this.jcbTimestampServerUrl.setEditable(true);
        this.jcbTimestampServerUrl.setEnabled(false);
        this.jcbTimestampServerUrl.setToolTipText(res.getString("DSignJar.jcbTimestampServerUrl.tooltip"));
        this.jcbTimestampServerUrl.setModel(new DefaultComboBoxModel<String>(URLs.TSA_URLS));
        this.jbOK = new JButton(res.getString("DSignJar.jbOK.text"));
        this.jbCancel = new JButton(res.getString("DSignJar.jbCancel.text"));
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        Container pane = this.getContentPane();
        pane.setLayout((LayoutManager)new MigLayout("insets dialog, fill", "[para]unrel[right]unrel[]", "[]unrel[]"));
        MiGUtil.addSeparator(pane, res.getString("DSignJar.jlFiles.text"));
        pane.add((Component)this.jlInputJar, "skip");
        pane.add((Component)this.jtfInputJar, "sgx");
        pane.add((Component)this.jbInputJarBrowse, "wrap");
        pane.add((Component)this.jlSignDirectly, "skip");
        pane.add((Component)this.jcbSignDirectly, "wrap");
        pane.add((Component)this.jlOutputJar, "skip");
        pane.add((Component)this.jtfOutputJar, "sgx");
        pane.add((Component)this.jbOutputJarBrowse, "wrap para");
        MiGUtil.addSeparator(pane, res.getString("DSignJar.jlSignature.text"));
        pane.add((Component)this.jlSignatureName, "skip");
        pane.add((Component)this.jtfSignatureName, "sgx, wrap");
        pane.add((Component)this.jlSignatureAlgorithm, "skip");
        pane.add(this.jcbSignatureAlgorithm, "sgx, wrap");
        pane.add((Component)this.jlDigestAlgorithm, "skip");
        pane.add(this.jcbDigestAlgorithm, "sgx, wrap para");
        MiGUtil.addSeparator(pane, res.getString("DSignJar.jlTimestamp.text"));
        pane.add((Component)this.jlAddTimestamp, "skip");
        pane.add((Component)this.jcbAddTimestamp, "wrap");
        pane.add((Component)this.jlTimestampServerUrl, "skip");
        pane.add(this.jcbTimestampServerUrl, "sgx, wrap para");
        pane.add((Component)new JSeparator(), "spanx, growx, wrap para");
        pane.add((Component)this.jpButtons, "right, spanx");
        this.jbInputJarBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DSignJar.this);
                    DSignJar.this.inputJarBrowsePressed();
                }
                finally {
                    CursorUtil.setCursorFree(DSignJar.this);
                }
            }
        });
        this.jcbSignDirectly.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DSignJar.this.jtfOutputJar.setEnabled(!DSignJar.this.jcbSignDirectly.isSelected());
                DSignJar.this.jbOutputJarBrowse.setEnabled(!DSignJar.this.jcbSignDirectly.isSelected());
            }
        });
        this.jbOutputJarBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DSignJar.this);
                    DSignJar.this.outputJarBrowsePressed();
                }
                finally {
                    CursorUtil.setCursorFree(DSignJar.this);
                }
            }
        });
        this.jcbAddTimestamp.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DSignJar.this.jcbTimestampServerUrl.setEnabled(DSignJar.this.jcbAddTimestamp.isSelected());
            }
        });
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSignJar.this.okPressed();
            }
        });
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSignJar.this.cancelPressed();
            }
        });
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSignJar.this.cancelPressed();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DSignJar.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private String convertSignatureName(String signatureName) {
        StringBuffer sb = new StringBuffer(signatureName.length());
        for (int i = 0; i < signatureName.length(); ++i) {
            int c = signatureName.charAt(i);
            if (!(c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 45 || c == 95)) {
                c = 95;
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    private void populateDigestAlgs() {
        this.jcbDigestAlgorithm.removeAllItems();
        this.jcbDigestAlgorithm.addItem(DigestType.MD2);
        this.jcbDigestAlgorithm.addItem(DigestType.MD5);
        this.jcbDigestAlgorithm.addItem(DigestType.SHA1);
        this.jcbDigestAlgorithm.addItem(DigestType.SHA224);
        this.jcbDigestAlgorithm.addItem(DigestType.SHA256);
        this.jcbDigestAlgorithm.addItem(DigestType.SHA384);
        this.jcbDigestAlgorithm.addItem(DigestType.SHA512);
        this.jcbDigestAlgorithm.setSelectedItem((Object)DigestType.SHA1);
    }

    public File getInputJar() {
        return this.inputJarFile;
    }

    public File getOutputJar() {
        return this.outputJarFile;
    }

    public String getSignatureName() {
        return this.signatureName;
    }

    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    public DigestType getDigestType() {
        return this.digestType;
    }

    public String getTimestampingServerUrl() {
        return this.tsaUrl;
    }

    private boolean verifySignatureName(String signatureName) {
        for (int i = 0; i < signatureName.length(); ++i) {
            char c = signatureName.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_') continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void okPressed() {
        String message;
        int selected;
        File outputJarFile;
        String inputJar = this.jtfInputJar.getText().trim();
        if (inputJar.length() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DSignJar.InputJarRequired.message"), this.getTitle(), 2);
            return;
        }
        File inputJarFile = new File(inputJar);
        if (!inputJarFile.isFile()) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(res.getString("DSignJar.InputJarNotFile.message"), inputJarFile), this.getTitle(), 2);
            return;
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(inputJarFile);
        }
        catch (IOException ex) {
            try {
                String problemStr = MessageFormat.format(res.getString("DSignJar.NoOpenJar.Problem"), inputJarFile.getName());
                String[] causes = new String[]{res.getString("DSignJar.NotJar.Cause"), res.getString("DSignJar.CorruptedJar.Cause")};
                Problem problem = new Problem(problemStr, causes, ex);
                DProblem dProblem = new DProblem(this, res.getString("DSignJar.ProblemOpeningJar.Title"), problem);
                dProblem.setLocationRelativeTo(this);
                dProblem.setVisible(true);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(jarFile);
                throw throwable;
            }
            IOUtils.closeQuietly(jarFile);
            return;
        }
        IOUtils.closeQuietly(jarFile);
        boolean signDirectly = this.jcbSignDirectly.isSelected();
        if (signDirectly) {
            outputJarFile = inputJarFile;
        } else {
            String outputJar = this.jtfOutputJar.getText().trim();
            if (outputJar.length() == 0) {
                JOptionPane.showMessageDialog(this, res.getString("DSignJar.OutputJarRequired.message"), this.getTitle(), 2);
                return;
            }
            outputJarFile = new File(outputJar);
        }
        String signatureName = this.jtfSignatureName.getText().trim();
        if (signatureName.length() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DSignJar.ValReqSignatureName.message"), this.getTitle(), 2);
            return;
        }
        if (!this.verifySignatureName(signatureName)) {
            JOptionPane.showMessageDialog(this, res.getString("DSignJar.ValJarSignatureName.message"), this.getTitle(), 2);
            return;
        }
        if (!signDirectly && outputJarFile.isFile() && (selected = JOptionPane.showConfirmDialog(this, message = MessageFormat.format(res.getString("DSignJar.OverWriteOutputJarFile.message"), outputJarFile), this.getTitle(), 0)) != 0) {
            return;
        }
        try {
            if (JarSigner.hasSignature(new File(inputJar), signatureName) && (selected = JOptionPane.showConfirmDialog(this, message = MessageFormat.format(res.getString("DSignJar.SignatureOverwrite.message"), signatureName), this.getTitle(), 0)) != 0) {
                return;
            }
        }
        catch (IOException ex) {
            DError.displayError(this, (Throwable)ex);
            return;
        }
        if (this.jcbAddTimestamp.isSelected() && this.jcbTimestampServerUrl.getSelectedItem().toString().isEmpty()) {
            JOptionPane.showMessageDialog(this, res.getString("DSignJar.EmptyTimestampUrl.message"), this.getTitle(), 2);
            return;
        }
        this.inputJarFile = inputJarFile;
        this.outputJarFile = outputJarFile;
        this.signatureName = signatureName;
        this.signatureType = (SignatureType)((Object)this.jcbSignatureAlgorithm.getSelectedItem());
        this.digestType = (DigestType)((Object)this.jcbDigestAlgorithm.getSelectedItem());
        if (this.jcbAddTimestamp.isSelected()) {
            this.tsaUrl = this.jcbTimestampServerUrl.getSelectedItem().toString();
        }
        this.closeDialog();
    }

    private void inputJarBrowsePressed() {
        JFileChooser chooser = FileChooserFactory.getArchiveFileChooser();
        File currentFile = new File(this.jtfInputJar.getText().trim());
        if (currentFile.getParentFile() != null && currentFile.getParentFile().exists()) {
            chooser.setCurrentDirectory(currentFile.getParentFile());
            chooser.setSelectedFile(currentFile);
        } else {
            chooser.setCurrentDirectory(CurrentDirectory.get());
        }
        chooser.setDialogTitle(res.getString("DSignJar.ChooseInputJar.Title"));
        chooser.setMultiSelectionEnabled(false);
        chooser.setApproveButtonText(res.getString("DSignJar.InputJarChooser.button"));
        int rtnValue = chooser.showOpenDialog(this);
        if (rtnValue == 0) {
            File chosenFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(chosenFile);
            this.jtfInputJar.setText(chosenFile.toString());
            this.jtfInputJar.setCaretPosition(0);
            this.populateOutputJarFileName(chosenFile);
        }
    }

    private void populateOutputJarFileName(File chosenFile) {
        String fileBaseName = FileNameUtil.removeExtension(chosenFile.getName());
        if (fileBaseName != null) {
            String outFileName = fileBaseName + "_signed.jar";
            File outFile = new File(chosenFile.getParentFile(), outFileName);
            this.jtfOutputJar.setText(outFile.getPath());
        }
    }

    private void outputJarBrowsePressed() {
        int rtnValue;
        JFileChooser chooser = FileChooserFactory.getArchiveFileChooser();
        File currentFile = new File(this.jtfOutputJar.getText());
        if (currentFile.getParentFile() != null && currentFile.getParentFile().exists()) {
            chooser.setCurrentDirectory(currentFile.getParentFile());
            chooser.setSelectedFile(currentFile);
        } else {
            chooser.setCurrentDirectory(CurrentDirectory.get());
        }
        chooser.setDialogTitle(res.getString("DSignJar.ChooseOutputJar.Title"));
        chooser.setMultiSelectionEnabled(false);
        int n = rtnValue = JavaFXFileChooser.isFxAvailable() ? chooser.showSaveDialog(this) : chooser.showDialog(this, res.getString("DSignJar.OutputJarChooser.button"));
        if (rtnValue == 0) {
            File chosenFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(chosenFile);
            this.jtfOutputJar.setText(chosenFile.toString());
            this.jtfOutputJar.setCaretPosition(0);
        }
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(KeyPairType.RSA.jce(), "BC");
        kpg.initialize(1024, new SecureRandom());
        KeyPair kp = kpg.generateKeyPair();
        DSignJar dialog = new DSignJar(new JFrame(), kp.getPrivate(), KeyPairType.RSA, "signature name");
        DialogViewer.run(dialog);
    }
}

