/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dnd;

import java.awt.Toolkit;
import java.security.cert.Certificate;
import javax.swing.ImageIcon;
import org.kse.crypto.CryptoException;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.dnd.DragEntry;

public class DragTrustedCertificateEntry
extends DragEntry {
    private static final String EXTENSION = "cer";
    private byte[] contentBytes;
    private String contentStr;
    private ImageIcon image;

    public DragTrustedCertificateEntry(String name, Certificate trustedCertificate) throws CryptoException {
        super(name);
        this.contentStr = X509CertUtil.getCertEncodedX509Pem(X509CertUtil.convertCertificate(trustedCertificate));
        this.contentBytes = this.contentStr.getBytes();
        this.image = new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/drag_trustcert.png")));
    }

    @Override
    public ImageIcon getImage() {
        return this.image;
    }

    @Override
    public String getExtension() {
        return EXTENSION;
    }

    @Override
    public byte[] getContent() {
        return this.contentBytes;
    }

    @Override
    public String getContentString() {
        return this.contentStr;
    }
}

