/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dnd;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import org.kse.gui.KseFrame;
import org.kse.gui.dnd.DragEntry;
import org.kse.gui.dnd.KeyStoreEntryTransferable;

public class KeyStoreEntryDragGestureListener
extends DragSourceAdapter
implements DragGestureListener {
    private KseFrame kseFrame;
    private Cursor cursor;

    public KeyStoreEntryDragGestureListener(KseFrame kseFrame) {
        this.kseFrame = kseFrame;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent evt) {
        DragEntry dragEntry = this.kseFrame.dragSelectedEntry();
        if (dragEntry == null) {
            return;
        }
        ImageIcon icon = dragEntry.getImage();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dim = toolkit.getBestCursorSize(icon.getIconWidth(), icon.getIconHeight());
        BufferedImage buffImage = new BufferedImage(dim.width, dim.height, 3);
        icon.paintIcon(evt.getComponent(), buffImage.getGraphics(), 0, 0);
        this.cursor = toolkit.createCustomCursor(buffImage, new Point(0, 0), "keystore-entry");
        evt.startDrag(this.cursor, new KeyStoreEntryTransferable(dragEntry), this);
    }

    @Override
    public void dragEnter(DragSourceDragEvent evt) {
        DragSourceContext ctx = evt.getDragSourceContext();
        ctx.setCursor(this.cursor);
    }

    public void dragExit(DragSourceDragEvent evt) {
        DragSourceContext ctx = evt.getDragSourceContext();
        ctx.setCursor(DragSource.DefaultCopyNoDrop);
    }
}

