/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.error;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.kse.gui.CursorUtil;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;
import org.kse.gui.error.DErrorDetail;

public class DError
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/error/resources");
    private JPanel jpError;
    private JLabel jlError;
    private JPanel jpButtons;
    private JButton jbDetails;
    private JButton jbOK;
    private Throwable error;

    public DError(JFrame parent, Throwable error) {
        super((Window)parent, res.getString("DError.Title"), Dialog.ModalityType.DOCUMENT_MODAL);
        this.error = error;
        this.initComponents();
    }

    public DError(JDialog parent, Throwable error) {
        super((Window)parent, res.getString("DError.Title"), Dialog.ModalityType.DOCUMENT_MODAL);
        this.error = error;
        this.initComponents();
    }

    public DError(JFrame parent, String title, Dialog.ModalityType modality, Throwable error) {
        super((Window)parent, modality);
        this.setTitle(title);
        this.error = error;
        this.initComponents();
    }

    public DError(JDialog parent, String title, Throwable error) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.setTitle(title);
        this.error = error;
        this.initComponents();
    }

    public static void displayError(JFrame frame, Throwable error) {
        DError dError = new DError(frame, error);
        dError.setLocationRelativeTo(frame);
        dError.setVisible(true);
    }

    public static void displayError(JDialog dialog, Throwable error) {
        DError dError = new DError(dialog, error);
        dError.setLocationRelativeTo(dialog);
        dError.setVisible(true);
    }

    private void initComponents() {
        this.jpError = new JPanel(new FlowLayout(1));
        this.jpError.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jlError = new JLabel(this.formatError());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("images/error.png"));
        this.jlError.setIcon(icon);
        this.jlError.setHorizontalTextPosition(11);
        this.jlError.setIconTextGap(15);
        this.jpError.add(this.jlError);
        this.jbDetails = new JButton(res.getString("DError.jbDetails.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbDetails, res.getString("DError.jbDetails.mnemonic").charAt(0));
        this.jbDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DError.this);
                    DError.this.showErrorDetail();
                }
                finally {
                    CursorUtil.setCursorFree(DError.this);
                }
            }
        });
        this.jbOK = new JButton(res.getString("DError.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DError.this.okPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, null, this.jbDetails);
        this.getContentPane().add((Component)this.jpError, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DError.this.closeDialog();
            }
        });
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private String formatError() {
        String message = this.error.getMessage();
        if (message != null) {
            return MessageFormat.format("<html>{0}:<br>{1}</html>", this.error.getClass().getName(), this.breakLine(message));
        }
        return this.error.getClass().getName();
    }

    private String breakLine(String line) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer strTok = new StringTokenizer(line, " ");
        String currentLine = "";
        while (strTok.hasMoreTokens()) {
            String word = strTok.nextToken();
            if (currentLine.length() == 0) {
                currentLine = currentLine + word;
                continue;
            }
            if (currentLine.length() + word.length() + 1 <= 50) {
                currentLine = currentLine + " ";
                currentLine = currentLine + word;
                continue;
            }
            if (sb.length() > 0) {
                sb.append("<br>");
            }
            sb.append(currentLine);
            currentLine = word;
        }
        if (sb.length() > 0) {
            sb.append("<br>");
        }
        sb.append(currentLine);
        return sb.toString();
    }

    private void showErrorDetail() {
        DErrorDetail dErrorDetail = new DErrorDetail(this, this.error);
        dErrorDetail.setLocationRelativeTo(this);
        dErrorDetail.setVisible(true);
    }

    private void okPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

