/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.jar;

import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.table.AbstractTableModel;

public class JarInfoTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/jar/resources");
    private String[] columnNames = new String[8];
    private Object[][] data;

    public JarInfoTableModel() {
        this.columnNames[0] = res.getString("JarInfoTableModel.JarFileColumn");
        this.columnNames[1] = res.getString("JarInfoTableModel.SizeColumn");
        this.columnNames[2] = res.getString("JarInfoTableModel.SpecificationTitleColumn");
        this.columnNames[3] = res.getString("JarInfoTableModel.SpecificationVersionColumn");
        this.columnNames[4] = res.getString("JarInfoTableModel.SpecificationVendorColumn");
        this.columnNames[5] = res.getString("JarInfoTableModel.ImplementationTitleColumn");
        this.columnNames[6] = res.getString("JarInfoTableModel.ImplementationVersionColumn");
        this.columnNames[7] = res.getString("JarInfoTableModel.ImplementationVendorColumn");
        this.data = new Object[0][0];
    }

    public void load(JarFile[] jarFiles) throws IOException {
        this.data = new Object[jarFiles.length][8];
        for (int i = 0; i < jarFiles.length; ++i) {
            JarFile jarFile = jarFiles[i];
            String fileName = jarFile.getName();
            File file = new File(fileName);
            Manifest manifest = jarFile.getManifest();
            String implementationTitle = "";
            String implementationVersion = "";
            String implementationVendor = "";
            String specificationTitle = "";
            String specificationVersion = "";
            String specificationVendor = "";
            if (manifest != null) {
                Attributes attributes = manifest.getMainAttributes();
                String value = attributes.getValue("Specification-Title");
                if (value != null) {
                    specificationTitle = value;
                }
                if ((value = attributes.getValue("Specification-Version")) != null) {
                    specificationVersion = value;
                }
                if ((value = attributes.getValue("Specification-Vendor")) != null) {
                    specificationVendor = value;
                }
                if ((value = attributes.getValue("Implementation-Title")) != null) {
                    implementationTitle = value;
                }
                if ((value = attributes.getValue("Implementation-Version")) != null) {
                    implementationVersion = value;
                }
                if ((value = attributes.getValue("Implementation-Vendor")) != null) {
                    implementationVendor = value;
                }
            }
            this.data[i][0] = file.getName();
            this.data[i][1] = Math.round(file.length() / 1024L);
            this.data[i][2] = specificationTitle;
            this.data[i][3] = specificationVersion;
            this.data[i][4] = specificationVendor;
            this.data[i][5] = implementationTitle;
            this.data[i][6] = implementationVersion;
            this.data[i][7] = implementationVendor;
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.data[row][col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Long.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return String.class;
            }
            case 6: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }
}

