/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.password;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.kse.crypto.Password;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;
import org.kse.gui.password.JPasswordQualityField;
import org.kse.gui.password.PasswordQualityConfig;

public class DGetNewPassword
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/password/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpPassword;
    private JLabel jlFirst;
    private JComponent jpfFirst;
    private JLabel jlConfirm;
    private JPasswordField jpfConfirm;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private PasswordQualityConfig passwordQualityConfig;
    private Password password;

    public DGetNewPassword(JFrame parent, Dialog.ModalityType modality, PasswordQualityConfig passwordQualityConfig) {
        super((Window)parent, res.getString("DGetNewPassword.Title"), modality);
        this.passwordQualityConfig = passwordQualityConfig;
        this.initComponents();
    }

    public DGetNewPassword(JFrame parent, String title, PasswordQualityConfig passwordQualityConfig) {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.passwordQualityConfig = passwordQualityConfig;
        this.initComponents();
    }

    public DGetNewPassword(JDialog parent, Dialog.ModalityType modality, PasswordQualityConfig passwordQualityConfig) {
        this(parent, res.getString("DGetNewPassword.Title"), modality, passwordQualityConfig);
    }

    public DGetNewPassword(JDialog parent, String title, Dialog.ModalityType modality, PasswordQualityConfig passwordQualityConfig) {
        super((Window)parent, title, modality);
        this.passwordQualityConfig = passwordQualityConfig;
        this.initComponents();
    }

    private void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        this.jlFirst = new JLabel(res.getString("DGetNewPassword.jlFirst.text"));
        GridBagConstraints gbc_jlFirst = new GridBagConstraints();
        gbc_jlFirst.gridx = 0;
        gbc_jlFirst.gridy = 0;
        gbc_jlFirst.anchor = 13;
        gbc_jlFirst.insets = new Insets(5, 5, 5, 5);
        this.jlConfirm = new JLabel(res.getString("DGetNewPassword.jlConfirm.text"));
        GridBagConstraints gbc_jpfFirst = new GridBagConstraints();
        gbc_jpfFirst.gridx = 1;
        gbc_jpfFirst.gridy = 0;
        gbc_jpfFirst.anchor = 17;
        gbc_jpfFirst.insets = new Insets(5, 5, 5, 5);
        this.jpfFirst = this.passwordQualityConfig.getEnabled() ? (this.passwordQualityConfig.getEnforced() ? new JPasswordQualityField(15, this.passwordQualityConfig.getMinimumQuality()) : new JPasswordQualityField(15)) : new JPasswordField(15);
        GridBagConstraints gbc_jlConfirm = new GridBagConstraints();
        gbc_jlConfirm.gridx = 0;
        gbc_jlConfirm.gridy = 1;
        gbc_jlConfirm.anchor = 13;
        gbc_jlConfirm.insets = new Insets(5, 5, 5, 5);
        this.jpfConfirm = new JPasswordField(15);
        GridBagConstraints gbc_jpfConfirm = new GridBagConstraints();
        gbc_jpfConfirm.gridx = 1;
        gbc_jpfConfirm.gridy = 1;
        gbc_jpfConfirm.anchor = 17;
        gbc_jpfConfirm.insets = new Insets(5, 5, 5, 5);
        this.jpPassword = new JPanel(new GridBagLayout());
        this.jpPassword.add((Component)this.jlFirst, gbc_jlFirst);
        this.jpPassword.add((Component)this.jpfFirst, gbc_jpfFirst);
        this.jpPassword.add((Component)this.jlConfirm, gbc_jlConfirm);
        this.jpPassword.add((Component)this.jpfConfirm, gbc_jpfConfirm);
        this.jpPassword.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        this.jbOK = new JButton(res.getString("DGetNewPassword.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DGetNewPassword.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DGetNewPassword.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DGetNewPassword.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DGetNewPassword.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().add((Component)this.jpPassword, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DGetNewPassword.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DGetNewPassword.this.jpfFirst.requestFocus();
            }
        });
    }

    public Password getPassword() {
        return this.password;
    }

    private boolean checkPassword() {
        Password firstPassword;
        if (this.jpfFirst instanceof JPasswordQualityField) {
            char[] firstPasswordChars = ((JPasswordQualityField)this.jpfFirst).getPassword();
            if (firstPasswordChars == null) {
                JOptionPane.showMessageDialog(this, res.getString("MinimumPasswordQualityNotMet.message"), this.getTitle(), 2);
                return false;
            }
            firstPassword = new Password(firstPasswordChars);
        } else {
            firstPassword = new Password(((JPasswordField)this.jpfFirst).getPassword());
        }
        Password confirmPassword = new Password(this.jpfConfirm.getPassword());
        if (firstPassword.equals(confirmPassword)) {
            this.password = firstPassword;
            return true;
        }
        JOptionPane.showMessageDialog(this, res.getString("PasswordsNoMatch.message"), this.getTitle(), 2);
        return false;
    }

    private void okPressed() {
        if (this.checkPassword()) {
            this.closeDialog();
        }
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

