/*
 * Decompiled with CFR 0.152.
 */
package org.kse.utilities.history;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.interfaces.DSAPrivateKey;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.bouncycastle.jce.provider.JDKDSAPrivateKey;
import org.kse.crypto.CryptoException;
import org.kse.crypto.Password;
import org.kse.crypto.keystore.KeyStoreType;
import org.kse.crypto.keystore.KeyStoreUtil;
import org.kse.utilities.history.HistoryAction;
import org.kse.utilities.history.KeyStoreHistory;

public class KeyStoreState {
    protected static ResourceBundle res = ResourceBundle.getBundle("org/kse/utilities/history/resources");
    private KeyStoreHistory history;
    HistoryAction action;
    private KeyStore keyStore;
    private Password password;
    private HashMap<String, Password> entryPasswords = new HashMap();
    private KeyStoreState previous;
    private KeyStoreState next;

    KeyStoreState() {
    }

    KeyStoreState(KeyStoreHistory history, KeyStore keyStore, Password password) {
        this.history = history;
        this.keyStore = keyStore;
        this.password = password;
    }

    public void append(KeyStoreState keyStoreState) {
        keyStoreState.previous = this;
        this.next = keyStoreState;
        keyStoreState.setAsCurrentState();
    }

    public String getActionDescription() {
        if (this.action != null) {
            return this.action.getHistoryDescription();
        }
        return null;
    }

    public void setAsCurrentState() {
        this.history.setCurrentState(this);
    }

    public boolean isInitialState() {
        return this == this.history.getInitialState();
    }

    public boolean isSavedState() {
        return this == this.history.getSavedState();
    }

    public void setAsSavedState() {
        this.history.setSavedState(this);
    }

    public void setPreviousStateAsCurrentState() throws CryptoException {
        if (this.previous != null) {
            this.propagateNewPasswords(this.previous);
            this.previous.setAsCurrentState();
        }
    }

    public void setNextStateAsCurrentState() throws CryptoException {
        if (this.next != null) {
            this.propagateNewPasswords(this.next);
            this.next.setAsCurrentState();
        }
    }

    public boolean hasPreviousState() {
        return this.previous != null;
    }

    public KeyStoreState previousState() {
        return this.previous;
    }

    public boolean hasNextState() {
        return this.next != null;
    }

    public KeyStoreState nextState() {
        return this.next;
    }

    public KeyStoreType getType() {
        return KeyStoreType.resolveJce(this.keyStore.getType());
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public Password getPassword() {
        return this.password;
    }

    public void setPassword(Password password) {
        this.password = password;
    }

    public void setEntryPassword(String alias, Password password) {
        this.entryPasswords.put(alias, password);
    }

    public void removeEntryPassword(String alias) {
        Password removedPassword = this.entryPasswords.remove(alias);
        if (removedPassword != null) {
            removedPassword.nullPassword();
        }
    }

    public Password getEntryPassword(String alias) {
        return this.entryPasswords.get(alias);
    }

    public void nullPasswords() {
        if (this.password != null) {
            this.password.nullPassword();
        }
        for (Map.Entry<String, Password> entry : this.entryPasswords.entrySet()) {
            entry.getValue().nullPassword();
        }
    }

    public KeyStoreState createBasisForNextState(HistoryAction action) throws CryptoException {
        KeyStoreState copy = new KeyStoreState();
        copy.history = this.history;
        copy.keyStore = KeyStoreUtil.copy(this.keyStore);
        if (this.password != null) {
            copy.password = new Password(this.password);
        }
        HashMap<String, Password> keyPairPasswordsCopy = new HashMap<String, Password>();
        for (String alias : this.entryPasswords.keySet()) {
            keyPairPasswordsCopy.put(alias, new Password(this.entryPasswords.get(alias)));
        }
        copy.entryPasswords = keyPairPasswordsCopy;
        copy.action = action;
        return copy;
    }

    protected void propagateNewPasswords(KeyStoreState targetState) throws CryptoException {
        try {
            for (String alias : this.entryPasswords.keySet()) {
                Password newPassword;
                if (!KeyStoreUtil.isKeyPairEntry(alias, targetState.keyStore) || targetState.entryPasswords.containsKey(alias) || !this.isPasswordPropagationValid(targetState, alias, newPassword = this.entryPasswords.get(alias))) continue;
                targetState.setEntryPassword(alias, newPassword);
            }
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(res.getString("NoPropagateEntryPasswords.exception.message"), ex);
        }
    }

    protected boolean isPasswordPropagationValid(KeyStoreState targetState, String alias, Password password) throws GeneralSecurityException {
        return this.isEntryPasswordCorrect(targetState, alias, password) && this.isEntryPrivateKeyEqual(targetState, alias, password);
    }

    protected boolean isEntryPasswordCorrect(KeyStoreState targetState, String alias, Password password) {
        try {
            targetState.keyStore.getKey(alias, password.toCharArray());
            return true;
        }
        catch (GeneralSecurityException ex) {
            return false;
        }
    }

    protected boolean isEntryPrivateKeyEqual(KeyStoreState targetState, String alias, Password password) throws GeneralSecurityException {
        Key currentKey = this.keyStore.getKey(alias, password.toCharArray());
        Key targetKey = targetState.getKeyStore().getKey(alias, password.toCharArray());
        if (currentKey instanceof JDKDSAPrivateKey || targetKey instanceof JDKDSAPrivateKey) {
            DSAPrivateKey currentDsaKey = (DSAPrivateKey)currentKey;
            DSAPrivateKey targetDsaKey = (DSAPrivateKey)targetKey;
            return currentDsaKey.getX().equals(targetDsaKey.getX()) && currentDsaKey.getParams().getG().equals(targetDsaKey.getParams().getG()) && currentDsaKey.getParams().getP().equals(targetDsaKey.getParams().getP()) && currentDsaKey.getParams().getQ().equals(targetDsaKey.getParams().getQ());
        }
        return currentKey.equals(targetKey);
    }
}

