/*
 * Decompiled with CFR 0.152.
 */
package org.kse.version;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kse.version.Version;
import org.kse.version.VersionException;

public class JavaVersion
implements Comparable<Object> {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/version/resources");
    private String javaVersion;
    private int major;
    private int minor;
    private int security;
    private static final String VERSION_NUMBER_REGEXP = "([0-9]+(?:\\.[0-9]*)*)";
    private static final String REST_REGEXP = "(?:[_\\-\\.\\+a-zA-Z0-9]*)";
    private static final String VERSION_FORMAT = "^([0-9]+(?:\\.[0-9]*)*)(?:[_\\-\\.\\+a-zA-Z0-9]*)$";
    private static final Pattern VERSION_STRING_PATTERN = Pattern.compile("^([0-9]+(?:\\.[0-9]*)*)(?:[_\\-\\.\\+a-zA-Z0-9]*)$");
    private static JavaVersion jreVersion;
    public static final JavaVersion JRE_VERSION_130;
    public static final JavaVersion JRE_VERSION_140;
    public static final JavaVersion JRE_VERSION_150;
    public static final JavaVersion JRE_VERSION_160;
    public static final JavaVersion JRE_VERSION_170;
    public static final JavaVersion JRE_VERSION_180;
    public static final JavaVersion JRE_VERSION_9;
    public static final JavaVersion JRE_VERSION_10;
    public static final JavaVersion JRE_VERSION_11;
    public static final JavaVersion JRE_VERSION_12;
    public static final JavaVersion JRE_VERSION_13;
    public static final JavaVersion JRE_VERSION_14;
    public static final JavaVersion JRE_VERSION_15;
    public static final JavaVersion JRE_VERSION_16;
    public static final JavaVersion JRE_VERSION_17;

    public JavaVersion() {
        this(System.getProperty("java.version"));
    }

    public JavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
        Matcher matcher = VERSION_STRING_PATTERN.matcher(javaVersion);
        if (!matcher.matches()) {
            throw new VersionException(MessageFormat.format(res.getString("NoParseJavaVersion.exception.message"), javaVersion));
        }
        String vnum = matcher.group(1);
        Version version = new Version(vnum);
        this.major = version.getMajor();
        this.minor = version.getMinor();
        this.security = version.getBugfix();
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getSecurity() {
        return this.security;
    }

    public static JavaVersion getJreVersion() {
        if (jreVersion == null) {
            String jreVersionProp = System.getProperty("java.version");
            jreVersion = new JavaVersion(jreVersionProp);
        }
        return jreVersion;
    }

    public boolean isAtLeast(JavaVersion javaVersion) {
        return this.compareTo(javaVersion) >= 0;
    }

    public boolean isBelow(JavaVersion javaVersion) {
        return this.compareTo(javaVersion) < 0;
    }

    @Override
    public int compareTo(Object object) {
        JavaVersion cmpJavaVersion = (JavaVersion)object;
        if (this.major > cmpJavaVersion.getMajor()) {
            return 1;
        }
        if (this.major < cmpJavaVersion.getMajor()) {
            return -1;
        }
        if (this.minor > cmpJavaVersion.getMinor()) {
            return 1;
        }
        if (this.minor < cmpJavaVersion.getMinor()) {
            return -1;
        }
        if (this.security > cmpJavaVersion.getSecurity()) {
            return 1;
        }
        if (this.security < cmpJavaVersion.getSecurity()) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof JavaVersion)) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        int result = 27;
        result = 53 * result + this.major;
        result = 53 * result + this.minor;
        result = 53 * result + this.security;
        return result;
    }

    public String toString() {
        return this.javaVersion;
    }

    static {
        JRE_VERSION_130 = new JavaVersion("1.3.0");
        JRE_VERSION_140 = new JavaVersion("1.4.0");
        JRE_VERSION_150 = new JavaVersion("1.5.0");
        JRE_VERSION_160 = new JavaVersion("1.6.0");
        JRE_VERSION_170 = new JavaVersion("1.7.0");
        JRE_VERSION_180 = new JavaVersion("1.8.0");
        JRE_VERSION_9 = new JavaVersion("9");
        JRE_VERSION_10 = new JavaVersion("10");
        JRE_VERSION_11 = new JavaVersion("11");
        JRE_VERSION_12 = new JavaVersion("12");
        JRE_VERSION_13 = new JavaVersion("13");
        JRE_VERSION_14 = new JavaVersion("14");
        JRE_VERSION_15 = new JavaVersion("15");
        JRE_VERSION_16 = new JavaVersion("16");
        JRE_VERSION_17 = new JavaVersion("17");
    }
}

