/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.csr.spkac;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.util.encoders.Base64;
import org.kse.crypto.csr.spkac.SpkacException;
import org.kse.crypto.csr.spkac.SpkacMissingPropertyException;
import org.kse.crypto.csr.spkac.SpkacSubject;
import org.kse.crypto.keypair.KeyPairType;
import org.kse.crypto.signing.SignatureType;
import org.kse.utilities.io.HexUtil;
import org.kse.utilities.io.IOUtils;

public class Spkac {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/crypto/csr/spkac/resources");
    private static final String SPKAC_PROPERTY = "SPKAC";
    private static final String NEWLINE = System.getProperty("line.separator");
    private String challenge;
    private SpkacSubject subject;
    private SignatureType signatureAlgorithm;
    private byte[] signature;
    private PublicKey publicKey;
    private byte[] derSpkac;

    public Spkac(String challenge, SignatureType signatureAlgorithm, SpkacSubject subject, PublicKey publicKey, PrivateKey privateKey) throws SpkacException {
        this.challenge = challenge;
        this.signatureAlgorithm = signatureAlgorithm;
        this.subject = subject;
        this.publicKey = publicKey;
        this.signature = this.createSignature(privateKey);
    }

    public Spkac(byte[] data) throws IOException, SpkacException {
        Properties properties = this.readProperties(data);
        if (!properties.containsKey(SPKAC_PROPERTY)) {
            throw new SpkacMissingPropertyException(MessageFormat.format(res.getString("SpkacNoIncludeRequiredProperty.exception.message"), SPKAC_PROPERTY));
        }
        this.subject = this.getSubject(properties);
        String spkacProperty = properties.getProperty(SPKAC_PROPERTY);
        this.derSpkac = Base64.decode((String)spkacProperty);
        this.decodeSpkac(this.derSpkac);
    }

    private Properties readProperties(byte[] data) throws IOException {
        Properties properties = new Properties();
        try (InputStreamReader isr = new InputStreamReader(new ByteArrayInputStream(data));
             BufferedReader br = new BufferedReader(isr);){
            String line;
            String lastName = null;
            while ((line = br.readLine()) != null) {
                int equalsPos = (line = line.trim()).indexOf("=");
                if (equalsPos > 0 && equalsPos + 1 < line.length()) {
                    String name = line.substring(0, equalsPos);
                    String value = line.substring(equalsPos + 1);
                    properties.setProperty(name, value);
                    lastName = name;
                    continue;
                }
                if (lastName == null) continue;
                properties.setProperty(lastName, String.valueOf(properties.get(lastName)) + line);
            }
        }
        return properties;
    }

    private SpkacSubject getSubject(Properties properties) throws SpkacMissingPropertyException {
        String cn = properties.getProperty("CN");
        String ou = properties.getProperty("OU");
        String o = properties.getProperty("O");
        String l = properties.getProperty("L");
        String st = properties.getProperty("ST");
        String c = properties.getProperty("C");
        if (cn == null && ou == null && o == null && l == null && st == null && c == null) {
            throw new SpkacMissingPropertyException(res.getString("SpkacNoIncludeSubjectProperties.exception.message"));
        }
        return new SpkacSubject(cn, ou, o, l, st, c);
    }

    private void decodeSpkac(byte[] der) throws SpkacException {
        try {
            ASN1Sequence signedPublicKeyAndChallenge = ASN1Sequence.getInstance((Object)der);
            ASN1Sequence publicKeyAndChallenge = (ASN1Sequence)signedPublicKeyAndChallenge.getObjectAt(0);
            ASN1Sequence signatureAlgorithm = (ASN1Sequence)signedPublicKeyAndChallenge.getObjectAt(1);
            DERBitString signature = (DERBitString)signedPublicKeyAndChallenge.getObjectAt(2);
            ASN1ObjectIdentifier signatureAlgorithmOid = (ASN1ObjectIdentifier)signatureAlgorithm.getObjectAt(0);
            ASN1Sequence spki = (ASN1Sequence)publicKeyAndChallenge.getObjectAt(0);
            DERIA5String challenge = (DERIA5String)publicKeyAndChallenge.getObjectAt(1);
            ASN1Sequence publicKeyAlgorithm = (ASN1Sequence)spki.getObjectAt(0);
            DERBitString publicKey = (DERBitString)spki.getObjectAt(1);
            ASN1ObjectIdentifier publicKeyAlgorithmOid = (ASN1ObjectIdentifier)publicKeyAlgorithm.getObjectAt(0);
            ASN1Primitive algorithmParameters = publicKeyAlgorithm.getObjectAt(1).toASN1Primitive();
            this.challenge = challenge.getString();
            this.publicKey = this.decodePublicKeyFromBitString(publicKeyAlgorithmOid, algorithmParameters, publicKey);
            this.signatureAlgorithm = this.getSignatureAlgorithm(signatureAlgorithmOid);
            this.signature = signature.getBytes();
        }
        catch (Exception ex) {
            throw new SpkacException(res.getString("NoDecodeSpkac.exception.message"), ex);
        }
    }

    private SignatureType getSignatureAlgorithm(ASN1ObjectIdentifier signatureAlgorithmOid) throws SpkacException {
        SignatureType signatureAlgorithm = SignatureType.resolveOid(signatureAlgorithmOid.getId());
        if (signatureAlgorithm == null) {
            throw new SpkacException(MessageFormat.format(res.getString("NoSupportSignatureAlgorithm.exception.message"), signatureAlgorithmOid.getId()));
        }
        return signatureAlgorithm;
    }

    private PublicKey decodePublicKeyFromBitString(ASN1ObjectIdentifier publicKeyAlgorithmOid, ASN1Primitive algorithmParameters, DERBitString publicKey) throws SpkacException {
        if (publicKeyAlgorithmOid.getId().equals(KeyPairType.RSA.oid())) {
            return this.decodeRsaPublicKeyFromBitString(publicKey);
        }
        if (publicKeyAlgorithmOid.getId().equals(KeyPairType.DSA.oid())) {
            ASN1Sequence dssParams = (ASN1Sequence)algorithmParameters;
            BigInteger p = ((ASN1Integer)dssParams.getObjectAt(0)).getValue();
            BigInteger q = ((ASN1Integer)dssParams.getObjectAt(1)).getValue();
            BigInteger g = ((ASN1Integer)dssParams.getObjectAt(2)).getValue();
            return this.decodeDsaPublicKeyFromBitString(publicKey, p, q, g);
        }
        throw new SpkacException(MessageFormat.format(res.getString("NoSupportPublicKeyAlgorithm.exception.message"), publicKeyAlgorithmOid.getId()));
    }

    private RSAPublicKey decodeRsaPublicKeyFromBitString(DERBitString der) throws SpkacException {
        try {
            ASN1Sequence rsaPublicKey = ASN1Sequence.getInstance((Object)der.getBytes());
            BigInteger modulus = ((ASN1Integer)rsaPublicKey.getObjectAt(0)).getValue();
            BigInteger publicExponent = ((ASN1Integer)rsaPublicKey.getObjectAt(1)).getValue();
            KeyFactory keyFact = KeyFactory.getInstance("RSA");
            return (RSAPublicKey)keyFact.generatePublic(new RSAPublicKeySpec(modulus, publicExponent));
        }
        catch (GeneralSecurityException ex) {
            throw new SpkacException(res.getString("NoGenerateRsaPublicKeyFromSpkac.exception.message"), ex);
        }
        catch (Exception ex) {
            throw new SpkacException(res.getString("NoGenerateRsaPublicKeyFromSpkac.exception.message"), ex);
        }
    }

    private DERBitString encodePublicKeyAsBitString(PublicKey publicKey) throws SpkacException {
        byte[] encodedPublicKey = publicKey instanceof RSAPublicKey ? this.encodeRsaPublicKeyAsBitString((RSAPublicKey)publicKey) : this.encodeDsaPublicKeyAsBitString((DSAPublicKey)publicKey);
        return new DERBitString(encodedPublicKey);
    }

    private byte[] encodeRsaPublicKeyAsBitString(RSAPublicKey rsaPublicKey) throws SpkacException {
        try {
            ASN1EncodableVector vec = new ASN1EncodableVector();
            vec.add((ASN1Encodable)new ASN1Integer(rsaPublicKey.getModulus()));
            vec.add((ASN1Encodable)new ASN1Integer(rsaPublicKey.getPublicExponent()));
            DERSequence derSequence = new DERSequence(vec);
            return derSequence.getEncoded("DER");
        }
        catch (Exception ex) {
            throw new SpkacException(res.getString("NoEncodeRsaPublicKey.exception.message"), ex);
        }
    }

    private DSAPublicKey decodeDsaPublicKeyFromBitString(DERBitString der, BigInteger p, BigInteger q, BigInteger g) throws SpkacException {
        try {
            BigInteger y = ASN1Integer.getInstance((Object)der.getBytes()).getValue();
            KeyFactory keyFact = KeyFactory.getInstance("DSA");
            return (DSAPublicKey)keyFact.generatePublic(new DSAPublicKeySpec(y, p, q, g));
        }
        catch (GeneralSecurityException ex) {
            throw new SpkacException(res.getString("NoGenerateDsaPublicKeyFromSpkac.exception.message"), ex);
        }
        catch (Exception ex) {
            throw new SpkacException(res.getString("NoGenerateDsaPublicKeyFromSpkac.exception.message"), ex);
        }
    }

    private byte[] encodeDsaPublicKeyAsBitString(DSAPublicKey dsaPublicKey) throws SpkacException {
        try {
            ASN1Integer publicKey = new ASN1Integer(dsaPublicKey.getY());
            return publicKey.getEncoded("DER");
        }
        catch (Exception ex) {
            throw new SpkacException(res.getString("NoEncodeDsaPublicKey.exception.message"), ex);
        }
    }

    public void output(OutputStream os) throws IOException, SpkacException {
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter(os);
            this.outputProperty(osw, SPKAC_PROPERTY, new String(Base64.encode((byte[])this.createSignedPublicKeyAndChallenge().getEncoded("DER"))));
            this.outputProperty(osw, "CN", this.subject.getCN());
            this.outputProperty(osw, "OU", this.subject.getOU());
            this.outputProperty(osw, "O", this.subject.getO());
            this.outputProperty(osw, "L", this.subject.getL());
            this.outputProperty(osw, "ST", this.subject.getST());
            this.outputProperty(osw, "C", this.subject.getC());
        }
        catch (IOException ex) {
            try {
                throw new SpkacException(res.getString("NoOutputSpkac.exception.message"), ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(osw);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(osw);
    }

    private void outputProperty(Writer w, String name, String value) throws IOException {
        if (value != null) {
            w.write(name + "=" + value + NEWLINE);
        }
    }

    public boolean verify(String challenge) throws SpkacException {
        if (!challenge.equals(this.getChallenge())) {
            return false;
        }
        return this.verify();
    }

    public boolean verify() throws SpkacException {
        try {
            byte[] publicKeyAndChallenge = this.createPublicKeyAndChallengeForSigning();
            Signature sig = Signature.getInstance(this.getSignatureAlgorithm().jce());
            sig.initVerify(this.getPublicKey());
            sig.update(publicKeyAndChallenge);
            return sig.verify(this.signature);
        }
        catch (GeneralSecurityException ex) {
            throw new SpkacException(res.getString("NoVerifySpkacSignature.exception.message"), ex);
        }
    }

    private byte[] createSignature(PrivateKey privateKey) throws SpkacException {
        try {
            byte[] publicKeyAndChallenge = this.createPublicKeyAndChallengeForSigning();
            Signature sig = Signature.getInstance(this.getSignatureAlgorithm().jce());
            sig.initSign(privateKey);
            sig.update(publicKeyAndChallenge);
            return sig.sign();
        }
        catch (GeneralSecurityException ex) {
            throw new SpkacException(res.getString("NoCreateSpkacSignature.exception.message"), ex);
        }
    }

    private ASN1Sequence createSignedPublicKeyAndChallenge() throws SpkacException {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        vec.add((ASN1Encodable)new ASN1ObjectIdentifier(this.getSignatureAlgorithm().oid()));
        vec.add((ASN1Encodable)DERNull.INSTANCE);
        DERSequence signatureAlgorithm = new DERSequence(vec);
        vec = new ASN1EncodableVector();
        vec.add((ASN1Encodable)this.createPublicKeyAndChallenge());
        vec.add((ASN1Encodable)signatureAlgorithm);
        vec.add((ASN1Encodable)new DERBitString(this.signature));
        return new DERSequence(vec);
    }

    private ASN1Sequence createPublicKeyAndChallenge() throws SpkacException {
        ASN1EncodableVector publicKeyAlgorithm = new ASN1EncodableVector();
        publicKeyAlgorithm.add((ASN1Encodable)new ASN1ObjectIdentifier(this.getPublicKeyAlg().oid()));
        if (this.getPublicKey() instanceof RSAPublicKey) {
            publicKeyAlgorithm.add((ASN1Encodable)DERNull.INSTANCE);
        } else {
            DSAParams dsaParams = ((DSAPublicKey)this.getPublicKey()).getParams();
            ASN1EncodableVector dssParams = new ASN1EncodableVector();
            dssParams.add((ASN1Encodable)new ASN1Integer(dsaParams.getP()));
            dssParams.add((ASN1Encodable)new ASN1Integer(dsaParams.getQ()));
            dssParams.add((ASN1Encodable)new ASN1Integer(dsaParams.getG()));
            publicKeyAlgorithm.add((ASN1Encodable)new DERSequence(dssParams));
        }
        ASN1EncodableVector spki = new ASN1EncodableVector();
        spki.add((ASN1Encodable)new DERSequence(publicKeyAlgorithm));
        spki.add((ASN1Encodable)this.encodePublicKeyAsBitString(this.getPublicKey()));
        ASN1EncodableVector publicKeyAndChallenge = new ASN1EncodableVector();
        publicKeyAndChallenge.add((ASN1Encodable)new DERSequence(spki));
        publicKeyAndChallenge.add((ASN1Encodable)new DERIA5String(this.getChallenge()));
        return new DERSequence(publicKeyAndChallenge);
    }

    private byte[] createPublicKeyAndChallengeForSigning() throws SpkacException {
        try {
            return new DERBitString(this.createPublicKeyAndChallenge().getEncoded("DER")).getBytes();
        }
        catch (Exception ex) {
            throw new SpkacException(res.getString("NoGetPublicKeyAndChallengeForSignature.exception.message"), ex);
        }
    }

    public String getChallenge() {
        return this.challenge;
    }

    public SpkacSubject getSubject() {
        return this.subject;
    }

    public SignatureType getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public KeyPairType getPublicKeyAlg() {
        if (this.getPublicKey() instanceof RSAPublicKey) {
            return KeyPairType.RSA;
        }
        return KeyPairType.DSA;
    }

    public byte[] getEncoded() {
        return this.derSpkac;
    }

    public String toString() {
        return "challenge=" + this.getChallenge() + ", signatureAlgorithm=" + (Object)((Object)this.signatureAlgorithm) + ", signature=" + HexUtil.getHexString(this.signature) + ", subject=" + this.getSubject() + ", publicKey=" + this.publicKey;
    }
}

