/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.keypair;

public enum KeyPairType {
    RSA("RSA", "1.2.840.113549.1.1.1", 512, 16384, 8),
    DSA("DSA", "1.2.840.10040.4.1", 512, 2048, 64),
    EC("EC", "1.2.840.10045.2.1", 160, 571, 32),
    ECDSA("ECDSA", "1.2.840.10045.2.1", 160, 571, 32);

    private String jce;
    private String oid;
    private int minSize;
    private int maxSize;
    private int stepSize;

    private KeyPairType(String jce, String oid, int minSize, int maxSize, int stepSize) {
        this.jce = jce;
        this.oid = oid;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.stepSize = stepSize;
    }

    public String jce() {
        return this.jce;
    }

    public String oid() {
        return this.oid;
    }

    public int minSize() {
        return this.minSize;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public int stepSize() {
        return this.stepSize;
    }

    public static KeyPairType resolveJce(String jce) {
        for (KeyPairType keyPairType : KeyPairType.values()) {
            if (!jce.equals(keyPairType.jce())) continue;
            return keyPairType;
        }
        return null;
    }

    public String toString() {
        return this.jce();
    }
}

