/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.privatekey;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Random;
import java.util.ResourceBundle;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.kse.crypto.CryptoException;
import org.kse.crypto.Password;
import org.kse.crypto.privatekey.EncryptionType;
import org.kse.crypto.privatekey.PrivateKeyEncryptedException;
import org.kse.crypto.privatekey.PrivateKeyUnencryptedException;
import org.kse.utilities.io.UnsignedUtil;

public class MsPvkUtil {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/crypto/privatekey/resources");
    private static final long PVK_MAGIC_NUMBER = 2964713758L;
    private static final int PVK_RESERVED = 0;
    public static final int PVK_KEY_EXCHANGE = 1;
    public static final int PVK_KEY_SIGNATURE = 2;
    private static final long PVK_UNENCRYPTED = 0L;
    private static final int PVK_ENCRYPTED = 1;
    private static final long UNENCRYPTED_SALT_LENGTH = 0L;
    private static final int ENCRYPTED_SALT_LENGTH = 16;
    private static final short PRIVATE_KEY_BLOB = 7;
    private static final short CUR_BLOB_VERSION = 2;
    private static final int BLOB_RESERVED = 0;
    private static final int CALG_RSA_SIGN = 9216;
    private static final int CALG_RSA_KEYX = 41984;
    private static final int CALG_DSS_SIGN = 8704;
    private static final int RSA_PRIV_MAGIC = 843141970;
    private static final int DSS_PRIV_MAGIC = 844321604;
    private static final int BLOB_HEADER_LENGTH = 8;
    private static final int PVK_BUFFER_LENGTH = 8192;

    private MsPvkUtil() {
    }

    public static PrivateKey load(byte[] pvk) throws IOException, CryptoException {
        ByteBuffer bb = ByteBuffer.wrap(pvk);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        long keyType = MsPvkUtil.readReservedMagicKeyType(bb);
        long encrypted = UnsignedUtil.getInt(bb);
        if (encrypted != 0L) {
            throw new PrivateKeyEncryptedException(MessageFormat.format(res.getString("MsPvkIsEncrypted.exception.message"), Long.toHexString(encrypted), Long.toHexString(0L)));
        }
        long saltLength = UnsignedUtil.getInt(bb);
        if (saltLength != 0L) {
            throw new CryptoException(MessageFormat.format(res.getString("InvalidMsPvkSaltLengthField.exception.message"), Long.toHexString(saltLength), Long.toHexString(0L)));
        }
        long keyLength = UnsignedUtil.getInt(bb);
        MsPvkUtil.readPrivateKeyBlobHeader(bb, keyType);
        byte[] privateKeyBlob = new byte[bb.remaining()];
        bb.get(privateKeyBlob);
        if (keyLength != (long)(privateKeyBlob.length + 8)) {
            throw new CryptoException(MessageFormat.format(res.getString("InvalidMsPvkKeyLengthField.exception.message"), Long.toHexString(keyLength), Long.toHexString(privateKeyBlob.length + 8)));
        }
        return MsPvkUtil.blobToPrivateKey(privateKeyBlob);
    }

    public static PrivateKey loadEncrypted(byte[] pvk, Password password) throws IOException, CryptoException {
        try {
            ByteBuffer bb = ByteBuffer.wrap(pvk);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            long keyType = MsPvkUtil.readReservedMagicKeyType(bb);
            long encrypted = UnsignedUtil.getInt(bb);
            if (encrypted != 1L) {
                throw new PrivateKeyUnencryptedException(MessageFormat.format(res.getString("MsPvkIsUnencrypted.exception.message"), Long.toHexString(encrypted), Long.toHexString(1L)));
            }
            long saltLength = UnsignedUtil.getInt(bb);
            if (saltLength != 16L) {
                throw new CryptoException(MessageFormat.format(res.getString("InvalidMsPvkSaltLengthField.exception.message"), Long.toHexString(saltLength), Long.toHexString(16L)));
            }
            long keyLength = UnsignedUtil.getInt(bb);
            byte[] strongKey = new byte[16];
            byte[] weakKey = new byte[16];
            byte[] salt = new byte[(int)saltLength];
            bb.get(salt);
            MessageDigest messagedigest = MessageDigest.getInstance("SHA1");
            byte[] passwordBytes = new String(password.toCharArray()).getBytes();
            byte[] saltAndPassword = new byte[salt.length + passwordBytes.length];
            System.arraycopy(salt, 0, saltAndPassword, 0, salt.length);
            System.arraycopy(passwordBytes, 0, saltAndPassword, salt.length, passwordBytes.length);
            byte[] key = messagedigest.digest(saltAndPassword);
            System.arraycopy(key, 0, strongKey, 0, 16);
            System.arraycopy(key, 0, weakKey, 0, 5);
            for (int i = 5; i < 16; ++i) {
                weakKey[i] = 0;
            }
            MsPvkUtil.readPrivateKeyBlobHeader(bb, keyType);
            byte[] encryptedPrivateKeyBlob = new byte[bb.remaining()];
            bb.get(encryptedPrivateKeyBlob);
            if (keyLength != (long)(encryptedPrivateKeyBlob.length + 8)) {
                throw new CryptoException(MessageFormat.format(res.getString("InvalidMsPvkKeyLengthField.exception.message"), Long.toHexString(keyLength), Long.toHexString(encryptedPrivateKeyBlob.length + 8)));
            }
            byte[] decryptedPrivateKeyBlob = MsPvkUtil.decryptPrivateKeyBlob(encryptedPrivateKeyBlob, strongKey);
            if (decryptedPrivateKeyBlob == null && (decryptedPrivateKeyBlob = MsPvkUtil.decryptPrivateKeyBlob(encryptedPrivateKeyBlob, weakKey)) == null) {
                throw new CryptoException(res.getString("NoDecryptMsPvkCheckPassword.exception.message"));
            }
            return MsPvkUtil.blobToPrivateKey(decryptedPrivateKeyBlob);
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(res.getString("NoLoadMsPvk.exception.message"), ex);
        }
    }

    public static byte[] get(RSAPrivateCrtKey privateKey, int keyType) throws CryptoException {
        return MsPvkUtil.getInternal(privateKey, keyType);
    }

    public static byte[] get(DSAPrivateKey privateKey) throws CryptoException {
        return MsPvkUtil.getInternal(privateKey, 2);
    }

    public static EncryptionType getEncryptionType(byte[] pvk) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(pvk);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        long magic = UnsignedUtil.getInt(bb);
        if (magic != 2964713758L) {
            return null;
        }
        long reserved = UnsignedUtil.getInt(bb);
        if (reserved != 0L) {
            return null;
        }
        long keyType = UnsignedUtil.getInt(bb);
        if (keyType != 1L && keyType != 2L) {
            return null;
        }
        long encrypted = UnsignedUtil.getInt(bb);
        if (encrypted == 1L) {
            return EncryptionType.ENCRYPTED;
        }
        if (encrypted == 0L) {
            return EncryptionType.UNENCRYPTED;
        }
        return null;
    }

    private static byte[] getInternal(PrivateKey privateKey, int keyType) throws CryptoException {
        try {
            ByteBuffer bb = ByteBuffer.wrap(new byte[8192]);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            MsPvkUtil.writeReservedMagicKeyType(bb, keyType);
            byte[] privateKeyBlob = null;
            privateKeyBlob = privateKey instanceof RSAPrivateCrtKey ? MsPvkUtil.rsaPrivateKeyToBlob((RSAPrivateCrtKey)privateKey) : MsPvkUtil.dsaPrivateKeyToBlob((DSAPrivateKey)privateKey);
            UnsignedUtil.putInt(bb, 0L);
            UnsignedUtil.putInt(bb, 0L);
            long keyLength = privateKeyBlob.length + 8;
            UnsignedUtil.putInt(bb, keyLength);
            MsPvkUtil.writePrivateKeyBlobHeader(bb, keyType, privateKey);
            bb.put(privateKeyBlob);
            byte[] pvk = MsPvkUtil.getBufferBytes(bb);
            return pvk;
        }
        catch (IOException ex) {
            throw new CryptoException(res.getString("NoGetMsPvk.exception.message"), ex);
        }
    }

    public static byte[] getEncrypted(RSAPrivateCrtKey privateKey, int keyType, Password password, boolean strong) throws CryptoException {
        return MsPvkUtil.getEncryptedInternal(privateKey, keyType, password, strong);
    }

    public static byte[] getEncrypted(DSAPrivateKey privateKey, Password password, boolean strong) throws CryptoException {
        return MsPvkUtil.getEncryptedInternal(privateKey, 2, password, strong);
    }

    private static byte[] getEncryptedInternal(PrivateKey privateKey, int keyType, Password password, boolean strong) throws CryptoException {
        try {
            ByteBuffer bb = ByteBuffer.wrap(new byte[8192]);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            MsPvkUtil.writeReservedMagicKeyType(bb, keyType);
            byte[] passwordBytes = new String(password.toCharArray()).getBytes();
            byte[] salt = MsPvkUtil.generate16ByteSalt();
            byte[] saltAndPassword = new byte[salt.length + passwordBytes.length];
            System.arraycopy(salt, 0, saltAndPassword, 0, salt.length);
            System.arraycopy(passwordBytes, 0, saltAndPassword, salt.length, passwordBytes.length);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            byte[] key = messageDigest.digest(saltAndPassword);
            byte[] privateKeyBlob = null;
            privateKeyBlob = privateKey instanceof RSAPrivateCrtKey ? MsPvkUtil.rsaPrivateKeyToBlob((RSAPrivateCrtKey)privateKey) : MsPvkUtil.dsaPrivateKeyToBlob((DSAPrivateKey)privateKey);
            byte[] encryptedPrivateKeyBlob = null;
            if (strong) {
                byte[] strongKey = new byte[16];
                System.arraycopy(key, 0, strongKey, 0, strongKey.length);
                encryptedPrivateKeyBlob = MsPvkUtil.encryptPrivateKeyBlob(privateKeyBlob, strongKey);
            } else {
                byte[] weakKey = new byte[16];
                System.arraycopy(key, 0, weakKey, 0, 5);
                for (int i = 5; i < weakKey.length; ++i) {
                    weakKey[i] = 0;
                }
                encryptedPrivateKeyBlob = MsPvkUtil.encryptPrivateKeyBlob(privateKeyBlob, weakKey);
            }
            UnsignedUtil.putInt(bb, 1L);
            UnsignedUtil.putInt(bb, salt.length);
            int keyLength = encryptedPrivateKeyBlob.length + 8;
            UnsignedUtil.putInt(bb, keyLength);
            bb.put(salt);
            MsPvkUtil.writePrivateKeyBlobHeader(bb, keyType, privateKey);
            bb.put(encryptedPrivateKeyBlob);
            byte[] encryptedPvk = MsPvkUtil.getBufferBytes(bb);
            return encryptedPvk;
        }
        catch (IOException ex) {
            throw new CryptoException(res.getString("NoGetMsPvk.exception.message"), ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CryptoException(res.getString("NoGetMsPvk.exception.message"), ex);
        }
    }

    private static void writeReservedMagicKeyType(ByteBuffer bb, long keyType) throws IOException, CryptoException {
        UnsignedUtil.putInt(bb, 2964713758L);
        UnsignedUtil.putInt(bb, 0L);
        if (keyType != 1L && keyType != 2L) {
            throw new CryptoException(MessageFormat.format(res.getString("InvalidMsPvkKeyTypeField.exception.message"), Long.toHexString(keyType), Long.toHexString(1L), Long.toHexString(2L)));
        }
        UnsignedUtil.putInt(bb, keyType);
    }

    private static long readReservedMagicKeyType(ByteBuffer bb) throws IOException, CryptoException {
        long magic = UnsignedUtil.getInt(bb);
        if (magic != 2964713758L) {
            throw new CryptoException(MessageFormat.format(res.getString("InvalidMsPvkMagicField.exception.message"), Long.toHexString(magic), Long.toHexString(2964713758L)));
        }
        long reserved = UnsignedUtil.getInt(bb);
        if (reserved != 0L) {
            throw new CryptoException(MessageFormat.format(res.getString("InvalidMsPvkReservedField.exception.message"), Long.toHexString(reserved), Long.toHexString(0L)));
        }
        long keyType = UnsignedUtil.getInt(bb);
        if (keyType != 1L && keyType != 2L) {
            throw new CryptoException(MessageFormat.format(res.getString("InvalidMsPvkKeyTypeField.exception.message"), Long.toHexString(keyType), Long.toHexString(1L), Long.toHexString(2L)));
        }
        return keyType;
    }

    private static void writePrivateKeyBlobHeader(ByteBuffer bb, long keyType, PrivateKey privateKey) throws IOException {
        UnsignedUtil.putByte(bb, (short)7);
        UnsignedUtil.putByte(bb, (short)2);
        UnsignedUtil.putShort(bb, 0);
        if (keyType == 2L) {
            if (privateKey instanceof RSAPrivateCrtKey) {
                UnsignedUtil.putInt(bb, 9216L);
            } else {
                UnsignedUtil.putInt(bb, 8704L);
            }
        } else {
            UnsignedUtil.putInt(bb, 41984L);
        }
    }

    private static void readPrivateKeyBlobHeader(ByteBuffer bb, long keyType) throws IOException, CryptoException {
        short blobType = UnsignedUtil.getByte(bb);
        if (blobType != 7) {
            throw new CryptoException(MessageFormat.format(res.getString("InvalidBlobHeaderTypeField.exception.message"), Integer.toHexString(blobType), Integer.toHexString(7)));
        }
        short blobVersion = UnsignedUtil.getByte(bb);
        if (blobVersion != 2) {
            throw new CryptoException(MessageFormat.format(res.getString("InvalidBlobHeaderVersionField.exception.message"), Integer.toHexString(blobVersion), Integer.toHexString(2)));
        }
        int blobReserved = UnsignedUtil.getShort(bb);
        if (blobReserved != 0) {
            throw new CryptoException(MessageFormat.format(res.getString("InvalidBlobHeaderReservedField.exception.message"), Integer.toHexString(blobReserved), Integer.toHexString(0)));
        }
        long keyAlgId = UnsignedUtil.getInt(bb);
        if (keyType == 2L) {
            if (keyAlgId != 9216L && keyAlgId != 8704L) {
                throw new CryptoException(MessageFormat.format(res.getString("InvalidBlobHeaderKeyAlgIdField.exception.message"), Long.toHexString(keyAlgId), Long.toHexString(9216L), Long.toHexString(8704L)));
            }
        } else if (keyAlgId != 41984L) {
            throw new CryptoException(MessageFormat.format(res.getString("InvalidBlobHeaderKeyAlgIdField.exception.message"), Long.toHexString(keyAlgId), Long.toHexString(41984L)));
        }
    }

    private static PrivateKey blobToPrivateKey(byte[] privateKeyBlob) throws CryptoException {
        if (privateKeyBlob[0] == 82 && privateKeyBlob[1] == 83 && privateKeyBlob[2] == 65 && privateKeyBlob[3] == 50) {
            return MsPvkUtil.blobToRsaPrivateKey(privateKeyBlob);
        }
        return MsPvkUtil.blobToDsaPrivateKey(privateKeyBlob);
    }

    private static RSAPrivateCrtKey blobToRsaPrivateKey(byte[] rsaPrivateKeyBlob) throws CryptoException {
        try {
            ByteBuffer bb = ByteBuffer.wrap(rsaPrivateKeyBlob);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            long magic = UnsignedUtil.getInt(bb);
            if (magic != 843141970L) {
                throw new CryptoException(MessageFormat.format(res.getString("InvalidRsaMagicField.exception.message"), Long.toHexString(magic), Long.toHexString(843141970L)));
            }
            long bitLength = UnsignedUtil.getInt(bb);
            int add8 = 0;
            if (bitLength % 8L != 0L) {
                ++add8;
            }
            int add16 = 0;
            if (bitLength % 16L != 0L) {
                ++add16;
            }
            BigInteger publicExponent = new BigInteger(Long.toString(UnsignedUtil.getInt(bb)));
            BigInteger modulus = MsPvkUtil.readBigInteger(bb, (int)(bitLength / 8L) + add8);
            BigInteger prime1 = MsPvkUtil.readBigInteger(bb, (int)(bitLength / 16L) + add16);
            BigInteger prime2 = MsPvkUtil.readBigInteger(bb, (int)(bitLength / 16L) + add16);
            BigInteger exponent1 = MsPvkUtil.readBigInteger(bb, (int)(bitLength / 16L) + add16);
            BigInteger exponent2 = MsPvkUtil.readBigInteger(bb, (int)(bitLength / 16L) + add16);
            BigInteger coefficient = MsPvkUtil.readBigInteger(bb, (int)(bitLength / 16L) + add16);
            BigInteger privateExponent = MsPvkUtil.readBigInteger(bb, (int)(bitLength / 8L) + add8);
            RSAPrivateCrtKeySpec rsaPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, prime1, prime2, exponent1, exponent2, coefficient);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPrivateCrtKey)keyFactory.generatePrivate(rsaPrivateCrtKeySpec);
        }
        catch (IOException ex) {
            throw new CryptoException(res.getString("NoConvertBlobToRsaKey.exception.message"), ex);
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(res.getString("NoConvertBlobToRsaKey.exception.message"), ex);
        }
    }

    private static DSAPrivateKey blobToDsaPrivateKey(byte[] dsaPrivateKeyBlob) throws CryptoException {
        try {
            ByteBuffer bb = ByteBuffer.wrap(dsaPrivateKeyBlob);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            long magic = UnsignedUtil.getInt(bb);
            if (magic != 844321604L) {
                throw new CryptoException(MessageFormat.format(res.getString("InvalidDsaMagicField.exception.message"), Long.toHexString(magic), Long.toHexString(844321604L)));
            }
            long bitLength = UnsignedUtil.getInt(bb);
            BigInteger p = MsPvkUtil.readBigInteger(bb, (int)(bitLength / 8L));
            BigInteger q = MsPvkUtil.readBigInteger(bb, 20);
            BigInteger g = MsPvkUtil.readBigInteger(bb, (int)(bitLength / 8L));
            BigInteger x = MsPvkUtil.readBigInteger(bb, 20);
            for (int i = 0; i < 24; ++i) {
                bb.get();
            }
            DSAPrivateKeySpec dsaPrivateKeySpec = new DSAPrivateKeySpec(x, p, q, g);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            return (DSAPrivateKey)keyFactory.generatePrivate(dsaPrivateKeySpec);
        }
        catch (IOException ex) {
            throw new CryptoException(res.getString("NoConvertBlobToDsaKey.exception.message"), ex);
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(res.getString("NoConvertBlobToDsaKey.exception.message"), ex);
        }
    }

    private static byte[] rsaPrivateKeyToBlob(RSAPrivateCrtKey rsaPrivCrtKey) throws CryptoException {
        try {
            ByteBuffer bb = ByteBuffer.wrap(new byte[4096]);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            UnsignedUtil.putInt(bb, 843141970L);
            BigInteger modulus = rsaPrivCrtKey.getModulus();
            int bitLength = modulus.bitLength();
            UnsignedUtil.putInt(bb, bitLength);
            BigInteger publicExponent = rsaPrivCrtKey.getPublicExponent();
            UnsignedUtil.putInt(bb, (int)publicExponent.longValue());
            int add8 = 0;
            if (bitLength % 8 != 0) {
                ++add8;
            }
            int add16 = 0;
            if (bitLength % 16 != 0) {
                ++add16;
            }
            MsPvkUtil.writeBigInteger(bb, modulus, bitLength / 8 + add8);
            MsPvkUtil.writeBigInteger(bb, rsaPrivCrtKey.getPrimeP(), bitLength / 16 + add16);
            MsPvkUtil.writeBigInteger(bb, rsaPrivCrtKey.getPrimeQ(), bitLength / 16 + add16);
            MsPvkUtil.writeBigInteger(bb, rsaPrivCrtKey.getPrimeExponentP(), bitLength / 16 + add16);
            MsPvkUtil.writeBigInteger(bb, rsaPrivCrtKey.getPrimeExponentQ(), bitLength / 16 + add16);
            MsPvkUtil.writeBigInteger(bb, rsaPrivCrtKey.getCrtCoefficient(), bitLength / 16 + add16);
            MsPvkUtil.writeBigInteger(bb, rsaPrivCrtKey.getPrivateExponent(), bitLength / 8 + add8);
            return MsPvkUtil.getBufferBytes(bb);
        }
        catch (IOException ex) {
            throw new CryptoException(res.getString("NoConvertKeyToBlob.exception.message"), ex);
        }
    }

    private static byte[] dsaPrivateKeyToBlob(DSAPrivateKey dsaPrivKey) throws CryptoException {
        try {
            DSAParams dsaParams = dsaPrivKey.getParams();
            ByteBuffer bb = ByteBuffer.wrap(new byte[512]);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            UnsignedUtil.putInt(bb, 844321604L);
            BigInteger prime = dsaParams.getP();
            int bitLength = prime.toString(2).length();
            UnsignedUtil.putInt(bb, bitLength);
            MsPvkUtil.writeBigInteger(bb, dsaParams.getP(), bitLength / 8);
            MsPvkUtil.writeBigInteger(bb, dsaParams.getQ(), 20);
            MsPvkUtil.writeBigInteger(bb, dsaParams.getG(), bitLength / 8);
            MsPvkUtil.writeBigInteger(bb, dsaPrivKey.getX(), 20);
            UnsignedUtil.putInt(bb, -1L);
            for (int i = 0; i < 20; ++i) {
                bb.put((byte)-1);
            }
            return MsPvkUtil.getBufferBytes(bb);
        }
        catch (IOException ex) {
            throw new CryptoException(res.getString("NoConvertKeyToBlob.exception.message"), ex);
        }
    }

    private static byte[] decryptPrivateKeyBlob(byte[] encryptedPvk, byte[] rc4Key) throws CryptoException {
        try {
            SecretKeySpec rc4KeySpec = new SecretKeySpec(rc4Key, "RC4");
            Cipher rc42 = Cipher.getInstance("RC4");
            rc42.init(2, rc4KeySpec);
            byte[] decryptedKeyBlob = rc42.doFinal(encryptedPvk);
            if (decryptedKeyBlob[0] == 82 && decryptedKeyBlob[1] == 83 && decryptedKeyBlob[2] == 65 && decryptedKeyBlob[3] == 50) {
                return decryptedKeyBlob;
            }
            if (decryptedKeyBlob[0] == 68 && decryptedKeyBlob[1] == 83 && decryptedKeyBlob[2] == 83 && decryptedKeyBlob[3] == 50) {
                return decryptedKeyBlob;
            }
            return null;
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(res.getString("PrivateKeyBlobRc4DecryptionFailed.exception.message"), ex);
        }
    }

    private static byte[] encryptPrivateKeyBlob(byte[] privateKeyBlob, byte[] rc4Key) throws CryptoException {
        try {
            SecretKeySpec rc4KeySpec = new SecretKeySpec(rc4Key, "RC4");
            Cipher rc42 = Cipher.getInstance("RC4");
            rc42.init(1, rc4KeySpec);
            return rc42.doFinal(privateKeyBlob);
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(res.getString("PrivateKeyBlobRc4EncryptionFailed.exception.message"), ex);
        }
    }

    private static byte[] generate16ByteSalt() {
        Random random = new Random();
        random.setSeed(Calendar.getInstance().getTimeInMillis());
        byte[] salt = new byte[16];
        random.nextBytes(salt);
        return salt;
    }

    private static byte[] getBufferBytes(ByteBuffer bb) {
        byte[] buffer = bb.array();
        byte[] written = new byte[bb.position()];
        System.arraycopy(buffer, 0, written, 0, written.length);
        return written;
    }

    private static BigInteger readBigInteger(ByteBuffer bb, int length) throws IOException {
        byte[] bigIntBytes = new byte[length];
        bb.get(bigIntBytes);
        MsPvkUtil.reverseBytes(bigIntBytes);
        BigInteger bigInt = new BigInteger(1, bigIntBytes);
        return bigInt;
    }

    private static void writeBigInteger(ByteBuffer bb, BigInteger bigInteger, int length) throws IOException {
        byte[] bigInt = bigInteger.toByteArray();
        int skipZeroPos = 0;
        for (int i = 0; i < bigInt.length && bigInt[i] == 0; ++i) {
            ++skipZeroPos;
        }
        byte[] tmp = new byte[bigInt.length - skipZeroPos];
        System.arraycopy(bigInt, skipZeroPos, tmp, 0, tmp.length);
        bigInt = tmp;
        MsPvkUtil.reverseBytes(bigInt);
        int padByteLength = length - bigInt.length;
        if (padByteLength > 0) {
            tmp = new byte[length];
            System.arraycopy(bigInt, 0, tmp, 0, bigInt.length);
            bigInt = tmp;
        }
        bb.put(bigInt);
    }

    private static void reverseBytes(byte[] bytes) {
        int halfWay = bytes.length / 2;
        for (int i = 0; i < halfWay; ++i) {
            byte b = bytes[i];
            bytes[i] = bytes[bytes.length - 1 - i];
            bytes[bytes.length - 1 - i] = b;
        }
    }
}

