/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.privatekey;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Random;
import java.util.ResourceBundle;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.kse.crypto.CryptoException;
import org.kse.crypto.Password;
import org.kse.crypto.digest.DigestType;
import org.kse.crypto.digest.DigestUtil;
import org.kse.crypto.ecc.EccUtil;
import org.kse.crypto.privatekey.EncryptionType;
import org.kse.crypto.privatekey.OpenSslPbeType;
import org.kse.crypto.privatekey.PrivateKeyEncryptedException;
import org.kse.crypto.privatekey.PrivateKeyPbeNotSupportedException;
import org.kse.crypto.privatekey.PrivateKeyUnencryptedException;
import org.kse.utilities.pem.PemAttribute;
import org.kse.utilities.pem.PemAttributes;
import org.kse.utilities.pem.PemInfo;
import org.kse.utilities.pem.PemUtil;

public class OpenSslPvkUtil {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/crypto/privatekey/resources");
    private static final String OPENSSL_RSA_PVK_PEM_TYPE = "RSA PRIVATE KEY";
    private static final String OPENSSL_DSA_PVK_PEM_TYPE = "DSA PRIVATE KEY";
    private static final String OPENSSL_EC_PVK_PEM_TYPE = "EC PRIVATE KEY";
    private static final BigInteger VERSION = BigInteger.ZERO;
    private static final BigInteger VERSION_EC = BigInteger.ONE;
    private static final String PROC_TYPE_ATTR_NAME = "Proc-Type";
    private static final String PROC_TYPE_ATTR_VALUE = "4,ENCRYPTED";
    private static final String DEK_INFO_ATTR_NAME = "DEK-Info";
    private static final String DEK_INFO_ATTR_VALUE_TEMPLATE = "{0},{1}";

    private OpenSslPvkUtil() {
    }

    public static byte[] get(PrivateKey privateKey) throws CryptoException {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        if (privateKey instanceof java.security.interfaces.ECPrivateKey) {
            try {
                java.security.interfaces.ECPrivateKey ecPrivKey = (java.security.interfaces.ECPrivateKey)privateKey;
                ECPrivateKey keyStructure = EccUtil.convertToECPrivateKeyStructure(ecPrivKey);
                return keyStructure.toASN1Primitive().getEncoded();
            }
            catch (IOException e) {
                throw new CryptoException(res.getString("NoDerEncodeOpenSslPrivateKey.exception.message"), e);
            }
        }
        if (privateKey instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rsaPrivateKey = (RSAPrivateCrtKey)privateKey;
            vec.add((ASN1Encodable)new ASN1Integer(VERSION));
            vec.add((ASN1Encodable)new ASN1Integer(rsaPrivateKey.getModulus()));
            vec.add((ASN1Encodable)new ASN1Integer(rsaPrivateKey.getPublicExponent()));
            vec.add((ASN1Encodable)new ASN1Integer(rsaPrivateKey.getPrivateExponent()));
            vec.add((ASN1Encodable)new ASN1Integer(rsaPrivateKey.getPrimeP()));
            vec.add((ASN1Encodable)new ASN1Integer(rsaPrivateKey.getPrimeQ()));
            vec.add((ASN1Encodable)new ASN1Integer(rsaPrivateKey.getPrimeExponentP()));
            vec.add((ASN1Encodable)new ASN1Integer(rsaPrivateKey.getPrimeExponentQ()));
            vec.add((ASN1Encodable)new ASN1Integer(rsaPrivateKey.getCrtCoefficient()));
        } else {
            DSAPrivateKey dsaPrivateKey = (DSAPrivateKey)privateKey;
            DSAParams dsaParams = dsaPrivateKey.getParams();
            BigInteger primeModulusP = dsaParams.getP();
            BigInteger primeQ = dsaParams.getQ();
            BigInteger generatorG = dsaParams.getG();
            BigInteger secretExponentX = dsaPrivateKey.getX();
            BigInteger publicExponentY = generatorG.modPow(secretExponentX, primeModulusP);
            vec.add((ASN1Encodable)new ASN1Integer(VERSION));
            vec.add((ASN1Encodable)new ASN1Integer(primeModulusP));
            vec.add((ASN1Encodable)new ASN1Integer(primeQ));
            vec.add((ASN1Encodable)new ASN1Integer(generatorG));
            vec.add((ASN1Encodable)new ASN1Integer(publicExponentY));
            vec.add((ASN1Encodable)new ASN1Integer(secretExponentX));
        }
        DERSequence derSequence = new DERSequence(vec);
        try {
            return derSequence.getEncoded();
        }
        catch (IOException ex) {
            throw new CryptoException(res.getString("NoDerEncodeOpenSslPrivateKey.exception.message"), ex);
        }
    }

    public static String getPem(PrivateKey privateKey) throws CryptoException {
        byte[] openSsl = OpenSslPvkUtil.get(privateKey);
        String pemType = null;
        pemType = privateKey instanceof RSAPrivateCrtKey ? OPENSSL_RSA_PVK_PEM_TYPE : (privateKey instanceof java.security.interfaces.ECPrivateKey ? OPENSSL_EC_PVK_PEM_TYPE : OPENSSL_DSA_PVK_PEM_TYPE);
        PemInfo pemInfo = new PemInfo(pemType, null, openSsl);
        String openSslPem = PemUtil.encode(pemInfo);
        return openSslPem;
    }

    public static String getEncrypted(PrivateKey privateKey, OpenSslPbeType pbeType, Password password) throws CryptoException {
        byte[] openSsl = OpenSslPvkUtil.get(privateKey);
        String pemType = null;
        pemType = privateKey instanceof RSAPrivateCrtKey ? OPENSSL_RSA_PVK_PEM_TYPE : (privateKey instanceof java.security.interfaces.ECPrivateKey ? OPENSSL_EC_PVK_PEM_TYPE : OPENSSL_DSA_PVK_PEM_TYPE);
        byte[] salt = OpenSslPvkUtil.generateSalt(pbeType.saltSize() / 8);
        String saltHex = OpenSslPvkUtil.bytesToHex(salt);
        byte[] encOpenSsl = null;
        try {
            byte[] encryptKey = OpenSslPvkUtil.deriveKeyFromPassword(password, salt, pbeType.keySize());
            Cipher cipher = OpenSslPvkUtil.createCipher(pbeType.jceCipher(), encryptKey, salt, 1);
            encOpenSsl = cipher.doFinal(openSsl);
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(MessageFormat.format(res.getString("OpenSslEncryptionFailed.exception.message"), pbeType.friendly()), ex);
        }
        PemAttributes attributes = new PemAttributes();
        attributes.add(new PemAttribute(PROC_TYPE_ATTR_NAME, PROC_TYPE_ATTR_VALUE));
        String dekInfoAttrValue = MessageFormat.format(DEK_INFO_ATTR_VALUE_TEMPLATE, pbeType.dekInfo(), saltHex);
        attributes.add(new PemAttribute(DEK_INFO_ATTR_NAME, dekInfoAttrValue));
        PemInfo pemInfo = new PemInfo(pemType, attributes, encOpenSsl);
        return PemUtil.encode(pemInfo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PrivateKey load(byte[] pvkData) throws CryptoException, IOException {
        EncryptionType encType = OpenSslPvkUtil.getEncryptionType(pvkData);
        if (encType == null) {
            throw new CryptoException(res.getString("NotValidOpenSsl.exception.message"));
        }
        if (encType == EncryptionType.ENCRYPTED) {
            throw new PrivateKeyEncryptedException(res.getString("OpenSslIsEncrypted.exception.message"));
        }
        PemInfo pemInfo = PemUtil.decode(pvkData);
        if (pemInfo != null) {
            pvkData = pemInfo.getContent();
        }
        try (ASN1InputStream asn1InputStream = new ASN1InputStream(pvkData);){
            ASN1Primitive openSsl = asn1InputStream.readObject();
            asn1InputStream.close();
            if (!(openSsl instanceof ASN1Sequence)) throw new CryptoException(res.getString("OpenSslSequenceNotFound.exception.message"));
            ASN1Sequence seq = (ASN1Sequence)openSsl;
            if (seq.size() == 9) {
                BigInteger version = ((ASN1Integer)seq.getObjectAt(0)).getValue();
                BigInteger modulus = ((ASN1Integer)seq.getObjectAt(1)).getValue();
                BigInteger publicExponent = ((ASN1Integer)seq.getObjectAt(2)).getValue();
                BigInteger privateExponent = ((ASN1Integer)seq.getObjectAt(3)).getValue();
                BigInteger primeP = ((ASN1Integer)seq.getObjectAt(4)).getValue();
                BigInteger primeQ = ((ASN1Integer)seq.getObjectAt(5)).getValue();
                BigInteger primeExponentP = ((ASN1Integer)seq.getObjectAt(6)).getValue();
                BigInteger primeExponenetQ = ((ASN1Integer)seq.getObjectAt(7)).getValue();
                BigInteger crtCoefficient = ((ASN1Integer)seq.getObjectAt(8)).getValue();
                if (!version.equals(VERSION)) {
                    throw new CryptoException(MessageFormat.format(res.getString("OpenSslVersionIncorrect.exception.message"), "" + VERSION.intValue(), "" + version.intValue()));
                }
                RSAPrivateCrtKeySpec rsaPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponenetQ, crtCoefficient);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                PrivateKey privateKey = keyFactory.generatePrivate(rsaPrivateCrtKeySpec);
                return privateKey;
            }
            if (seq.size() == 6) {
                BigInteger version = ((ASN1Integer)seq.getObjectAt(0)).getValue();
                BigInteger primeModulusP = ((ASN1Integer)seq.getObjectAt(1)).getValue();
                BigInteger primeQ = ((ASN1Integer)seq.getObjectAt(2)).getValue();
                BigInteger generatorG = ((ASN1Integer)seq.getObjectAt(3)).getValue();
                BigInteger secretExponentX = ((ASN1Integer)seq.getObjectAt(5)).getValue();
                if (!version.equals(VERSION)) {
                    throw new CryptoException(MessageFormat.format(res.getString("OpenSslVersionIncorrect.exception.message"), "" + VERSION.intValue(), "" + version.intValue()));
                }
                DSAPrivateKeySpec dsaPrivateKeySpec = new DSAPrivateKeySpec(secretExponentX, primeModulusP, primeQ, generatorG);
                KeyFactory keyFactory = KeyFactory.getInstance("DSA");
                PrivateKey privateKey = keyFactory.generatePrivate(dsaPrivateKeySpec);
                return privateKey;
            }
            if (seq.size() >= 2) {
                ECPrivateKey pKey = ECPrivateKey.getInstance((Object)seq);
                AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)pKey.getParameters());
                PrivateKeyInfo privInfo = new PrivateKeyInfo(algId, (ASN1Encodable)pKey);
                PrivateKey privateKey = new JcaPEMKeyConverter().getPrivateKey(privInfo);
                return privateKey;
            }
            throw new CryptoException(MessageFormat.format(res.getString("OpenSslSequenceIncorrectSize.exception.message"), "" + seq.size()));
        }
        catch (Exception ex) {
            throw new CryptoException(res.getString("NoLoadOpenSslPrivateKey.exception.message"), ex);
        }
    }

    public static PrivateKey loadEncrypted(byte[] pvkData, Password password) throws CryptoException, IOException {
        EncryptionType encType = OpenSslPvkUtil.getEncryptionType(pvkData);
        if (encType == null) {
            throw new CryptoException(res.getString("NotValidOpenSsl.exception.message"));
        }
        if (encType == EncryptionType.UNENCRYPTED) {
            throw new PrivateKeyUnencryptedException(res.getString("OpenSslIsUnencrypted.exception.message"));
        }
        PemInfo pemInfo = PemUtil.decode(pvkData);
        byte[] encKey = pemInfo.getContent();
        PemAttributes attributes = pemInfo.getAttributes();
        String dekInfo = attributes.get(DEK_INFO_ATTR_NAME).getValue();
        int separator = dekInfo.indexOf(44);
        if (separator == -1) {
            throw new CryptoException(MessageFormat.format(res.getString("OpenSslDekInfoMalformed.exception.message"), dekInfo));
        }
        String encAlg = dekInfo.substring(0, separator);
        String salt = dekInfo.substring(separator + 1);
        byte[] saltBytes = OpenSslPvkUtil.hexToBytes(salt);
        OpenSslPbeType pbeType = OpenSslPbeType.resolveDekInfo(encAlg);
        if (pbeType == null) {
            throw new PrivateKeyPbeNotSupportedException(encAlg, MessageFormat.format(res.getString("PrivateKeyWrappingAlgUnsupported.exception.message"), encAlg));
        }
        try {
            byte[] decryptKey = OpenSslPvkUtil.deriveKeyFromPassword(password, saltBytes, pbeType.keySize());
            Cipher cipher = OpenSslPvkUtil.createCipher(pbeType.jceCipher(), decryptKey, saltBytes, 2);
            byte[] key = cipher.doFinal(encKey);
            return OpenSslPvkUtil.load(key);
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(MessageFormat.format(res.getString("OpenSslDecryptionFailed.exception.message"), pbeType.friendly()), ex);
        }
    }

    public static EncryptionType getEncryptionType(byte[] openSsl) throws IOException {
        String pemType;
        PemInfo pemInfo = PemUtil.decode(openSsl);
        if (pemInfo != null && (OPENSSL_RSA_PVK_PEM_TYPE.equals(pemType = pemInfo.getType()) || OPENSSL_DSA_PVK_PEM_TYPE.equals(pemType) || OPENSSL_EC_PVK_PEM_TYPE.equals(pemType))) {
            PemAttributes pemAttributes = pemInfo.getAttributes();
            if (pemAttributes != null && pemAttributes.get(PROC_TYPE_ATTR_NAME) != null && pemAttributes.get(PROC_TYPE_ATTR_NAME).getValue().equals(PROC_TYPE_ATTR_VALUE) && pemAttributes.get(DEK_INFO_ATTR_NAME) != null) {
                return EncryptionType.ENCRYPTED;
            }
            return EncryptionType.UNENCRYPTED;
        }
        try {
            ASN1Primitive key = ASN1Primitive.fromByteArray((byte[])openSsl);
            if (key instanceof ASN1Sequence) {
                BigInteger version;
                ASN1Sequence seq = (ASN1Sequence)key;
                if (seq.size() >= 2 && seq.size() <= 4 && seq.getObjectAt(0) instanceof ASN1Integer && (version = ((ASN1Integer)seq.getObjectAt(0)).getValue()).equals(VERSION_EC)) {
                    if (seq.getObjectAt(1) instanceof ASN1OctetString) {
                        return EncryptionType.UNENCRYPTED;
                    }
                    return null;
                }
                for (int i = 0; i < seq.size(); ++i) {
                    if (seq.getObjectAt(i) instanceof ASN1Integer) continue;
                    return null;
                }
                if (seq.size() == 9 || seq.size() == 6) {
                    return EncryptionType.UNENCRYPTED;
                }
            }
        }
        catch (IOException ex) {
            return null;
        }
        return null;
    }

    private static byte[] generateSalt(int size) {
        Random random = new Random();
        random.setSeed(Calendar.getInstance().getTimeInMillis());
        byte[] salt = new byte[size];
        random.nextBytes(salt);
        return salt;
    }

    private static byte[] deriveKeyFromPassword(Password password, byte[] salt, int keySize) throws CryptoException {
        byte[] key = new byte[keySize / 8];
        byte[] passwordBytes = password.toByteArray();
        MessageDigest messageDigest = DigestUtil.getMessageDigester(DigestType.MD5);
        int currentPos = 0;
        while (currentPos < key.length) {
            messageDigest.update(passwordBytes);
            messageDigest.update(salt, 0, 8);
            byte[] result = messageDigest.digest();
            int stillNeed = key.length - currentPos;
            if (result.length > stillNeed) {
                byte[] b = new byte[stillNeed];
                System.arraycopy(result, 0, b, 0, b.length);
                result = b;
            }
            System.arraycopy(result, 0, key, currentPos, result.length);
            if ((currentPos += result.length) >= key.length) continue;
            messageDigest.reset();
            messageDigest.update(result);
        }
        return key;
    }

    private static byte[] hexToBytes(String hex) {
        byte[] b = new byte[hex.length() / 2];
        for (int i = 0; i < b.length; ++i) {
            String hexByte = hex.substring(2 * i, 2 * (i + 1));
            b[i] = (byte)Integer.parseInt(hexByte, 16);
        }
        return b;
    }

    private static String bytesToHex(byte[] bytes) {
        int expectedHexLength = bytes.length * 2;
        String hex = new BigInteger(1, bytes).toString(16).toUpperCase();
        int leadingZeros = expectedHexLength - hex.length();
        for (int i = 0; i < leadingZeros; ++i) {
            hex = "0" + hex;
        }
        return hex;
    }

    private static Cipher createCipher(String transformation, byte[] key, byte[] iv, int operation) throws CryptoException {
        SecretKeySpec secretKey = new SecretKeySpec(key, transformation);
        IvParameterSpec ivParams = new IvParameterSpec(iv);
        try {
            Cipher cipher = Cipher.getInstance(transformation, "BC");
            cipher.init(operation, (Key)secretKey, ivParams);
            return cipher;
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(MessageFormat.format(res.getString("OpenSslCreateCipherFailed.exception.message"), transformation), ex);
        }
    }
}

