/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.privatekey;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Calendar;
import java.util.Random;
import java.util.ResourceBundle;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.kse.crypto.CryptoException;
import org.kse.crypto.Password;
import org.kse.crypto.keypair.KeyPairType;
import org.kse.crypto.privatekey.EncryptionType;
import org.kse.crypto.privatekey.Pkcs8PbeType;
import org.kse.crypto.privatekey.PrivateKeyEncryptedException;
import org.kse.crypto.privatekey.PrivateKeyUnencryptedException;
import org.kse.utilities.pem.PemInfo;
import org.kse.utilities.pem.PemUtil;

public class Pkcs8Util {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/crypto/privatekey/resources");
    private static final String PKCS8_UNENC_PVK_PEM_TYPE = "PRIVATE KEY";
    private static final String PKCS8_ENC_PVK_PEM_TYPE = "ENCRYPTED PRIVATE KEY";

    private Pkcs8Util() {
    }

    public static byte[] get(PrivateKey privateKey) {
        return privateKey.getEncoded();
    }

    public static String getPem(PrivateKey privateKey) {
        PemInfo pemInfo = new PemInfo(PKCS8_UNENC_PVK_PEM_TYPE, null, privateKey.getEncoded());
        return PemUtil.encode(pemInfo);
    }

    public static byte[] getEncrypted(PrivateKey privateKey, Pkcs8PbeType pbeType, Password password) throws CryptoException, IOException {
        try {
            byte[] pkcs8 = Pkcs8Util.get(privateKey);
            SecretKeyFactory keyFact = SecretKeyFactory.getInstance(pbeType.jce());
            PBEKeySpec pbeKeySpec = new PBEKeySpec(password.toCharArray());
            SecretKey pbeKey = keyFact.generateSecret(pbeKeySpec);
            byte[] salt = Pkcs8Util.generateSalt();
            int iterationCount = Pkcs8Util.generateIterationCount();
            PBEParameterSpec pbeParameterSpec = new PBEParameterSpec(salt, iterationCount);
            AlgorithmParameters params = AlgorithmParameters.getInstance(pbeType.jce());
            params.init(pbeParameterSpec);
            Cipher cipher = Cipher.getInstance(pbeType.jce());
            cipher.init(1, (Key)pbeKey, params);
            byte[] encPkcs8 = cipher.doFinal(pkcs8);
            javax.crypto.EncryptedPrivateKeyInfo encPrivateKeyInfo = new javax.crypto.EncryptedPrivateKeyInfo(params, encPkcs8);
            return encPrivateKeyInfo.getEncoded();
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException("NoEncryptPkcs8PrivateKey.exception.message", ex);
        }
    }

    public static String getEncryptedPem(PrivateKey privateKey, Pkcs8PbeType pbeType, Password password) throws CryptoException, IOException {
        PemInfo pemInfo = new PemInfo(PKCS8_ENC_PVK_PEM_TYPE, null, Pkcs8Util.getEncrypted(privateKey, pbeType, password));
        return PemUtil.encode(pemInfo);
    }

    public static PrivateKey load(byte[] pvkData) throws CryptoException, IOException {
        EncryptionType encType = Pkcs8Util.getEncryptionType(pvkData);
        if (encType == null) {
            throw new CryptoException(res.getString("NotValidPkcs8.exception.message"));
        }
        if (encType == EncryptionType.ENCRYPTED) {
            throw new PrivateKeyEncryptedException(res.getString("Pkcs8IsEncrypted.exception.message"));
        }
        byte[] pvkBytes = null;
        PemInfo pemInfo = PemUtil.decode(pvkData);
        if (pemInfo != null) {
            pvkBytes = pemInfo.getContent();
        }
        if (pvkBytes == null) {
            pvkBytes = pvkData;
        }
        try {
            String privateKeyAlgorithm = Pkcs8Util.getPrivateKeyAlgorithm(pvkBytes);
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(pvkBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(privateKeyAlgorithm);
            PrivateKey pvk = keyFactory.generatePrivate(privateKeySpec);
            return pvk;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CryptoException(res.getString("NoLoadPkcs8PrivateKey.exception.message"), ex);
        }
        catch (InvalidKeySpecException ex) {
            throw new CryptoException(res.getString("NoLoadPkcs8PrivateKey.exception.message"), ex);
        }
    }

    public static PrivateKey loadEncrypted(byte[] pvkData, Password password) throws CryptoException, IOException {
        EncryptionType encType = Pkcs8Util.getEncryptionType(pvkData);
        if (encType == null) {
            throw new CryptoException(res.getString("NotValidPkcs8.exception.message"));
        }
        if (encType == EncryptionType.UNENCRYPTED) {
            throw new PrivateKeyUnencryptedException(res.getString("Pkcs8IsEncrypted.exception.message"));
        }
        PemInfo pemInfo = PemUtil.decode(pvkData);
        byte[] encPvk = null;
        if (pemInfo != null) {
            encPvk = pemInfo.getContent();
        }
        if (encPvk == null) {
            encPvk = pvkData;
        }
        PKCS8EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = null;
        try {
            encryptedPrivateKeyInfo = new PKCS8EncryptedPrivateKeyInfo(EncryptedPrivateKeyInfo.getInstance((Object)encPvk));
        }
        catch (Exception e) {
            throw new CryptoException(res.getString("NotValidPkcs8.exception.message"));
        }
        try {
            InputDecryptorProvider decProv = new JceOpenSSLPKCS8DecryptorProviderBuilder().setProvider("BC").build(password.toCharArray());
            PrivateKeyInfo privateKeyInfo = encryptedPrivateKeyInfo.decryptPrivateKeyInfo(decProv);
            return new JcaPEMKeyConverter().getPrivateKey(privateKeyInfo);
        }
        catch (Exception ex) {
            throw new CryptoException(res.getString("NoLoadPkcs8PrivateKey.exception.message"), ex);
        }
    }

    public static EncryptionType getEncryptionType(byte[] pkcs8) throws IOException {
        PemInfo pemInfo = PemUtil.decode(pkcs8);
        if (pemInfo != null) {
            String pemType = pemInfo.getType();
            if (pemType.equals(PKCS8_ENC_PVK_PEM_TYPE)) {
                return EncryptionType.ENCRYPTED;
            }
            if (pemType.equals(PKCS8_UNENC_PVK_PEM_TYPE)) {
                return EncryptionType.UNENCRYPTED;
            }
        }
        try {
            ASN1Primitive key = ASN1Primitive.fromByteArray((byte[])pkcs8);
            if (key instanceof ASN1Sequence) {
                ASN1Sequence sequence = (ASN1Sequence)key;
                if (sequence.size() == 3 || sequence.size() == 4) {
                    ASN1Encodable obj1 = sequence.getObjectAt(0);
                    ASN1Encodable obj2 = sequence.getObjectAt(1);
                    ASN1Encodable obj3 = sequence.getObjectAt(2);
                    if (!(obj1 instanceof ASN1Integer)) {
                        return null;
                    }
                    ASN1Integer version = (ASN1Integer)obj1;
                    if (!version.getValue().equals(BigInteger.ZERO)) {
                        return null;
                    }
                    if (!(obj2 instanceof ASN1Sequence)) {
                        return null;
                    }
                    if (!Pkcs8Util.sequenceIsAlgorithmIdentifier((ASN1Sequence)obj2)) {
                        return null;
                    }
                    if (!(obj3 instanceof ASN1OctetString)) {
                        return null;
                    }
                    return EncryptionType.UNENCRYPTED;
                }
                if (sequence.size() == 2) {
                    ASN1Encodable obj1 = sequence.getObjectAt(0);
                    ASN1Encodable obj2 = sequence.getObjectAt(1);
                    if (!(obj1 instanceof ASN1Sequence)) {
                        return null;
                    }
                    if (!Pkcs8Util.sequenceIsAlgorithmIdentifier((ASN1Sequence)obj1)) {
                        return null;
                    }
                    if (!(obj2 instanceof ASN1OctetString)) {
                        return null;
                    }
                    return EncryptionType.ENCRYPTED;
                }
            }
        }
        catch (Exception ex) {
            return null;
        }
        return null;
    }

    private static boolean sequenceIsAlgorithmIdentifier(ASN1Sequence sequence) {
        if (sequence.size() != 1 && sequence.size() != 2) {
            return false;
        }
        ASN1Encodable obj1 = sequence.getObjectAt(0);
        return obj1 instanceof ASN1ObjectIdentifier;
    }

    private static int generateIterationCount() {
        Random rng = new Random();
        rng.setSeed(Calendar.getInstance().getTimeInMillis());
        int random = rng.nextInt();
        int mod1000 = random % 1000;
        return mod1000 + 1000;
    }

    private static byte[] generateSalt() {
        Random random = new Random();
        random.setSeed(Calendar.getInstance().getTimeInMillis());
        byte[] salt = new byte[8];
        random.nextBytes(salt);
        return salt;
    }

    private static String getPrivateKeyAlgorithm(byte[] unencPkcs8) throws IOException, CryptoException {
        try (ASN1InputStream ais = new ASN1InputStream((InputStream)new ByteArrayInputStream(unencPkcs8));){
            ASN1Primitive derEnc;
            try {
                derEnc = ais.readObject();
            }
            catch (OutOfMemoryError err) {
                throw new CryptoException(res.getString("NoUnencryptedPkcs8.exception.message"));
            }
            if (!(derEnc instanceof ASN1Sequence)) {
                throw new CryptoException(res.getString("NoUnencryptedPkcs8.exception.message"));
            }
            ASN1Sequence privateKeyInfoSequence = (ASN1Sequence)derEnc;
            if (!((derEnc = privateKeyInfoSequence.getObjectAt(1)) instanceof ASN1Sequence)) {
                throw new CryptoException(res.getString("NoUnencryptedPkcs8.exception.message"));
            }
            ASN1Sequence privateKeyAlgorithmSequence = (ASN1Sequence)derEnc;
            if (!((derEnc = privateKeyAlgorithmSequence.getObjectAt(0)) instanceof ASN1ObjectIdentifier)) {
                throw new CryptoException(res.getString("NoUnencryptedPkcs8.exception.message"));
            }
            ASN1ObjectIdentifier algorithmOid = (ASN1ObjectIdentifier)derEnc;
            String oid = algorithmOid.getId();
            if (oid.equals(KeyPairType.RSA.oid())) {
                String string = KeyPairType.RSA.jce();
                return string;
            }
            if (oid.equals(KeyPairType.DSA.oid())) {
                String string = KeyPairType.DSA.jce();
                return string;
            }
            String string = oid;
            return string;
        }
    }
}

