/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.secretkey;

import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.kse.crypto.CryptoException;
import org.kse.crypto.KeyInfo;
import org.kse.crypto.KeyType;
import org.kse.crypto.SecurityProvider;
import org.kse.crypto.secretkey.SecretKeyType;

public class SecretKeyUtil {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/crypto/secretkey/resources");

    private SecretKeyUtil() {
    }

    public static SecretKey generateSecretKey(SecretKeyType secretKeyType, int keySize) throws CryptoException {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(secretKeyType.jce(), SecurityProvider.BOUNCY_CASTLE.jce());
            keyGenerator.init(keySize, SecureRandom.getInstance("SHA1PRNG"));
            return keyGenerator.generateKey();
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(MessageFormat.format(res.getString("NoGenerateSecretKey.exception.message"), new Object[]{secretKeyType}), ex);
        }
    }

    public static KeyInfo getKeyInfo(SecretKey secretKey) {
        String algorithm = secretKey.getAlgorithm();
        if (algorithm.equals("RC4")) {
            algorithm = "ARC4";
        }
        if (secretKey.getFormat().equals("RAW")) {
            int keySize = secretKey.getEncoded().length * 8;
            return new KeyInfo(KeyType.SYMMETRIC, algorithm, keySize);
        }
        return new KeyInfo(KeyType.SYMMETRIC, algorithm);
    }
}

