/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import org.kse.gui.FileExtFilter;
import org.kse.gui.JavaFXFileChooser;
import org.kse.utilities.os.OperatingSystem;

public class FileChooserFactory {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/resources");
    public static final String KEYSTORE_EXT_1 = "ks";
    public static final String KEYSTORE_EXT_2 = "keystore";
    public static final String JKS_EXT = "jks";
    public static final String JCEKS_EXT = "jceks";
    public static final String BKS_EXT = "bks";
    public static final String UBER_EXT = "uber";
    public static final String BCFKS_EXT = "bcfks";
    public static final String PKCS12_KEYSTORE_EXT_1 = "pfx";
    public static final String PKCS12_KEYSTORE_EXT_2 = "p12";
    public static final String X509_EXT_1 = "cer";
    public static final String X509_EXT_2 = "crt";
    public static final String PKCS7_EXT_1 = "p7b";
    public static final String PKCS7_EXT_2 = "p7c";
    public static final String PKI_PATH_EXT = "pkipath";
    public static final String SPC_EXT = "spc";
    public static final String CET_EXT = "cet";
    public static final String PKCS8_EXT = "pkcs8";
    public static final String PVK_EXT = "pvk";
    public static final String OPENSSL_PVK_EXT = "key";
    public static final String PUBLIC_KEY_EXT = "pub";
    public static final String PKCS10_CSR_EXT_1 = "p10";
    public static final String PKCS10_CSR_EXT_2 = "csr";
    public static final String SPKAC_CSR_EXT = "spkac";
    public static final String CA_REPLY_EXT = "p7r";
    public static final String CRL_EXT = "crl";
    public static final String JAR_EXT = "jar";
    public static final String ZIP_EXT = "zip";
    public static final String JAD_EXT = "jad";
    public static final String LIB_DLL_EXT = "dll";
    public static final String LIB_SO_EXT = "so";
    public static final String LIB_DYLIB_EXT = "dylib";
    public static final String PEM_EXT = "pem";
    private static final String KEYSTORE_FILE_DESC = MessageFormat.format(res.getString("FileChooserFactory.KeyStoreFiles"), "ks", "keystore", "jks", "jceks", "bks", "uber", "bcfks");
    private static final String X509_FILE_DESC = MessageFormat.format(res.getString("FileChooserFactory.CertificateFiles"), "cer", "crt");
    private static final String PKCS7_FILE_DESC = MessageFormat.format(res.getString("FileChooserFactory.Pkcs7Files"), "p7b", "p7c");
    private static final String PKI_PATH_FILE_DESC = MessageFormat.format(res.getString("FileChooserFactory.PkiPathFiles"), "pkipath");
    private static final String SPC_FILE_DESC = MessageFormat.format(res.getString("FileChooserFactory.SpcFiles"), "spc");
    private static final String CET_FILE_DESC = MessageFormat.format(res.getString("FileChooserFactory.CetFiles"), "cet");
    private static final String PKCS12_FILE_DESC = MessageFormat.format(res.getString("FileChooserFactory.Pkcs12Files"), "pfx", "p12");
    private static final String PKCS8_FILE_DESC = MessageFormat.format(res.getString("FileChooserFactory.Pkcs8Files"), "pkcs8");
    private static final String PVK_FILE_DESC = MessageFormat.format(res.getString("FileChooserFactory.PvkFiles"), "pvk");
    private static final String OPENSSL_PVK_FILE_DESC = MessageFormat.format(res.getString("FileChooserFactory.OpenSslPvkFiles"), "key");
    private static final String PUBLIC_KEY_FILE_DESC = MessageFormat.format(res.getString("FileChooserFactory.OpenSslPvkFiles"), "pub");
    private static final String PKCS10_CSR_FILE_DESC = MessageFormat.format(res.getString("FileChooserFactory.Pkcs10CsrFiles"), "p10", "csr");
    private static final String SPKAC_CSR_FILE_DESC = MessageFormat.format(res.getString("FileChooserFactory.SpkacCsrFiles"), "spkac");
    private static final String CA_REPLY_FILE_DESC = MessageFormat.format(res.getString("FileChooserFactory.CaReplyFiles"), "p7r");
    private static final String CRL_FILE_DESC = MessageFormat.format(res.getString("FileChooserFactory.CrlFiles"), "crl");
    private static final String JAR_FILE_DESC = MessageFormat.format(res.getString("FileChooserFactory.JarFiles"), "jar");
    private static final String ZIP_FILE_DESC = MessageFormat.format(res.getString("FileChooserFactory.ZipFiles"), "zip");
    private static final String JAD_FILE_DESC = MessageFormat.format(res.getString("FileChooserFactory.JadFiles"), "jad");
    private static final String LIB_DLL_FILE_DESC = MessageFormat.format(res.getString("FileChooserFactory.LibDllFiles"), "dll");
    private static final String LIB_SO_FILE_DESC = MessageFormat.format(res.getString("FileChooserFactory.LibSoFiles"), "so");
    private static final String LIB_DYLIB_FILE_DESC = MessageFormat.format(res.getString("FileChooserFactory.LibDylibFiles"), "dylib");

    private FileChooserFactory() {
    }

    public static JFileChooser getKeyStoreFileChooser() {
        JFileChooser chooser = FileChooserFactory.getFileChooser();
        chooser.addChoosableFileFilter(new FileExtFilter(new String[]{PKCS12_KEYSTORE_EXT_1, PKCS12_KEYSTORE_EXT_2}, PKCS12_FILE_DESC));
        chooser.addChoosableFileFilter(new FileExtFilter(new String[]{KEYSTORE_EXT_1, KEYSTORE_EXT_2, JKS_EXT, JCEKS_EXT, BKS_EXT, UBER_EXT, BCFKS_EXT}, KEYSTORE_FILE_DESC));
        return chooser;
    }

    public static JFileChooser getX509FileChooser() {
        JFileChooser chooser = FileChooserFactory.getFileChooser();
        chooser.addChoosableFileFilter(new FileExtFilter(new String[]{X509_EXT_1, X509_EXT_2}, X509_FILE_DESC));
        return chooser;
    }

    public static JFileChooser getPkcs7FileChooser() {
        JFileChooser chooser = FileChooserFactory.getFileChooser();
        chooser.addChoosableFileFilter(new FileExtFilter(new String[]{PKCS7_EXT_1, PKCS7_EXT_2}, PKCS7_FILE_DESC));
        return chooser;
    }

    public static JFileChooser getPkiPathFileChooser() {
        JFileChooser chooser = FileChooserFactory.getFileChooser();
        chooser.addChoosableFileFilter(new FileExtFilter(new String[]{PKI_PATH_EXT}, PKI_PATH_FILE_DESC));
        return chooser;
    }

    public static JFileChooser getSpcFileChooser() {
        JFileChooser chooser = FileChooserFactory.getFileChooser();
        chooser.addChoosableFileFilter(new FileExtFilter(new String[]{SPC_EXT}, SPC_FILE_DESC));
        return chooser;
    }

    public static JFileChooser getCetFileChooser() {
        JFileChooser chooser = FileChooserFactory.getFileChooser();
        chooser.addChoosableFileFilter(new FileExtFilter(new String[]{CET_EXT}, CET_FILE_DESC));
        return chooser;
    }

    public static JFileChooser getCertFileChooser() {
        JFileChooser chooser = FileChooserFactory.getFileChooser();
        chooser.addChoosableFileFilter(new FileExtFilter(new String[]{SPC_EXT}, SPC_FILE_DESC));
        chooser.addChoosableFileFilter(new FileExtFilter(new String[]{PKI_PATH_EXT}, PKI_PATH_FILE_DESC));
        chooser.addChoosableFileFilter(new FileExtFilter(new String[]{PKCS7_EXT_1, PKCS7_EXT_2}, PKCS7_FILE_DESC));
        chooser.addChoosableFileFilter(new FileExtFilter(new String[]{X509_EXT_1, X509_EXT_2}, X509_FILE_DESC));
        return chooser;
    }

    public static JFileChooser getPkcs12FileChooser() {
        JFileChooser chooser = FileChooserFactory.getFileChooser();
        chooser.addChoosableFileFilter(new FileExtFilter(new String[]{PKCS12_KEYSTORE_EXT_1, PKCS12_KEYSTORE_EXT_2}, PKCS12_FILE_DESC));
        return chooser;
    }

    public static JFileChooser getPkcs8FileChooser() {
        JFileChooser chooser = FileChooserFactory.getFileChooser();
        chooser.addChoosableFileFilter(new FileExtFilter(new String[]{PKCS8_EXT}, PKCS8_FILE_DESC));
        return chooser;
    }

    public static JFileChooser getPvkFileChooser() {
        JFileChooser chooser = FileChooserFactory.getFileChooser();
        chooser.addChoosableFileFilter(new FileExtFilter(new String[]{PVK_EXT}, PVK_FILE_DESC));
        return chooser;
    }

    public static JFileChooser getOpenSslPvkFileChooser() {
        JFileChooser chooser = FileChooserFactory.getFileChooser();
        chooser.addChoosableFileFilter(new FileExtFilter(new String[]{OPENSSL_PVK_EXT}, OPENSSL_PVK_FILE_DESC));
        return chooser;
    }

    public static JFileChooser getPublicKeyFileChooser() {
        JFileChooser chooser = FileChooserFactory.getFileChooser();
        chooser.addChoosableFileFilter(new FileExtFilter(new String[]{PUBLIC_KEY_EXT}, PUBLIC_KEY_FILE_DESC));
        return chooser;
    }

    public static JFileChooser getCsrFileChooser() {
        JFileChooser chooser = FileChooserFactory.getFileChooser();
        chooser.addChoosableFileFilter(new FileExtFilter(SPKAC_CSR_EXT, SPKAC_CSR_FILE_DESC));
        chooser.addChoosableFileFilter(new FileExtFilter(new String[]{PKCS10_CSR_EXT_1, PKCS10_CSR_EXT_2}, PKCS10_CSR_FILE_DESC));
        return chooser;
    }

    public static JFileChooser getPkcs10FileChooser() {
        JFileChooser chooser = FileChooserFactory.getFileChooser();
        chooser.addChoosableFileFilter(new FileExtFilter(new String[]{PKCS10_CSR_EXT_1, PKCS10_CSR_EXT_2}, PKCS10_CSR_FILE_DESC));
        return chooser;
    }

    public static JFileChooser getSpkacFileChooser() {
        JFileChooser chooser = FileChooserFactory.getFileChooser();
        chooser.addChoosableFileFilter(new FileExtFilter(SPKAC_CSR_EXT, SPKAC_CSR_FILE_DESC));
        return chooser;
    }

    public static JFileChooser getCaReplyFileChooser() {
        JFileChooser chooser = FileChooserFactory.getFileChooser();
        chooser.addChoosableFileFilter(new FileExtFilter(CA_REPLY_EXT, CA_REPLY_FILE_DESC));
        return chooser;
    }

    public static JFileChooser getCrlFileChooser() {
        JFileChooser chooser = FileChooserFactory.getFileChooser();
        chooser.addChoosableFileFilter(new FileExtFilter(CRL_EXT, CRL_FILE_DESC));
        return chooser;
    }

    public static JFileChooser getArchiveFileChooser() {
        JFileChooser chooser = FileChooserFactory.getFileChooser();
        chooser.addChoosableFileFilter(new FileExtFilter(new String[]{ZIP_EXT}, ZIP_FILE_DESC));
        chooser.addChoosableFileFilter(new FileExtFilter(new String[]{JAR_EXT}, JAR_FILE_DESC));
        return chooser;
    }

    public static JFileChooser getZipFileChooser() {
        JFileChooser chooser = FileChooserFactory.getFileChooser();
        chooser.addChoosableFileFilter(new FileExtFilter(new String[]{ZIP_EXT}, ZIP_FILE_DESC));
        return chooser;
    }

    public static JFileChooser getJadFileChooser() {
        JFileChooser chooser = FileChooserFactory.getFileChooser();
        chooser.addChoosableFileFilter(new FileExtFilter(new String[]{JAD_EXT}, JAD_FILE_DESC));
        return chooser;
    }

    public static JFileChooser getLibFileChooser() {
        JFileChooser chooser = FileChooserFactory.getFileChooser();
        if (OperatingSystem.isWindows()) {
            chooser.addChoosableFileFilter(new FileExtFilter(new String[]{LIB_DLL_EXT}, LIB_DLL_FILE_DESC));
        } else if (OperatingSystem.isMacOs()) {
            chooser.addChoosableFileFilter(new FileExtFilter(new String[]{LIB_DYLIB_EXT}, LIB_DYLIB_FILE_DESC));
        } else if (OperatingSystem.isLinux() || OperatingSystem.isUnix()) {
            chooser.addChoosableFileFilter(new FileExtFilter(new String[]{LIB_SO_EXT}, LIB_SO_FILE_DESC));
        }
        return chooser;
    }

    private static JFileChooser getFileChooser() {
        return JavaFXFileChooser.isFxAvailable() ? new JavaFXFileChooser() : new JFileChooser();
    }
}

