/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JMenu;
import org.kse.gui.JMenuItemRecentFile;

public class JMenuRecentFiles
extends JMenu {
    private static final long serialVersionUID = 1L;
    private JMenuItemRecentFile[] jmiRecentFiles;
    private static final int MAX_LENGTH = 9;

    public JMenuRecentFiles(String title, int length) {
        super(title);
        if (length > 9) {
            length = 9;
        }
        this.jmiRecentFiles = new JMenuItemRecentFile[length];
    }

    private void removeAllRecentFiles() {
        for (int i = 0; i < this.jmiRecentFiles.length && this.jmiRecentFiles[i] != null; ++i) {
            this.remove(this.jmiRecentFiles[i]);
        }
    }

    private void addAllRecentFiles() {
        for (int i = 0; i < this.jmiRecentFiles.length && this.jmiRecentFiles[i] != null; ++i) {
            this.add((Component)this.jmiRecentFiles[i], i);
        }
    }

    private int findRecentFile(File recentFile) {
        int index = -1;
        for (int i = 0; i < this.jmiRecentFiles.length && this.jmiRecentFiles[i] != null; ++i) {
            if (!recentFile.equals(this.jmiRecentFiles[i].getFile())) continue;
            index = i;
            break;
        }
        return index;
    }

    public void add(JMenuItemRecentFile jmirfNew) {
        int index = this.findRecentFile(jmirfNew.getFile());
        if (index == 0) {
            return;
        }
        this.removeAllRecentFiles();
        jmirfNew.setPosition(1);
        if (index != -1) {
            for (int i = 0; i <= index; ++i) {
                JMenuItemRecentFile jmirfTmp = this.jmiRecentFiles[i];
                this.jmiRecentFiles[i] = jmirfNew;
                jmirfNew = jmirfTmp;
                jmirfNew.setPosition(i + 2);
            }
        } else {
            for (int i = 0; i < this.jmiRecentFiles.length; ++i) {
                JMenuItemRecentFile jmirfTmp = this.jmiRecentFiles[i];
                this.jmiRecentFiles[i] = jmirfNew;
                jmirfNew = jmirfTmp;
                if (jmirfNew != null) {
                    jmirfNew.setPosition(i + 2);
                    continue;
                }
                break;
            }
        }
        this.addAllRecentFiles();
    }

    public void invalidate(JMenuItemRecentFile jmirfOld) {
        int index = this.findRecentFile(jmirfOld.getFile());
        if (index == -1) {
            return;
        }
        this.removeAllRecentFiles();
        for (int i = index; i < this.jmiRecentFiles.length; ++i) {
            if (i < this.jmiRecentFiles.length - 1) {
                this.jmiRecentFiles[i] = this.jmiRecentFiles[i + 1];
                if (this.jmiRecentFiles[i + 1] == null) continue;
                this.jmiRecentFiles[i].setPosition(i + 1);
                continue;
            }
            this.jmiRecentFiles[i] = null;
        }
        this.addAllRecentFiles();
    }

    public File[] getRecentFiles() {
        ArrayList<File> recentFiles = new ArrayList<File>();
        for (int i = 0; i < this.jmiRecentFiles.length && this.jmiRecentFiles[i] != null; ++i) {
            recentFiles.add(this.jmiRecentFiles[i].getFile());
        }
        return recentFiles.toArray(new File[recentFiles.size()]);
    }
}

