/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.crypto.SecretKey;
import javax.swing.table.AbstractTableModel;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.kse.crypto.CryptoException;
import org.kse.crypto.KeyInfo;
import org.kse.crypto.KeyType;
import org.kse.crypto.keypair.KeyPairUtil;
import org.kse.crypto.keystore.KeyStoreType;
import org.kse.crypto.keystore.KeyStoreUtil;
import org.kse.crypto.secretkey.SecretKeyType;
import org.kse.crypto.secretkey.SecretKeyUtil;
import org.kse.crypto.x509.KseX500NameStyle;
import org.kse.crypto.x509.X500NameUtils;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.KeyStoreTableColumns;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;
import org.kse.utilities.io.HexUtil;

public class KeyStoreTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/resources");
    private String[] columnNames;
    private Class<?>[] columnTypes;
    private Object[][] data;
    private KeyStoreHistory history;
    public static final String KEY_PAIR_ENTRY = res.getString("KeyStoreTableModel.KeyPairEntry");
    public static final String TRUST_CERT_ENTRY = res.getString("KeyStoreTableModel.TrustCertEntry");
    public static final String KEY_ENTRY = res.getString("KeyStoreTableModel.KeyEntry");
    private static final int ICON_SIZE = 28;
    private KeyStoreTableColumns keyStoreTableColumns = new KeyStoreTableColumns();
    private int nofColumns = 5;
    private int[] iColWidth;
    private int expiryWarnDays = 0;
    private int iNameColumn = -1;
    private int iAlgorithmColumn = -1;
    private int iKeySizeColumn = -1;
    private int iCurveColumn = -1;
    private int iCertExpiryColumn = -1;
    private int iLastModifiedColumn = -1;
    private int iAKIColumn = -1;
    private int iSKIColumn = -1;
    private int iIssuerDNColumn = -1;
    private int iSubjectDNColumn = -1;
    private int iIssuerCNColumn = -1;
    private int iSubjectCNColumn = -1;
    private int iIssuerOColumn = -1;
    private int iSubjectOColumn = -1;

    public KeyStoreTableModel(KeyStoreTableColumns keyStoreTableColumnsParm) {
        this.keyStoreTableColumns = keyStoreTableColumnsParm;
        this.adjustColumns(keyStoreTableColumnsParm);
        this.data = new Object[0][0];
    }

    public void load(KeyStoreHistory history) throws GeneralSecurityException, CryptoException {
        this.history = history;
        KeyStoreState currentState = history.getCurrentState();
        KeyStore keyStore = currentState.getKeyStore();
        KeyStoreType type = KeyStoreType.resolveJce(keyStore.getType());
        Enumeration<String> aliases = keyStore.aliases();
        TreeMap<String, String> sortedAliases = new TreeMap<String, String>(new AliasComparator());
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!KeyStoreUtil.isSupportedEntryType(alias, keyStore)) continue;
            sortedAliases.put(alias, alias);
        }
        this.data = new Object[sortedAliases.size()][this.nofColumns];
        int i = 0;
        Iterator itr = sortedAliases.entrySet().iterator();
        while (itr.hasNext()) {
            KeyInfo keyInfo;
            String alias = itr.next().getKey();
            String entryType = null;
            entryType = KeyStoreUtil.isTrustedCertificateEntry(alias, keyStore) ? TRUST_CERT_ENTRY : (KeyStoreUtil.isKeyPairEntry(alias, keyStore) ? KEY_PAIR_ENTRY : KEY_ENTRY);
            this.data[i][0] = entryType;
            this.data[i][1] = (entryType.equals(KEY_PAIR_ENTRY) || entryType.equals(KEY_ENTRY)) && type.hasEntryPasswords() ? (currentState.getEntryPassword(alias) != null ? Boolean.FALSE : Boolean.TRUE) : null;
            Date expiry = this.getCertificateExpiry(alias, keyStore);
            Calendar c = Calendar.getInstance();
            Calendar a = Calendar.getInstance();
            c.setTime(new Date());
            a.setTime(new Date());
            a.add(5, this.expiryWarnDays);
            this.data[i][2] = expiry == null ? null : (expiry.before(c.getTime()) ? Integer.valueOf(2) : (expiry.before(a.getTime()) ? Integer.valueOf(1) : Integer.valueOf(0)));
            if (this.iNameColumn > 0) {
                this.data[i][this.iNameColumn] = alias;
                if (alias.length() > this.iColWidth[this.iNameColumn]) {
                    this.iColWidth[this.iNameColumn] = alias.length();
                }
            }
            if ((keyInfo = this.getKeyInfo(alias, keyStore, currentState)) != null) {
                if (this.iAlgorithmColumn > 0) {
                    this.data[i][this.iAlgorithmColumn] = this.getAlgorithmName(keyInfo);
                    if (this.iColWidth[this.iAlgorithmColumn] < this.data[i][this.iAlgorithmColumn].toString().length()) {
                        this.iColWidth[this.iAlgorithmColumn] = this.data[i][this.iAlgorithmColumn].toString().length();
                    }
                }
                if (this.iKeySizeColumn > 0) {
                    this.data[i][this.iKeySizeColumn] = keyInfo.getSize();
                }
                if (this.keyStoreTableColumns.getEnableCurve()) {
                    this.data[i][this.iCurveColumn] = keyInfo.getDetailedAlgorithm();
                    if (this.iColWidth[this.iCurveColumn] < this.data[i][this.iCurveColumn].toString().length()) {
                        this.iColWidth[this.iCurveColumn] = this.data[i][this.iCurveColumn].toString().length();
                    }
                }
            }
            if (this.iCertExpiryColumn > 0) {
                this.data[i][this.iCertExpiryColumn] = expiry != null ? expiry : null;
            }
            if (this.iLastModifiedColumn > 0) {
                this.data[i][this.iLastModifiedColumn] = !keyStore.getType().equals(KeyStoreType.PKCS12.jce()) && !keyStore.getType().equals(KeyStoreType.PKCS11.jce()) ? keyStore.getCreationDate(alias) : null;
            }
            if (this.iSubjectDNColumn > 0) {
                if (!entryType.equals(KEY_ENTRY)) {
                    this.data[i][this.iSubjectDNColumn] = this.getCertificateSubjectDN(alias, keyStore);
                    if (this.iColWidth[this.iSubjectDNColumn] < this.data[i][this.iSubjectDNColumn].toString().length()) {
                        this.iColWidth[this.iSubjectDNColumn] = this.data[i][this.iSubjectDNColumn].toString().length();
                    }
                } else {
                    this.data[i][this.iSubjectDNColumn] = null;
                }
            }
            if (this.iIssuerDNColumn > 0) {
                if (!entryType.equals(KEY_ENTRY)) {
                    this.data[i][this.iIssuerDNColumn] = this.getCertificateIssuerDN(alias, keyStore);
                    if (this.iColWidth[this.iIssuerDNColumn] < this.data[i][this.iIssuerDNColumn].toString().length()) {
                        this.iColWidth[this.iIssuerDNColumn] = this.data[i][this.iIssuerDNColumn].toString().length();
                    }
                } else {
                    this.data[i][this.iIssuerDNColumn] = null;
                }
            }
            if (this.iSubjectCNColumn > 0) {
                if (!entryType.equals(KEY_ENTRY)) {
                    this.data[i][this.iSubjectCNColumn] = this.getCertificateSubjectCN(alias, keyStore);
                    if (this.iColWidth[this.iSubjectCNColumn] < this.data[i][this.iSubjectCNColumn].toString().length()) {
                        this.iColWidth[this.iSubjectCNColumn] = this.data[i][this.iSubjectCNColumn].toString().length();
                    }
                } else {
                    this.data[i][this.iSubjectCNColumn] = null;
                }
            }
            if (this.iIssuerCNColumn > 0) {
                if (!entryType.equals(KEY_ENTRY)) {
                    this.data[i][this.iIssuerCNColumn] = this.getCertificateIssuerCN(alias, keyStore);
                    if (this.iColWidth[this.iIssuerCNColumn] < this.data[i][this.iIssuerCNColumn].toString().length()) {
                        this.iColWidth[this.iIssuerCNColumn] = this.data[i][this.iIssuerCNColumn].toString().length();
                    }
                } else {
                    this.data[i][this.iIssuerCNColumn] = null;
                }
            }
            if (this.iSubjectOColumn > 0) {
                if (!entryType.equals(KEY_ENTRY)) {
                    this.data[i][this.iSubjectOColumn] = this.getCertificateSubjectO(alias, keyStore);
                    if (this.iColWidth[this.iSubjectOColumn] < this.data[i][this.iSubjectOColumn].toString().length()) {
                        this.iColWidth[this.iSubjectOColumn] = this.data[i][this.iSubjectOColumn].toString().length();
                    }
                } else {
                    this.data[i][this.iSubjectOColumn] = null;
                }
            }
            if (this.iIssuerOColumn > 0) {
                if (!entryType.equals(KEY_ENTRY)) {
                    this.data[i][this.iIssuerOColumn] = this.getCertificateIssuerO(alias, keyStore);
                    if (this.iColWidth[this.iIssuerOColumn] < this.data[i][this.iIssuerOColumn].toString().length()) {
                        this.iColWidth[this.iIssuerOColumn] = this.data[i][this.iIssuerOColumn].toString().length();
                    }
                } else {
                    this.data[i][this.iIssuerOColumn] = null;
                }
            }
            if (this.iAKIColumn > 0) {
                if (!entryType.equals(KEY_ENTRY)) {
                    this.data[i][this.iAKIColumn] = this.getCertificateAKI(alias, keyStore);
                    if (this.iColWidth[this.iAKIColumn] < this.data[i][this.iAKIColumn].toString().length()) {
                        this.iColWidth[this.iAKIColumn] = this.data[i][this.iAKIColumn].toString().length();
                    }
                } else {
                    this.data[i][this.iAKIColumn] = null;
                }
            }
            if (this.iSKIColumn > 0) {
                if (!entryType.equals(KEY_ENTRY)) {
                    this.data[i][this.iSKIColumn] = this.getCertificateSKI(alias, keyStore);
                    if (this.iColWidth[this.iSKIColumn] < this.data[i][this.iSKIColumn].toString().length()) {
                        this.iColWidth[this.iSKIColumn] = this.data[i][this.iSKIColumn].toString().length();
                    }
                } else {
                    this.data[i][this.iSKIColumn] = null;
                }
            }
            ++i;
        }
        this.fireTableDataChanged();
    }

    private Date getCertificateExpiry(String alias, KeyStore keyStore) throws CryptoException, KeyStoreException {
        if (KeyStoreUtil.isTrustedCertificateEntry(alias, keyStore)) {
            return X509CertUtil.convertCertificate(keyStore.getCertificate(alias)).getNotAfter();
        }
        Certificate[] chain = keyStore.getCertificateChain(alias);
        if (chain == null) {
            return null;
        }
        X509Certificate[] x509Chain = X509CertUtil.orderX509CertChain(X509CertUtil.convertCertificates(chain));
        if (this.expiryWarnDays < 1) {
            return x509Chain[0].getNotAfter();
        }
        Calendar cal = Calendar.getInstance();
        cal.set(9999, 1, 1);
        Date earliest = cal.getTime();
        for (int i = 0; i < x509Chain.length; ++i) {
            if (!x509Chain[i].getNotAfter().before(earliest)) continue;
            earliest = x509Chain[i].getNotAfter();
        }
        return earliest;
    }

    private KeyInfo getKeyInfo(String alias, KeyStore keyStore, KeyStoreState currentState) throws CryptoException, GeneralSecurityException {
        if (KeyStoreUtil.isTrustedCertificateEntry(alias, keyStore)) {
            X509Certificate cert = X509CertUtil.convertCertificate(keyStore.getCertificate(alias));
            return KeyPairUtil.getKeyInfo(cert.getPublicKey());
        }
        Certificate[] chain = keyStore.getCertificateChain(alias);
        if (chain != null) {
            X509Certificate[] x509Chain = X509CertUtil.orderX509CertChain(X509CertUtil.convertCertificates(chain));
            return KeyPairUtil.getKeyInfo(x509Chain[0].getPublicKey());
        }
        if (currentState.getEntryPassword(alias) != null) {
            char[] keyPassword = null;
            keyPassword = currentState.getEntryPassword(alias).toCharArray();
            Key key = keyStore.getKey(alias, keyPassword);
            if (key instanceof SecretKey) {
                return SecretKeyUtil.getKeyInfo((SecretKey)key);
            }
            if (key instanceof PrivateKey) {
                return KeyPairUtil.getKeyInfo((PrivateKey)key);
            }
            if (key instanceof PublicKey) {
                return KeyPairUtil.getKeyInfo((PublicKey)key);
            }
        }
        return null;
    }

    private String getAlgorithmName(KeyInfo keyInfo) {
        SecretKeyType secretKeyType;
        String algorithm = keyInfo.getAlgorithm();
        if (keyInfo.getKeyType() == KeyType.SYMMETRIC && (secretKeyType = SecretKeyType.resolveJce(algorithm)) != null) {
            algorithm = secretKeyType.friendly();
        }
        return algorithm;
    }

    private String getCertificateSubjectDN(String alias, KeyStore keyStore) throws CryptoException, KeyStoreException {
        X509Certificate x509Cert = this.getCertificate(alias, keyStore);
        return X500NameUtils.x500PrincipalToX500Name(x509Cert.getSubjectX500Principal()).toString();
    }

    private String getCertificateIssuerDN(String alias, KeyStore keyStore) throws CryptoException, KeyStoreException {
        X509Certificate x509Cert = this.getCertificate(alias, keyStore);
        return X500NameUtils.x500PrincipalToX500Name(x509Cert.getIssuerX500Principal()).toString();
    }

    private String getCertificateSubjectCN(String alias, KeyStore keyStore) throws CryptoException, KeyStoreException {
        X509Certificate x509Cert = this.getCertificate(alias, keyStore);
        return X500NameUtils.extractCN(x509Cert.getSubjectX500Principal());
    }

    private String getCertificateIssuerCN(String alias, KeyStore keyStore) throws CryptoException, KeyStoreException {
        X509Certificate x509Cert = this.getCertificate(alias, keyStore);
        return X500NameUtils.extractCN(x509Cert.getIssuerX500Principal());
    }

    private String getCertificateSKI(String alias, KeyStore keyStore) throws CryptoException, KeyStoreException {
        X509Certificate x509Cert = this.getCertificate(alias, keyStore);
        try {
            byte[] skiValue = x509Cert.getExtensionValue(Extension.subjectKeyIdentifier.getId());
            byte[] octets = DEROctetString.getInstance((Object)skiValue).getOctets();
            byte[] skiBytes = SubjectKeyIdentifier.getInstance((Object)octets).getKeyIdentifier();
            return HexUtil.getHexString(skiBytes);
        }
        catch (Exception e) {
            return "-";
        }
    }

    private String getCertificateAKI(String alias, KeyStore keyStore) throws CryptoException, KeyStoreException {
        X509Certificate x509Cert = this.getCertificate(alias, keyStore);
        try {
            byte[] akiValue = x509Cert.getExtensionValue(Extension.authorityKeyIdentifier.getId());
            byte[] octets = DEROctetString.getInstance((Object)akiValue).getOctets();
            byte[] akiBytes = AuthorityKeyIdentifier.getInstance((Object)octets).getKeyIdentifier();
            return HexUtil.getHexString(akiBytes);
        }
        catch (Exception e) {
            return "-";
        }
    }

    private String getCertificateSubjectO(String alias, KeyStore keyStore) throws CryptoException, KeyStoreException {
        X509Certificate x509Cert = this.getCertificate(alias, keyStore);
        X500Name subject = X500NameUtils.x500PrincipalToX500Name(x509Cert.getSubjectX500Principal());
        return X500NameUtils.getRdn(subject, KseX500NameStyle.O);
    }

    private String getCertificateIssuerO(String alias, KeyStore keyStore) throws CryptoException, KeyStoreException {
        X509Certificate x509Cert = this.getCertificate(alias, keyStore);
        X500Name issuer = X500NameUtils.x500PrincipalToX500Name(x509Cert.getIssuerX500Principal());
        return X500NameUtils.getRdn(issuer, KseX500NameStyle.O);
    }

    private X509Certificate getCertificate(String alias, KeyStore keyStore) throws KeyStoreException, CryptoException {
        X509Certificate x509Cert = null;
        if (KeyStoreUtil.isTrustedCertificateEntry(alias, keyStore)) {
            x509Cert = X509CertUtil.convertCertificate(keyStore.getCertificate(alias));
        } else {
            Certificate[] chain = keyStore.getCertificateChain(alias);
            if (chain == null) {
                return null;
            }
            X509Certificate[] x509Chain = X509CertUtil.orderX509CertChain(X509CertUtil.convertCertificates(chain));
            x509Cert = x509Chain[0];
        }
        return x509Cert;
    }

    private void adjustColumns(KeyStoreTableColumns keyStoreTableColumnsParm) {
        this.keyStoreTableColumns = keyStoreTableColumnsParm;
        this.nofColumns = 3 + this.keyStoreTableColumns.getNofColumns();
        this.expiryWarnDays = this.keyStoreTableColumns.getExpiryWarnDays();
        this.iColWidth = new int[this.nofColumns];
        this.iNameColumn = -1;
        this.iAlgorithmColumn = -1;
        this.iKeySizeColumn = -1;
        this.iCurveColumn = -1;
        this.iCertExpiryColumn = -1;
        this.iLastModifiedColumn = -1;
        this.iAKIColumn = -1;
        this.iSKIColumn = -1;
        this.iIssuerDNColumn = -1;
        this.iSubjectDNColumn = -1;
        this.iIssuerCNColumn = -1;
        this.iSubjectCNColumn = -1;
        this.iIssuerOColumn = -1;
        this.iSubjectOColumn = -1;
        this.columnNames = new String[this.nofColumns];
        this.columnTypes = new Class[this.nofColumns];
        this.columnNames[0] = res.getString("KeyStoreTableModel.TypeColumn");
        this.columnTypes[0] = String.class;
        this.iColWidth[0] = 28;
        this.columnNames[1] = res.getString("KeyStoreTableModel.LockStatusColumn");
        this.columnTypes[1] = Boolean.class;
        this.iColWidth[1] = 28;
        this.columnNames[2] = res.getString("KeyStoreTableModel.CertExpiryStatusColumn");
        this.columnTypes[2] = Integer.class;
        this.iColWidth[2] = 28;
        for (int col = 3; col < this.nofColumns; ++col) {
            if (col == this.keyStoreTableColumns.colEntryName()) {
                this.columnNames[col] = res.getString("KeyStoreTableModel.NameColumn");
                this.columnTypes[col] = String.class;
                this.iNameColumn = col;
            }
            if (col == this.keyStoreTableColumns.colAlgorithm()) {
                this.columnNames[col] = res.getString("KeyStoreTableModel.AlgorithmColumn");
                this.columnTypes[col] = String.class;
                this.iAlgorithmColumn = col;
            }
            if (col == this.keyStoreTableColumns.colKeySize()) {
                this.columnNames[col] = res.getString("KeyStoreTableModel.KeySizeColumn");
                this.columnTypes[col] = Integer.class;
                this.iKeySizeColumn = col;
            }
            if (col == this.keyStoreTableColumns.colCurve()) {
                this.columnNames[col] = res.getString("KeyStoreTableModel.CurveColumn");
                this.columnTypes[col] = String.class;
                this.iCurveColumn = col;
            }
            if (col == this.keyStoreTableColumns.colCertificateExpiry()) {
                this.columnNames[col] = res.getString("KeyStoreTableModel.CertExpiryColumn");
                this.columnTypes[col] = Date.class;
                this.iCertExpiryColumn = col;
                this.iColWidth[col] = " 20.00.2000 00:00:00 MESZ ".length();
            }
            if (col == this.keyStoreTableColumns.colLastModified()) {
                this.columnNames[col] = res.getString("KeyStoreTableModel.LastModifiedColumn");
                this.columnTypes[col] = Date.class;
                this.iLastModifiedColumn = col;
                this.iColWidth[col] = " 20.00.2000 00:00:00 MESZ ".length();
            }
            if (col == this.keyStoreTableColumns.colAKI()) {
                this.columnNames[col] = res.getString("KeyStoreTableModel.AKIColumn");
                this.columnTypes[col] = String.class;
                this.iAKIColumn = col;
            }
            if (col == this.keyStoreTableColumns.colSKI()) {
                this.columnNames[col] = res.getString("KeyStoreTableModel.SKIColumn");
                this.columnTypes[col] = String.class;
                this.iSKIColumn = col;
            }
            if (col == this.keyStoreTableColumns.colIssuerDN()) {
                this.columnNames[col] = res.getString("KeyStoreTableModel.IssuerDNColumn");
                this.columnTypes[col] = String.class;
                this.iIssuerDNColumn = col;
            }
            if (col == this.keyStoreTableColumns.colSubjectDN()) {
                this.columnNames[col] = res.getString("KeyStoreTableModel.SubjectDNColumn");
                this.columnTypes[col] = String.class;
                this.iSubjectDNColumn = col;
            }
            if (col == this.keyStoreTableColumns.colIssuerCN()) {
                this.columnNames[col] = res.getString("KeyStoreTableModel.IssuerCNColumn");
                this.columnTypes[col] = String.class;
                this.iIssuerCNColumn = col;
            }
            if (col == this.keyStoreTableColumns.colSubjectCN()) {
                this.columnNames[col] = res.getString("KeyStoreTableModel.SubjectCNColumn");
                this.columnTypes[col] = String.class;
                this.iSubjectCNColumn = col;
            }
            if (col == this.keyStoreTableColumns.colIssuerO()) {
                this.columnNames[col] = res.getString("KeyStoreTableModel.IssuerOColumn");
                this.columnTypes[col] = String.class;
                this.iIssuerOColumn = col;
            }
            if (col == this.keyStoreTableColumns.colSubjectO()) {
                this.columnNames[col] = res.getString("KeyStoreTableModel.SubjectOColumn");
                this.columnTypes[col] = String.class;
                this.iSubjectOColumn = col;
            }
            if (this.iColWidth[col] >= 1) continue;
            this.iColWidth[col] = this.columnNames[col].length();
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.data[row][col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return this.columnTypes[col];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public KeyStoreTableColumns getKeyStoreTableColumns() {
        return this.keyStoreTableColumns;
    }

    public void setKeyStoreTableColumns(KeyStoreTableColumns keyStoreTableColumns) {
        this.keyStoreTableColumns = keyStoreTableColumns;
        this.adjustColumns(keyStoreTableColumns);
    }

    public int getColumnWidth(int col) {
        if (col < this.nofColumns && col >= 0) {
            return this.iColWidth[col];
        }
        return 0;
    }

    public KeyStoreHistory getHistory() {
        return this.history;
    }

    private class AliasComparator
    implements Comparator<String> {
        private AliasComparator() {
        }

        @Override
        public int compare(String name1, String name2) {
            return name1.compareToIgnoreCase(name2);
        }
    }
}

