/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.kse.KSE;

public class KseRestart {
    private static final String JAVA_HOME = "java.home";
    private static final String JAVA_CLASS_PATH = "java.class.path";
    private static final String KSE_INSTALL_DIR = "kse.install.dir";
    private static final String KSE_EXE = "kse.exe";
    private static final String KSE_APP = "kse.app";
    private static final String KSE_JAR = "kse.jar";

    private KseRestart() {
    }

    public static void restart() {
        if (System.getProperty(KSE_EXE) != null) {
            KseRestart.restartAsKseExe();
        } else if (System.getProperty(KSE_APP) != null) {
            KseRestart.restartAsKseApp();
        } else if (System.getProperty(JAVA_CLASS_PATH).equals(KSE_JAR)) {
            KseRestart.restartAsKseJar();
        } else {
            KseRestart.restartAsKseClass();
        }
    }

    private static void restartAsKseExe() {
        File kseInstallDir = new File(System.getProperty(KSE_INSTALL_DIR));
        File kseExe = new File(kseInstallDir, KSE_EXE);
        String[] toExec = new String[]{kseExe.getPath()};
        try {
            Runtime.getRuntime().exec(toExec);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void restartAsKseJar() {
        File javaBin = new File(new File(System.getProperty(JAVA_HOME), "bin"), "java");
        File kseInstallDir = new File(System.getProperty(KSE_INSTALL_DIR));
        File kseJar = new File(kseInstallDir, KSE_JAR);
        String[] toExec = new String[]{javaBin.getPath(), "-jar", kseJar.getPath()};
        try {
            Runtime.getRuntime().exec(toExec);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void restartAsKseApp() {
        File kseInstallDir = new File(System.getProperty(KSE_INSTALL_DIR));
        String kseApp = MessageFormat.format("{0} {1}.app", KSE.getApplicationName(), KSE.getApplicationVersion());
        File javaAppStub = new File(new File(new File(new File(kseInstallDir, kseApp), "Contents"), "MacOS"), "JavaApplicationStub");
        String[] toExec = new String[]{javaAppStub.getPath()};
        try {
            Runtime.getRuntime().exec(toExec);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void restartAsKseClass() {
        File javaBin = new File(new File(System.getProperty(JAVA_HOME), "bin"), "java");
        String kseClasspath = System.getProperty(JAVA_CLASS_PATH);
        String[] toExec = new String[]{javaBin.getPath(), "-classpath", kseClasspath, KSE.class.getName()};
        try {
            Runtime.getRuntime().exec(toExec);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

