/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.AboutAction;
import org.kse.gui.actions.ExitAction;
import org.kse.gui.actions.OpenAction;
import org.kse.gui.actions.PreferencesAction;
import org.kse.version.JavaVersion;

public class MacOsIntegration
implements InvocationHandler {
    private final KseFrame kseFrame;

    public MacOsIntegration(KseFrame kseFrame) {
        this.kseFrame = kseFrame;
    }

    public void addEventHandlers() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?> preferencesHandlerClass;
        Class<?> openFilesHandlerClass;
        Class<?> aboutHandlerClass;
        Class<?> quitHandlerClass;
        Class<?> applicationClass = Class.forName("com.apple.eawt.Application");
        if (JavaVersion.getJreVersion().isAtLeast(JavaVersion.JRE_VERSION_9)) {
            quitHandlerClass = Class.forName("java.awt.desktop.QuitHandler");
            aboutHandlerClass = Class.forName("java.awt.desktop.AboutHandler");
            openFilesHandlerClass = Class.forName("java.awt.desktop.OpenFilesHandler");
            preferencesHandlerClass = Class.forName("java.awt.desktop.PreferencesHandler");
        } else {
            quitHandlerClass = Class.forName("com.apple.eawt.QuitHandler");
            aboutHandlerClass = Class.forName("com.apple.eawt.AboutHandler");
            openFilesHandlerClass = Class.forName("com.apple.eawt.OpenFilesHandler");
            preferencesHandlerClass = Class.forName("com.apple.eawt.PreferencesHandler");
        }
        Object application = applicationClass.getConstructor(null).newInstance(null);
        Object proxy = Proxy.newProxyInstance(MacOsIntegration.class.getClassLoader(), new Class[]{quitHandlerClass, aboutHandlerClass, openFilesHandlerClass, preferencesHandlerClass}, (InvocationHandler)this);
        applicationClass.getDeclaredMethod("setQuitHandler", quitHandlerClass).invoke(application, proxy);
        applicationClass.getDeclaredMethod("setAboutHandler", aboutHandlerClass).invoke(application, proxy);
        applicationClass.getDeclaredMethod("setOpenFileHandler", openFilesHandlerClass).invoke(application, proxy);
        applicationClass.getDeclaredMethod("setPreferencesHandler", preferencesHandlerClass).invoke(application, proxy);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("openFiles".equals(method.getName())) {
            Object files;
            if (args[0] != null && (files = args[0].getClass().getMethod("getFiles", new Class[0]).invoke(args[0], new Object[0])) instanceof List) {
                OpenAction openAction = new OpenAction(this.kseFrame);
                for (File file : (List)files) {
                    openAction.openKeyStore(file);
                }
            }
        } else if ("handleQuitRequestWith".equals(method.getName())) {
            ExitAction exitAction = new ExitAction(this.kseFrame);
            exitAction.exitApplication();
            if (args[1] != null) {
                args[1].getClass().getDeclaredMethod("cancelQuit", new Class[0]).invoke(args[1], new Object[0]);
            }
        } else if ("handleAbout".equals(method.getName())) {
            AboutAction aboutAction = new AboutAction(this.kseFrame);
            aboutAction.showAbout();
        } else if ("handlePreferences".equals(method.getName())) {
            PreferencesAction preferencesAction = new PreferencesAction(this.kseFrame);
            preferencesAction.showPreferences();
        }
        return null;
    }
}

