/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.kse.gui.LnfUtil;
import org.kse.utilities.os.OperatingSystem;

public class PlatformUtil {
    private PlatformUtil() {
    }

    public static JPanel createDialogButtonPanel(JButton jbPositive) {
        JButton[] jButtonArray;
        if (jbPositive == null) {
            jButtonArray = null;
        } else {
            JButton[] jButtonArray2 = new JButton[1];
            jButtonArray = jButtonArray2;
            jButtonArray2[0] = jbPositive;
        }
        return PlatformUtil.createDialogButtonPanel(jButtonArray);
    }

    public static JPanel createDialogButtonPanel(JButton[] jbPositives) {
        return PlatformUtil.createDialogButtonPanel(jbPositives, null, null, null);
    }

    public static JPanel createDialogButtonPanel(JButton jbPositive, JButton jbNegative) {
        JButton[] jButtonArray;
        if (jbPositive == null) {
            jButtonArray = null;
        } else {
            JButton[] jButtonArray2 = new JButton[1];
            jButtonArray = jButtonArray2;
            jButtonArray2[0] = jbPositive;
        }
        return PlatformUtil.createDialogButtonPanel(jButtonArray, jbNegative);
    }

    public static JPanel createDialogButtonPanel(JButton[] jbPositives, JButton jbNegative) {
        return PlatformUtil.createDialogButtonPanel(jbPositives, jbNegative, null, null);
    }

    public static JPanel createDialogButtonPanel(JButton jbPositive, JButton jbNegative, JButton jbOther) {
        JButton[] jButtonArray;
        if (jbOther == null) {
            jButtonArray = null;
        } else {
            JButton[] jButtonArray2 = new JButton[1];
            jButtonArray = jButtonArray2;
            jButtonArray2[0] = jbOther;
        }
        return PlatformUtil.createDialogButtonPanel(jbPositive, jbNegative, jButtonArray);
    }

    public static JPanel createDialogButtonPanel(JButton jbPositive, JButton jbNegative, JButton[] jbOther) {
        JButton[] jButtonArray;
        if (jbPositive == null) {
            jButtonArray = null;
        } else {
            JButton[] jButtonArray2 = new JButton[1];
            jButtonArray = jButtonArray2;
            jButtonArray2[0] = jbPositive;
        }
        return PlatformUtil.createDialogButtonPanel(jButtonArray, jbNegative, jbOther, null);
    }

    public static JPanel createDialogButtonPanel(JButton[] jbPositives, JButton jbNegative, JButton[] jbOthers, String insets) {
        insets = insets == null ? "" : insets + ",";
        JPanel panel = new JPanel((LayoutManager)new MigLayout(insets + "nogrid, fillx, aligny 100%"));
        if (jbPositives != null) {
            for (JButton jButton : jbPositives) {
                panel.add((Component)jButton, "tag ok");
            }
        }
        if (jbOthers != null) {
            for (JButton jButton : jbOthers) {
                panel.add((Component)jButton, "sgx");
            }
        }
        if (jbNegative != null) {
            panel.add((Component)jbNegative, "tag cancel");
        }
        return panel;
    }

    public static JScrollPane createScrollPane(int vsbPolicy, int hsbPolicy) {
        return PlatformUtil.createScrollPane(null, vsbPolicy, hsbPolicy);
    }

    public static JScrollPane createScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        if (LnfUtil.usingMacLnf()) {
            if (vsbPolicy == 20) {
                vsbPolicy = 22;
            }
            if (hsbPolicy == 30) {
                hsbPolicy = 32;
            }
        }
        JScrollPane scrollPane = view != null ? new JScrollPane(view, vsbPolicy, hsbPolicy) : new JScrollPane(vsbPolicy, hsbPolicy);
        return scrollPane;
    }

    public static void setMnemonic(AbstractButton button, int mnemonic) {
        PlatformUtil.setMnemonic(button, (char)mnemonic, -1);
    }

    public static void setMnemonic(AbstractButton button, char mnemonic) {
        PlatformUtil.setMnemonic(button, mnemonic, -1);
    }

    public static void setMnemonic(AbstractButton button, int mnemonic, int index) {
        PlatformUtil.setMnemonic(button, (char)mnemonic, index);
    }

    public static void setMnemonic(AbstractButton button, char mnemonic, int index) {
        if (!OperatingSystem.isMacOs()) {
            button.setMnemonic(mnemonic);
            if (index >= 0) {
                button.setDisplayedMnemonicIndex(index);
            }
        }
    }
}

