/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.kse.gui.JMenuItemRecentFile;
import org.kse.gui.JMenuRecentFiles;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.OpenAction;

public class RecentKeyStoreFileActionListener
implements ActionListener {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/resources");
    private File recentFile;
    private KseFrame kseFrame;

    public RecentKeyStoreFileActionListener(File recentFile, KseFrame kseFrame) {
        this.recentFile = recentFile;
        this.kseFrame = kseFrame;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.kseFrame.setDefaultStatusBarText();
        if (!this.recentFile.isFile()) {
            JMenuItemRecentFile jmiRecentFile = (JMenuItemRecentFile)evt.getSource();
            JMenuRecentFiles jmRecentFiles = jmiRecentFile.getRecentFilesMenu();
            jmRecentFiles.invalidate(jmiRecentFile);
            JOptionPane.showMessageDialog(this.kseFrame.getUnderlyingFrame(), MessageFormat.format(res.getString("RecentKeyStoreFileActionListener.NotFile.message"), this.recentFile), res.getString("RecentKeyStoreFileActionListener.OpenKeyStore.Title"), 2);
            return;
        }
        OpenAction openAction = new OpenAction(this.kseFrame);
        openAction.openKeyStore(this.recentFile);
    }
}

