/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.KseFrame;
import org.kse.gui.KseRestart;
import org.kse.gui.actions.CloseAllAction;

public class ExitAction
extends CloseAllAction {
    private static final long serialVersionUID = 1L;

    public ExitAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(115, 8));
        this.putValue("LongDescription", res.getString("ExitAction.statusbar"));
        this.putValue("Name", res.getString("ExitAction.text"));
        this.putValue("ShortDescription", res.getString("ExitAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/exit.png"))));
    }

    @Override
    protected void doAction() {
        this.exitApplication();
    }

    public void exitApplication() {
        this.exitApplication(false);
    }

    public void exitApplication(boolean restart) {
        boolean keyStoresClosed;
        boolean bl = keyStoresClosed = this.kseFrame.getActiveKeyStoreHistory() != null;
        if (!this.closeAllKeyStores()) {
            return;
        }
        this.applicationSettings.setSizeAndPosition(this.kseFrame.getSizeAndPosition(keyStoresClosed));
        this.applicationSettings.setRecentFiles(this.kseFrame.getRecentFiles());
        this.applicationSettings.setCurrentDirectory(CurrentDirectory.get());
        this.applicationSettings.save();
        if (restart) {
            KseRestart.restart();
        }
        System.exit(0);
    }
}

