/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.kse.crypto.CryptoException;
import org.kse.crypto.publickey.OpenSslPubUtil;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.dialogs.importexport.DExportPublicKeyOpenSsl;
import org.kse.gui.error.DError;
import org.kse.utilities.history.KeyStoreHistory;

public class ExportTrustedCertificatePublicKeyAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = 1L;

    public ExportTrustedCertificatePublicKeyAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("LongDescription", res.getString("ExportTrustedCertificatePublicKeyAction.statusbar"));
        this.putValue("Name", res.getString("ExportTrustedCertificatePublicKeyAction.text"));
        this.putValue("ShortDescription", res.getString("ExportTrustedCertificatePublicKeyAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/trustcertexportpub.png"))));
    }

    @Override
    protected void doAction() {
        File exportFile = null;
        try {
            String alias = this.kseFrame.getSelectedEntryAlias();
            DExportPublicKeyOpenSsl dExportPublicKey = new DExportPublicKeyOpenSsl(this.frame, alias);
            dExportPublicKey.setLocationRelativeTo(this.frame);
            dExportPublicKey.setVisible(true);
            if (!dExportPublicKey.exportSelected()) {
                return;
            }
            exportFile = dExportPublicKey.getExportFile();
            boolean pemEncode = dExportPublicKey.pemEncode();
            PublicKey publicKey = this.getPublicKey(alias);
            byte[] encoded = null;
            encoded = pemEncode ? OpenSslPubUtil.getPem(publicKey).getBytes() : OpenSslPubUtil.get(publicKey);
            this.exportEncodedPublicKey(encoded, exportFile);
            JOptionPane.showMessageDialog(this.frame, res.getString("ExportTrustedCertificatePublicKeyAction.ExportPublicKeyOpenSslSuccessful.message"), res.getString("ExportTrustedCertificatePublicKeyAction.ExportPublicKeyOpenSsl.Title"), 1);
        }
        catch (FileNotFoundException ex) {
            String message = MessageFormat.format(res.getString("ExportTrustedCertificatePublicKeyAction.NoWriteFile.message"), exportFile);
            JOptionPane.showMessageDialog(this.frame, message, res.getString("ExportTrustedCertificatePublicKeyAction.ExportPublicKeyOpenSsl.Title"), 2);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }

    private PublicKey getPublicKey(String alias) throws CryptoException {
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStore keyStore = history.getCurrentState().getKeyStore();
            X509Certificate cert = X509CertUtil.convertCertificate(keyStore.getCertificate(alias));
            return cert.getPublicKey();
        }
        catch (KeyStoreException ex) {
            String message = MessageFormat.format(res.getString("ExportTrustedCertificatePublicKeyAction.NoAccessEntry.message"), alias);
            throw new CryptoException(message, ex);
        }
    }

    private void exportEncodedPublicKey(byte[] encoded, File exportFile) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(exportFile);){
            fos.write(encoded);
            fos.flush();
        }
    }
}

