/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.security.KeyStore;
import java.text.MessageFormat;
import javax.crypto.SecretKey;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.kse.crypto.Password;
import org.kse.crypto.keystore.KeyStoreType;
import org.kse.crypto.secretkey.SecretKeyType;
import org.kse.crypto.secretkey.SecretKeyUtil;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.dialogs.DGenerateSecretKey;
import org.kse.gui.dialogs.DGetAlias;
import org.kse.gui.error.DError;
import org.kse.gui.password.DGetNewPassword;
import org.kse.utilities.history.HistoryAction;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class GenerateSecretKeyAction
extends KeyStoreExplorerAction
implements HistoryAction {
    private static final long serialVersionUID = 1L;

    public GenerateSecretKeyAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)res.getString("GenerateSecretKeyAction.accelerator").charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8));
        this.putValue("LongDescription", res.getString("GenerateSecretKeyAction.statusbar"));
        this.putValue("Name", res.getString("GenerateSecretKeyAction.text"));
        this.putValue("ShortDescription", res.getString("GenerateSecretKeyAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/genseckey.png"))));
    }

    @Override
    public String getHistoryDescription() {
        return (String)this.getValue("Name");
    }

    @Override
    protected void doAction() {
        this.generateSecret();
    }

    public void generateSecret() {
        try {
            String message;
            int selected;
            int secretKeySize = this.applicationSettings.getGenerateSecretKeySize();
            SecretKeyType secretKeyType = this.applicationSettings.getGenerateSecretKeyType();
            DGenerateSecretKey dGenerateSecretKey = new DGenerateSecretKey(this.frame, secretKeyType, secretKeySize);
            dGenerateSecretKey.setLocationRelativeTo(this.frame);
            dGenerateSecretKey.setVisible(true);
            if (!dGenerateSecretKey.isSuccessful()) {
                return;
            }
            secretKeySize = dGenerateSecretKey.getSecretKeySize();
            secretKeyType = dGenerateSecretKey.getSecretKeyType();
            this.applicationSettings.setGenerateSecretKeySize(secretKeySize);
            this.applicationSettings.setGenerateSecretKeyType(secretKeyType);
            SecretKey secretKey = SecretKeyUtil.generateSecretKey(secretKeyType, secretKeySize);
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStoreState currentState = history.getCurrentState();
            KeyStoreState newState = currentState.createBasisForNextState(this);
            KeyStore keyStore = newState.getKeyStore();
            DGetAlias dGetAlias = new DGetAlias(this.frame, res.getString("GenerateSecretKeyAction.NewSecretKeyEntryAlias.Title"), null);
            dGetAlias.setLocationRelativeTo(this.frame);
            dGetAlias.setVisible(true);
            String alias = dGetAlias.getAlias();
            if (alias == null) {
                return;
            }
            if (keyStore.containsAlias(alias) && (selected = JOptionPane.showConfirmDialog(this.frame, message = MessageFormat.format(res.getString("GenerateSecretKeyAction.OverWriteEntry.message"), alias), res.getString("GenerateSecretKeyAction.NewSecretKeyEntryAlias.Title"), 0)) != 0) {
                return;
            }
            Password password = new Password((char[])null);
            KeyStoreType type = KeyStoreType.resolveJce(keyStore.getType());
            if (type.hasEntryPasswords()) {
                DGetNewPassword dGetNewPassword = new DGetNewPassword(this.frame, res.getString("GenerateSecretKeyAction.NewSecretKeyEntryPassword.Title"), this.applicationSettings.getPasswordQualityConfig());
                dGetNewPassword.setLocationRelativeTo(this.frame);
                dGetNewPassword.setVisible(true);
                password = dGetNewPassword.getPassword();
                if (password == null) {
                    return;
                }
            }
            if (keyStore.containsAlias(alias)) {
                keyStore.deleteEntry(alias);
                newState.removeEntryPassword(alias);
            }
            keyStore.setKeyEntry(alias, secretKey, password.toCharArray(), null);
            newState.setEntryPassword(alias, password);
            currentState.append(newState);
            this.kseFrame.updateControls(true);
            JOptionPane.showMessageDialog(this.frame, res.getString("GenerateSecretKeyAction.SecretKeyGenerationSuccessful.message"), res.getString("GenerateSecretKeyAction.GenerateSecretKey.Title"), 1);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }
}

