/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.security.KeyStore;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.kse.crypto.Password;
import org.kse.crypto.keystore.KeyStoreLoadException;
import org.kse.crypto.keystore.KeyStoreUtil;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.FileChooserFactory;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.error.DError;
import org.kse.gui.error.DProblem;
import org.kse.gui.error.Problem;
import org.kse.gui.password.DGetPassword;

public class OpenAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = 1L;

    public OpenAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)res.getString("OpenAction.accelerator").charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.putValue("LongDescription", res.getString("OpenAction.statusbar"));
        this.putValue("Name", res.getString("OpenAction.text"));
        this.putValue("ShortDescription", res.getString("OpenAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/open.png"))));
    }

    @Override
    protected void doAction() {
        JFileChooser chooser = FileChooserFactory.getKeyStoreFileChooser();
        chooser.setCurrentDirectory(CurrentDirectory.get());
        chooser.setDialogTitle(res.getString("OpenAction.OpenKeyStore.Title"));
        chooser.setMultiSelectionEnabled(false);
        int rtnValue = chooser.showOpenDialog(this.frame);
        if (rtnValue == 0) {
            File openFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(openFile);
            this.openKeyStore(openFile);
        }
    }

    public void openKeyStore(File keyStoreFile) {
        this.openKeyStore(keyStoreFile, null);
    }

    public void openKeyStore(File keyStoreFile, String defaultPassword) {
        try {
            if (!keyStoreFile.isFile()) {
                JOptionPane.showMessageDialog(this.frame, MessageFormat.format(res.getString("OpenAction.NotFile.message"), keyStoreFile), res.getString("OpenAction.OpenKeyStore.Title"), 2);
                return;
            }
            if (this.isKeyStoreFileOpen(keyStoreFile)) {
                JOptionPane.showMessageDialog(this.frame, MessageFormat.format(res.getString("OpenAction.NoOpenKeyStoreAlreadyOpen.message"), keyStoreFile), res.getString("OpenAction.OpenKeyStore.Title"), 2);
                return;
            }
            Password password = defaultPassword != null ? new Password(defaultPassword.toCharArray()) : null;
            KeyStore openedKeyStore = null;
            boolean firstTry = true;
            while (true) {
                if (password == null) {
                    password = this.showPasswordDialog(keyStoreFile);
                }
                if (password == null) {
                    return;
                }
                try {
                    openedKeyStore = KeyStoreUtil.load(keyStoreFile, password);
                }
                catch (KeyStoreLoadException klex) {
                    int tryAgainChoice;
                    if (!(defaultPassword != null && firstTry || (tryAgainChoice = this.showErrorMessage(keyStoreFile, klex)) != 1)) {
                        return;
                    }
                    password.nullPassword();
                    password = null;
                    firstTry = false;
                    continue;
                }
                break;
            }
            if (openedKeyStore == null) {
                JOptionPane.showMessageDialog(this.frame, MessageFormat.format(res.getString("OpenAction.FileNotRecognisedType.message"), keyStoreFile.getName()), res.getString("OpenAction.OpenKeyStore.Title"), 2);
                return;
            }
            this.kseFrame.addKeyStore(openedKeyStore, keyStoreFile, password);
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this.frame, MessageFormat.format(res.getString("OpenAction.NoReadFile.message"), keyStoreFile), res.getString("OpenAction.OpenKeyStore.Title"), 2);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }

    private Password showPasswordDialog(File keyStoreFile) {
        DGetPassword dGetPassword = new DGetPassword(this.frame, MessageFormat.format(res.getString("OpenAction.UnlockKeyStore.Title"), keyStoreFile.getName()));
        dGetPassword.setLocationRelativeTo(this.frame);
        dGetPassword.setVisible(true);
        return dGetPassword.getPassword();
    }

    private int showErrorMessage(File keyStoreFile, KeyStoreLoadException klex) {
        String problemStr = MessageFormat.format(res.getString("OpenAction.NoOpenKeyStore.Problem"), klex.getKeyStoreType().friendly(), keyStoreFile.getName());
        String[] causes = new String[]{res.getString("OpenAction.PasswordIncorrectKeyStore.Cause"), res.getString("OpenAction.CorruptedKeyStore.Cause")};
        Problem problem = new Problem(problemStr, causes, klex);
        DProblem dProblem = new DProblem(this.frame, res.getString("OpenAction.ProblemOpeningKeyStore.Title"), problem);
        dProblem.setLocationRelativeTo(this.frame);
        dProblem.setVisible(true);
        int choice = JOptionPane.showConfirmDialog(this.frame, res.getString("OpenAction.TryAgain.message"), res.getString("OpenAction.TryAgain.Title"), 0);
        return choice;
    }
}

