/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.io.File;
import java.security.KeyStore;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.kse.crypto.Password;
import org.kse.crypto.keystore.KeyStoreType;
import org.kse.crypto.keystore.KeyStoreUtil;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.OpenAction;
import org.kse.gui.dialogs.DNewKeyStoreType;
import org.kse.gui.error.DError;

public class OpenDefaultAction
extends OpenAction {
    private static final long serialVersionUID = 1L;

    public OpenDefaultAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)res.getString("OpenDefaultAction.accelerator").charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        this.putValue("LongDescription", res.getString("OpenDefaultAction.statusbar"));
        this.putValue("Name", res.getString("OpenDefaultAction.text"));
        this.putValue("ShortDescription", res.getString("OpenDefaultAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/opendefault.png"))));
    }

    @Override
    protected void doAction() {
        File defaultKeyStoreFile = new File(System.getProperty("user.home"), ".keystore");
        if (defaultKeyStoreFile.isFile()) {
            this.openKeyStore(defaultKeyStoreFile);
            return;
        }
        int selected = JOptionPane.showConfirmDialog(this.frame, res.getString("OpenDefaultAction.NoDefaultKeyStoreCreate.message"), res.getString("OpenDefaultAction.OpenDefaultKeyStore.Title"), 0);
        if (selected != 0) {
            return;
        }
        try {
            DNewKeyStoreType dNewKeyStoreType = new DNewKeyStoreType(this.frame);
            dNewKeyStoreType.setLocationRelativeTo(this.frame);
            dNewKeyStoreType.setVisible(true);
            KeyStoreType keyStoreType = dNewKeyStoreType.getKeyStoreType();
            if (keyStoreType == null) {
                return;
            }
            Password password = this.getNewKeyStorePassword();
            if (password == null) {
                return;
            }
            KeyStore defaultKeyStore = KeyStoreUtil.create(keyStoreType);
            KeyStoreUtil.save(defaultKeyStore, defaultKeyStoreFile, password);
            this.kseFrame.addKeyStore(defaultKeyStore, defaultKeyStoreFile, password);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }
}

