/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.kse.crypto.Password;
import org.kse.crypto.keystore.KeyStoreType;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.error.DError;
import org.kse.utilities.buffer.Buffer;
import org.kse.utilities.buffer.BufferEntry;
import org.kse.utilities.buffer.KeyBufferEntry;
import org.kse.utilities.buffer.KeyPairBufferEntry;
import org.kse.utilities.buffer.TrustedCertificateBufferEntry;
import org.kse.utilities.history.HistoryAction;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class PasteAction
extends KeyStoreExplorerAction
implements HistoryAction {
    private static final long serialVersionUID = 1L;

    public PasteAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)res.getString("PasteAction.accelerator").charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.putValue("LongDescription", res.getString("PasteAction.statusbar"));
        this.putValue("Name", res.getString("PasteAction.text"));
        this.putValue("ShortDescription", res.getString("PasteAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/paste.png"))));
    }

    @Override
    public String getHistoryDescription() {
        return (String)this.getValue("Name");
    }

    @Override
    protected void doAction() {
        boolean changed;
        List<BufferEntry> bufferEntries = Buffer.interrogate();
        if (bufferEntries != null && (changed = this.pasteEntries(bufferEntries))) {
            this.kseFrame.updateControls(true);
        }
    }

    private boolean pasteEntries(List<BufferEntry> bufferEntries) {
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStoreState currentState = history.getCurrentState();
            KeyStoreState newState = currentState.createBasisForNextState(this);
            KeyStore keyStore = newState.getKeyStore();
            boolean changed = false;
            for (BufferEntry bufferEntry : bufferEntries) {
                changed |= this.pasteEntry(bufferEntry, keyStore, newState);
            }
            currentState.append(newState);
            return changed;
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
            return false;
        }
    }

    private boolean pasteEntry(BufferEntry bufferEntry, KeyStore keyStore, KeyStoreState newState) throws KeyStoreException {
        String alias = bufferEntry.getName();
        if (keyStore.containsAlias(alias)) {
            if (bufferEntry.isCut()) {
                int selected = JOptionPane.showConfirmDialog(this.frame, MessageFormat.format(res.getString("PasteAction.PasteExistsReplace.message"), alias), res.getString("PasteAction.Paste.Title"), 0);
                if (selected != 0) {
                    return false;
                }
                keyStore.deleteEntry(alias);
                newState.removeEntryPassword(alias);
            } else {
                alias = this.getUniqueEntryName(alias, keyStore);
            }
        }
        if (bufferEntry instanceof KeyBufferEntry) {
            KeyStoreType keyStoreType = KeyStoreType.resolveJce(keyStore.getType());
            if (!keyStoreType.supportsKeyEntries()) {
                JOptionPane.showMessageDialog(this.frame, MessageFormat.format(res.getString("PasteAction.NoPasteKeyEntry.message"), keyStoreType.friendly()), res.getString("PasteAction.Paste.Title"), 2);
                return false;
            }
            KeyBufferEntry keyBufferEntry = (KeyBufferEntry)bufferEntry;
            Key key = keyBufferEntry.getKey();
            Password password = keyBufferEntry.getPassword();
            keyStore.setKeyEntry(alias, key, password.toCharArray(), null);
            newState.setEntryPassword(alias, password);
        } else if (bufferEntry instanceof KeyPairBufferEntry) {
            KeyPairBufferEntry keyPairBufferEntry = (KeyPairBufferEntry)bufferEntry;
            PrivateKey privateKey = keyPairBufferEntry.getPrivateKey();
            Password password = keyPairBufferEntry.getPassword();
            Certificate[] certificateChain = keyPairBufferEntry.getCertificateChain();
            keyStore.setKeyEntry(alias, privateKey, password.toCharArray(), certificateChain);
            newState.setEntryPassword(alias, password);
        } else {
            TrustedCertificateBufferEntry certBufferEntry = (TrustedCertificateBufferEntry)bufferEntry;
            keyStore.setCertificateEntry(alias, certBufferEntry.getTrustedCertificate());
        }
        if (bufferEntry.isCut()) {
            Buffer.clear();
        }
        return true;
    }

    private String getUniqueEntryName(String name, KeyStore keyStore) throws KeyStoreException {
        int i = 1;
        String tryName;
        while (keyStore.containsAlias(tryName = MessageFormat.format("{0} ({1})", name, i))) {
            ++i;
        }
        return tryName;
    }
}

