/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.swing.ImageIcon;
import org.kse.crypto.Password;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.GenerateKeyPairAction;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.error.DError;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class SignNewKeyPairAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = 6130302168441299361L;

    public SignNewKeyPairAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("LongDescription", res.getString("SignNewKeyPairAction.statusbar"));
        this.putValue("Name", res.getString("SignNewKeyPairAction.text"));
        this.putValue("ShortDescription", res.getString("SignNewKeyPairAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/signnewkeypair.png"))));
    }

    @Override
    protected void doAction() {
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStoreState currentState = history.getCurrentState();
            String alias = this.kseFrame.getSelectedEntryAlias();
            Password password = this.getEntryPassword(alias, currentState);
            if (password == null) {
                return;
            }
            KeyStore keyStore = currentState.getKeyStore();
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
            Certificate[] certs = keyStore.getCertificateChain(alias);
            X509Certificate[] signingCertChain = X509CertUtil.orderX509CertChain(X509CertUtil.convertCertificates(certs));
            X509Certificate signingCert = signingCertChain[0];
            GenerateKeyPairAction generateKeyPairAction = new GenerateKeyPairAction(this.kseFrame);
            generateKeyPairAction.generateKeyPair(signingCert, signingCertChain, privateKey);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }
}

