/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.error.DError;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class UndoAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = 1L;
    private String defaultName = res.getString("UndoAction.text");

    public UndoAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)res.getString("UndoAction.accelerator").charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.putValue("LongDescription", res.getString("UndoAction.statusbar"));
        this.putValue("Name", this.defaultName);
        this.putValue("ShortDescription", res.getString("UndoAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/undo.png"))));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            KeyStoreState currentState = this.kseFrame.getActiveKeyStoreHistory().getCurrentState();
            this.putValue("Name", MessageFormat.format(res.getString("UndoAction.dynamic.text"), currentState.getActionDescription()));
        } else {
            this.putValue("Name", this.defaultName);
        }
    }

    @Override
    protected void doAction() {
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            history.getCurrentState().setPreviousStateAsCurrentState();
            this.kseFrame.updateControls(true);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }
}

