/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto;

import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;

public class ProviderTreeCellRend
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/resources");

    @Override
    public Component getTreeCellRendererComponent(JTree jtrProvider, Object value, boolean isSelected, boolean isExpanded, boolean leaf, int row, boolean hasFocus) {
        JLabel cell = (JLabel)super.getTreeCellRendererComponent(jtrProvider, value, isSelected, isExpanded, leaf, row, hasFocus);
        cell.setText(value.toString());
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        ImageIcon icon = null;
        if (node.getLevel() == 0) {
            icon = new ImageIcon(this.getClass().getResource("images/root_node.png"));
            cell.setToolTipText(res.getString("ProviderTreeCellRend.Root.tooltip"));
        } else if (node.getLevel() == 1) {
            icon = new ImageIcon(this.getClass().getResource("images/provider_node.png"));
            cell.setToolTipText(res.getString("ProviderTreeCellRend.Provider.tooltip"));
        } else if (node.getLevel() == 2) {
            TreeNode parent = node.getParent();
            int index = parent.getIndex(node);
            if (index == 0) {
                icon = new ImageIcon(this.getClass().getResource("images/description_node.png"));
                cell.setToolTipText(res.getString("ProviderTreeCellRend.Description.tooltip"));
            } else if (index == 1) {
                icon = new ImageIcon(this.getClass().getResource("images/provider_class_node.png"));
                cell.setToolTipText(res.getString("ProviderTreeCellRend.ProviderClass.tooltip"));
            } else {
                icon = new ImageIcon(this.getClass().getResource("images/services_node.png"));
                cell.setToolTipText(res.getString("ProviderTreeCellRend.Services.tooltip"));
            }
        } else if (node.getLevel() == 3) {
            icon = new ImageIcon(this.getClass().getResource("images/service_node.png"));
            cell.setToolTipText(res.getString("ProviderTreeCellRend.Service.tooltip"));
        } else if (node.getLevel() == 4) {
            icon = new ImageIcon(this.getClass().getResource("images/algorithm_node.png"));
            cell.setToolTipText(res.getString("ProviderTreeCellRend.Algorithm.tooltip"));
        } else if (node.getLevel() == 5) {
            TreeNode parent = node.getParent();
            int index = parent.getIndex(node);
            if (index == 0) {
                icon = new ImageIcon(this.getClass().getResource("images/algorithm_class_node.png"));
                cell.setToolTipText(res.getString("ProviderTreeCellRend.AlgorithmClass.tooltip"));
            } else if (node.toString().equals(res.getString("DProviderInfo.AttributesNode.text"))) {
                icon = new ImageIcon(this.getClass().getResource("images/attributes_node.png"));
                cell.setToolTipText(res.getString("ProviderTreeCellRend.Attributes.tooltip"));
            } else {
                icon = new ImageIcon(this.getClass().getResource("images/aliases_node.png"));
                cell.setToolTipText(res.getString("ProviderTreeCellRend.Aliases.tooltip"));
            }
        } else {
            TreeNode parent = node.getParent();
            if (parent.toString().equals(res.getString("DProviderInfo.AttributesNode.text"))) {
                icon = new ImageIcon(this.getClass().getResource("images/attribute_node.png"));
                cell.setToolTipText(res.getString("ProviderTreeCellRend.Attribute.tooltip"));
            } else {
                icon = new ImageIcon(this.getClass().getResource("images/alias_node.png"));
                cell.setToolTipText(res.getString("ProviderTreeCellRend.Alias.tooltip"));
            }
        }
        cell.setIcon(icon);
        return cell;
    }
}

