/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto.accessdescription;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.GeneralName;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;
import org.kse.gui.crypto.generalname.JGeneralName;
import org.kse.gui.oid.JObjectId;

public class DAccessDescriptionChooser
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/accessdescription/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpAccessDescription;
    private JLabel jlAccessMethod;
    private JObjectId joiAccessMethod;
    private JLabel jlAccessLocation;
    private JGeneralName jgnAccessLocation;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private AccessDescription accessDescription;

    public DAccessDescriptionChooser(JFrame parent, String title, AccessDescription accessDescription) {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents(accessDescription);
    }

    public DAccessDescriptionChooser(JDialog parent, String title, AccessDescription accessDescription) {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents(accessDescription);
    }

    private void initComponents(AccessDescription accessDescription) {
        this.jlAccessMethod = new JLabel(res.getString("DAccessDescriptionChooser.jlAccessMethod.text"));
        GridBagConstraints gbc_jlAccessMethod = new GridBagConstraints();
        gbc_jlAccessMethod.gridx = 0;
        gbc_jlAccessMethod.gridy = 0;
        gbc_jlAccessMethod.gridwidth = 1;
        gbc_jlAccessMethod.gridheight = 1;
        gbc_jlAccessMethod.insets = new Insets(5, 5, 5, 5);
        gbc_jlAccessMethod.anchor = 13;
        this.joiAccessMethod = new JObjectId(res.getString("DAccessDescriptionChooser.AccessMethod.Text"));
        this.joiAccessMethod.setToolTipText(res.getString("DAccessDescriptionChooser.joiAccessMethod.tooltip"));
        GridBagConstraints gbc_joiAccessMethod = new GridBagConstraints();
        gbc_joiAccessMethod.gridx = 1;
        gbc_joiAccessMethod.gridy = 0;
        gbc_joiAccessMethod.gridwidth = 1;
        gbc_joiAccessMethod.gridheight = 1;
        gbc_joiAccessMethod.insets = new Insets(5, 5, 5, 5);
        gbc_joiAccessMethod.anchor = 17;
        this.jlAccessLocation = new JLabel(res.getString("DAccessDescriptionChooser.jlAccessLocation.text"));
        GridBagConstraints gbc_jlAccessLocation = new GridBagConstraints();
        gbc_jlAccessLocation.gridx = 0;
        gbc_jlAccessLocation.gridy = 1;
        gbc_jlAccessLocation.gridwidth = 1;
        gbc_jlAccessLocation.gridheight = 1;
        gbc_jlAccessLocation.insets = new Insets(5, 5, 5, 5);
        gbc_jlAccessLocation.anchor = 13;
        this.jgnAccessLocation = new JGeneralName(res.getString("DAccessDescriptionChooser.AccessLocation.Title"));
        this.jgnAccessLocation.setToolTipText(res.getString("DAccessDescriptionChooser.jgnAccessLocation.tooltip"));
        GridBagConstraints gbc_jgnAccessLocation = new GridBagConstraints();
        gbc_jgnAccessLocation.gridx = 1;
        gbc_jgnAccessLocation.gridy = 1;
        gbc_jgnAccessLocation.gridwidth = 1;
        gbc_jgnAccessLocation.gridheight = 1;
        gbc_jgnAccessLocation.insets = new Insets(5, 5, 5, 5);
        gbc_jgnAccessLocation.anchor = 17;
        this.jpAccessDescription = new JPanel(new GridBagLayout());
        this.jpAccessDescription.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        this.jpAccessDescription.add((Component)this.jlAccessMethod, gbc_jlAccessMethod);
        this.jpAccessDescription.add((Component)this.joiAccessMethod, gbc_joiAccessMethod);
        this.jpAccessDescription.add((Component)this.jlAccessLocation, gbc_jlAccessLocation);
        this.jpAccessDescription.add((Component)this.jgnAccessLocation, gbc_jgnAccessLocation);
        this.jbOK = new JButton(res.getString("DAccessDescriptionChooser.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DAccessDescriptionChooser.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DAccessDescriptionChooser.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DAccessDescriptionChooser.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DAccessDescriptionChooser.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", this.jpAccessDescription);
        this.getContentPane().add("South", this.jpButtons);
        this.populate(accessDescription);
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void populate(AccessDescription accessDescription) {
        if (accessDescription != null) {
            this.joiAccessMethod.setObjectId(accessDescription.getAccessMethod());
            this.jgnAccessLocation.setGeneralName(accessDescription.getAccessLocation());
        }
    }

    public AccessDescription getAccessDescription() {
        return this.accessDescription;
    }

    private void okPressed() {
        ASN1ObjectIdentifier accessMethod = this.joiAccessMethod.getObjectId();
        if (accessMethod == null) {
            JOptionPane.showMessageDialog(this, res.getString("DAccessDescriptionChooser.AccessMethodValueReq.message"), this.getTitle(), 2);
            return;
        }
        GeneralName accessLocation = this.jgnAccessLocation.getGeneralName();
        if (accessLocation == null) {
            JOptionPane.showMessageDialog(this, res.getString("DAccessDescriptionChooser.AccessLocationValueReq.message"), this.getTitle(), 2);
            return;
        }
        this.accessDescription = new AccessDescription(accessMethod, accessLocation);
        this.closeDialog();
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

