/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto.generalsubtree;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.kse.crypto.x509.GeneralNameUtil;

public class GeneralSubtreesTableCellRend
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;

    @Override
    public Component getTableCellRendererComponent(JTable jtGeneralSubtrees, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        JLabel cell = (JLabel)super.getTableCellRendererComponent(jtGeneralSubtrees, value, isSelected, hasFocus, row, col);
        GeneralSubtree generalSubtree = (GeneralSubtree)value;
        if (col == 0) {
            cell.setText(GeneralNameUtil.safeToString(generalSubtree.getBase(), false));
        } else if (col == 1) {
            if (generalSubtree.getMinimum() != null) {
                String minimumStr = "" + generalSubtree.getMinimum().intValue();
                cell.setText(minimumStr);
                cell.setToolTipText(minimumStr);
            } else {
                cell.setText("-");
            }
        } else if (generalSubtree.getMaximum() != null) {
            String maximumStr = "" + generalSubtree.getMaximum().intValue();
            cell.setText(maximumStr);
            cell.setToolTipText(maximumStr);
        } else {
            cell.setText("-");
        }
        cell.setBorder(new EmptyBorder(0, 5, 0, 5));
        return cell;
    }
}

