/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto.policyinformation;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.bouncycastle.asn1.x509.UserNotice;
import org.kse.crypto.x509.PolicyInformationUtil;
import org.kse.gui.CursorUtil;
import org.kse.gui.crypto.policyinformation.DUserNoticeChooser;

public class JUserNotice
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/policyinformation/resources");
    private JTextField jtfUserNotice;
    private JButton jbEditUserNotice;
    private JButton jbClearUserNotice;
    private String title;
    private UserNotice userNotice;

    public JUserNotice(String title) {
        this.title = title;
        this.initComponents();
    }

    private void initComponents() {
        this.jtfUserNotice = new JTextField(20);
        this.jtfUserNotice.setEditable(false);
        GridBagConstraints gbc_jtfUserNotice = new GridBagConstraints();
        gbc_jtfUserNotice.gridwidth = 1;
        gbc_jtfUserNotice.gridheight = 1;
        gbc_jtfUserNotice.gridx = 0;
        gbc_jtfUserNotice.gridy = 0;
        gbc_jtfUserNotice.insets = new Insets(0, 0, 0, 5);
        ImageIcon editIcon = new ImageIcon(this.getClass().getResource("images/edit_user_notice.png"));
        this.jbEditUserNotice = new JButton(editIcon);
        this.jbEditUserNotice.setToolTipText(res.getString("JUserNotice.jbEditUserNotice.tooltip"));
        this.jbEditUserNotice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JUserNotice.this);
                    JUserNotice.this.editUserNotice();
                }
                finally {
                    CursorUtil.setCursorFree(JUserNotice.this);
                }
            }
        });
        GridBagConstraints gbc_jbEditUserNotice = new GridBagConstraints();
        gbc_jbEditUserNotice.gridwidth = 1;
        gbc_jbEditUserNotice.gridheight = 1;
        gbc_jbEditUserNotice.gridx = 1;
        gbc_jbEditUserNotice.gridy = 0;
        gbc_jbEditUserNotice.insets = new Insets(0, 0, 0, 5);
        ImageIcon clearIcon = new ImageIcon(this.getClass().getResource("images/clear_user_notice.png"));
        this.jbClearUserNotice = new JButton(clearIcon);
        this.jbClearUserNotice.setToolTipText(res.getString("JUserNotice.jbClearUserNotice.tooltip"));
        this.jbClearUserNotice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JUserNotice.this);
                    JUserNotice.this.clearUserNotice();
                }
                finally {
                    CursorUtil.setCursorFree(JUserNotice.this);
                }
            }
        });
        GridBagConstraints gbc_jbClearUserNotice = new GridBagConstraints();
        gbc_jbClearUserNotice.gridwidth = 1;
        gbc_jbClearUserNotice.gridheight = 1;
        gbc_jbClearUserNotice.gridx = 2;
        gbc_jbClearUserNotice.gridy = 0;
        gbc_jbClearUserNotice.insets = new Insets(0, 0, 0, 0);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.jtfUserNotice, gbc_jtfUserNotice);
        this.add((Component)this.jbEditUserNotice, gbc_jbEditUserNotice);
        this.add((Component)this.jbClearUserNotice, gbc_jbClearUserNotice);
        this.populate();
    }

    public UserNotice getUserNotice() {
        return this.userNotice;
    }

    public void setUserNotice(UserNotice userNotice) {
        this.userNotice = userNotice;
        this.populate();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.jbEditUserNotice.setEnabled(enabled);
        this.jbClearUserNotice.setEnabled(enabled);
    }

    @Override
    public void setToolTipText(String toolTipText) {
        super.setToolTipText(toolTipText);
        this.jtfUserNotice.setToolTipText(toolTipText);
    }

    private void populate() {
        if (this.userNotice != null) {
            this.jtfUserNotice.setText(PolicyInformationUtil.toString(this.userNotice));
            this.jbClearUserNotice.setEnabled(true);
        } else {
            this.jtfUserNotice.setText("");
            this.jbClearUserNotice.setEnabled(false);
        }
        this.jtfUserNotice.setCaretPosition(0);
    }

    private void editUserNotice() {
        Container container = this.getTopLevelAncestor();
        DUserNoticeChooser dUserNoticeChooser = null;
        dUserNoticeChooser = container instanceof JDialog ? new DUserNoticeChooser((JDialog)container, this.title, this.userNotice) : new DUserNoticeChooser((JFrame)container, this.title, this.userNotice);
        dUserNoticeChooser.setLocationRelativeTo(container);
        dUserNoticeChooser.setVisible(true);
        UserNotice newUserNotice = dUserNoticeChooser.getUserNotice();
        if (newUserNotice == null) {
            return;
        }
        this.setUserNotice(newUserNotice);
    }

    private void clearUserNotice() {
        this.setUserNotice(null);
    }
}

