/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.security.auth.x500.X500Principal;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.kse.crypto.CryptoException;
import org.kse.crypto.csr.CsrType;
import org.kse.crypto.keypair.KeyPairType;
import org.kse.crypto.signing.SignatureType;
import org.kse.crypto.x509.X500NameUtils;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.CursorUtil;
import org.kse.gui.FileChooserFactory;
import org.kse.gui.JEscDialog;
import org.kse.gui.JavaFXFileChooser;
import org.kse.gui.PlatformUtil;
import org.kse.gui.crypto.JDistinguishedName;
import org.kse.gui.dialogs.DialogHelper;
import org.kse.utilities.DialogViewer;
import org.kse.utilities.io.FileNameUtil;

public class DGenerateCsr
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JLabel jlFormat;
    private JRadioButton jrbPkcs10;
    private JRadioButton jrbSpkac;
    private JLabel jlSignatureAlgorithm;
    private JComboBox<SignatureType> jcbSignatureAlgorithm;
    private JLabel jlName;
    private JDistinguishedName jdnName;
    private JLabel jlChallenge;
    private JTextField jtfChallenge;
    private JLabel jlUnstructuredName;
    private JTextField jtfUnstructuredName;
    private JLabel jlExtensions;
    private JCheckBox jcbExtensions;
    private JLabel jlCsrFile;
    private JTextField jtfCsrFile;
    private JButton jbBrowse;
    private JButton jbOK;
    private JButton jbCancel;
    private boolean generateSelected = false;
    private String alias;
    private X500Principal subjectDN;
    private PrivateKey privateKey;
    private KeyPairType keyPairType;
    private CsrType format;
    private SignatureType signatureAlgorithm;
    private String challenge;
    private String unstructuredName;
    private boolean addExtensionsWanted;
    private File csrFile;
    private String path;

    public DGenerateCsr(JFrame parent, String alias, X500Principal subjectDN, PrivateKey privateKey, KeyPairType keyPairType, String path) throws CryptoException {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.alias = alias;
        this.subjectDN = subjectDN;
        this.privateKey = privateKey;
        this.keyPairType = keyPairType;
        this.path = path;
        this.setTitle(res.getString("DGenerateCsr.Title"));
        this.initComponents();
    }

    private void initComponents() throws CryptoException {
        this.jlFormat = new JLabel(res.getString("DGenerateCsr.jlFormat.text"));
        this.jrbPkcs10 = new JRadioButton(res.getString("DGenerateCsr.jrbPkcs10.text"), false);
        PlatformUtil.setMnemonic((AbstractButton)this.jrbPkcs10, res.getString("DGenerateCsr.jrbPkcs10.mnemonic").charAt(0));
        this.jrbPkcs10.setToolTipText(res.getString("DGenerateCsr.jrbPkcs10.tooltip"));
        this.jrbSpkac = new JRadioButton(res.getString("DGenerateCsr.jrbSpkac.text"), true);
        PlatformUtil.setMnemonic((AbstractButton)this.jrbSpkac, res.getString("DGenerateCsr.jrbSpkac.mnemonic").charAt(0));
        this.jrbSpkac.setToolTipText(res.getString("DGenerateCsr.jrbSpkac.tooltip"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.jrbPkcs10);
        buttonGroup.add(this.jrbSpkac);
        this.jrbPkcs10.setSelected(true);
        this.jlSignatureAlgorithm = new JLabel(res.getString("DGenerateCsr.jlSignatureAlgorithm.text"));
        this.jcbSignatureAlgorithm = new JComboBox();
        this.jcbSignatureAlgorithm.setMaximumRowCount(10);
        this.jcbSignatureAlgorithm.setToolTipText(res.getString("DGenerateCsr.jcbSignatureAlgorithm.tooltip"));
        DialogHelper.populateSigAlgs(this.keyPairType, this.privateKey, this.jcbSignatureAlgorithm);
        this.jlName = new JLabel(res.getString("DGenerateCsr.jlName.text"));
        this.jdnName = new JDistinguishedName(res.getString("DGenerateCsr.jdnName.title"), 40, true);
        this.jdnName.setToolTipText(res.getString("DGenerateCsr.jdnName.tooltip"));
        this.jdnName.setDistinguishedName(X500NameUtils.x500PrincipalToX500Name(this.subjectDN));
        this.jlChallenge = new JLabel(res.getString("DGenerateCsr.jlChallenge.text"));
        this.jtfChallenge = new JTextField(15);
        this.jtfChallenge.setToolTipText(res.getString("DGenerateCsr.jtfChallenge.tooltip"));
        this.jlUnstructuredName = new JLabel(res.getString("DGenerateCsr.jlUnstructuredName.text"));
        this.jtfUnstructuredName = new JTextField(40);
        this.jtfUnstructuredName.setToolTipText(res.getString("DGenerateCsr.jtfUnstructuredName.tooltip"));
        this.jlExtensions = new JLabel(res.getString("DGenerateCsr.jlExtensions.text"));
        this.jcbExtensions = new JCheckBox(res.getString("DGenerateCsr.jcbExtensions.text"));
        this.jcbExtensions.setToolTipText(res.getString("DGenerateCsr.jcbExtensions.tooltip"));
        this.jcbExtensions.setSelected(true);
        this.jlCsrFile = new JLabel(res.getString("DGenerateCsr.jlCsrFile.text"));
        this.jtfCsrFile = new JTextField(40);
        this.jtfCsrFile.setToolTipText(res.getString("DGenerateCsr.jtfCsrFile.tooltip"));
        this.populateCsrFileName();
        this.jbBrowse = new JButton(res.getString("DGenerateCsr.jbBrowse.text"));
        this.jbBrowse.setToolTipText(res.getString("DGenerateCsr.jbBrowse.tooltip"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbBrowse, res.getString("DGenerateCsr.jbBrowse.mnemonic").charAt(0));
        this.jbOK = new JButton(res.getString("DGenerateCsr.jbOK.text"));
        this.jbCancel = new JButton(res.getString("DGenerateCsr.jbCancel.text"));
        Container pane = this.getContentPane();
        pane.setLayout((LayoutManager)new MigLayout("insets dialog, fill", "[right]unrel[]", "[]unrel[]"));
        pane.add((Component)this.jlFormat, "");
        pane.add((Component)this.jrbPkcs10, "split 2");
        pane.add((Component)this.jrbSpkac, "wrap");
        pane.add((Component)this.jlSignatureAlgorithm, "");
        pane.add(this.jcbSignatureAlgorithm, "wrap");
        pane.add((Component)this.jlName, "");
        pane.add((Component)this.jdnName, "spanx, wrap");
        pane.add((Component)this.jlChallenge, "");
        pane.add((Component)this.jtfChallenge, "wrap");
        pane.add((Component)this.jlUnstructuredName, "");
        pane.add((Component)this.jtfUnstructuredName, "wrap");
        pane.add((Component)this.jlExtensions, "");
        pane.add((Component)this.jcbExtensions, "wrap");
        pane.add((Component)this.jlCsrFile, "");
        pane.add((Component)this.jtfCsrFile, "");
        pane.add((Component)this.jbBrowse, "wrap");
        pane.add((Component)new JSeparator(), "spanx, growx, wrap 15:push");
        pane.add((Component)this.jbCancel, "spanx, split 2, tag cancel");
        pane.add((Component)this.jbOK, "tag ok");
        this.jrbPkcs10.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (DGenerateCsr.this.jrbPkcs10.isSelected()) {
                    DGenerateCsr.this.jlUnstructuredName.setEnabled(true);
                    DGenerateCsr.this.jtfUnstructuredName.setEnabled(true);
                    DGenerateCsr.this.jlExtensions.setEnabled(true);
                    DGenerateCsr.this.jcbExtensions.setEnabled(true);
                } else {
                    DGenerateCsr.this.jlUnstructuredName.setEnabled(false);
                    DGenerateCsr.this.jtfUnstructuredName.setEnabled(false);
                    DGenerateCsr.this.jlExtensions.setEnabled(false);
                    DGenerateCsr.this.jcbExtensions.setEnabled(false);
                }
            }
        });
        this.jbBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DGenerateCsr.this);
                    DGenerateCsr.this.browsePressed();
                }
                finally {
                    CursorUtil.setCursorFree(DGenerateCsr.this);
                }
            }
        });
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DGenerateCsr.this.okPressed();
            }
        });
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DGenerateCsr.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DGenerateCsr.this.cancelPressed();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DGenerateCsr.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void populateCsrFileName() {
        String sanitizedAlias = FileNameUtil.cleanFileName(this.alias);
        File csrFile = new File(this.path, sanitizedAlias + ".csr");
        this.jtfCsrFile.setText(csrFile.getPath());
    }

    private void browsePressed() {
        int rtnValue;
        JFileChooser chooser = null;
        chooser = this.jrbPkcs10.isSelected() ? FileChooserFactory.getPkcs10FileChooser() : FileChooserFactory.getSpkacFileChooser();
        File currentExportFile = new File(this.jtfCsrFile.getText().trim());
        if (currentExportFile.getParentFile() != null && currentExportFile.getParentFile().exists()) {
            chooser.setCurrentDirectory(currentExportFile.getParentFile());
            chooser.setSelectedFile(currentExportFile);
        } else {
            chooser.setCurrentDirectory(CurrentDirectory.get());
        }
        chooser.setDialogTitle(res.getString("DGenerateCsr.ChooseCsrFile.Title"));
        chooser.setMultiSelectionEnabled(false);
        int n = rtnValue = JavaFXFileChooser.isFxAvailable() ? chooser.showSaveDialog(this) : chooser.showDialog(this, res.getString("DGenerateCsr.ChooseCsrFile.button"));
        if (rtnValue == 0) {
            File chosenFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(chosenFile);
            this.jtfCsrFile.setText(chosenFile.toString());
            this.jtfCsrFile.setCaretPosition(0);
        }
    }

    public boolean generateSelected() {
        return this.generateSelected;
    }

    public CsrType getFormat() {
        return this.format;
    }

    public SignatureType getSignatureType() {
        return this.signatureAlgorithm;
    }

    public String getChallenge() {
        return this.challenge;
    }

    public String getUnstructuredName() {
        return this.unstructuredName;
    }

    public boolean isAddExtensionsWanted() {
        return this.addExtensionsWanted;
    }

    public File getCsrFile() {
        return this.csrFile;
    }

    public X500Principal getSubjectDN() {
        return this.subjectDN;
    }

    private void okPressed() {
        String message;
        int selected;
        this.format = this.jrbPkcs10.isSelected() ? CsrType.PKCS10 : CsrType.SPKAC;
        this.signatureAlgorithm = this.jcbSignatureAlgorithm.getItemAt(this.jcbSignatureAlgorithm.getSelectedIndex());
        if (this.jdnName.getDistinguishedName().toString().isEmpty()) {
            JOptionPane.showMessageDialog(this, res.getString("DGenerateCsr.InvalidDN.message"), this.getTitle(), 2);
            return;
        }
        try {
            this.subjectDN = X500NameUtils.x500NameToX500Principal(this.jdnName.getDistinguishedName());
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, res.getString("DGenerateCsr.InvalidDN.message"), this.getTitle(), 2);
            return;
        }
        this.challenge = this.jtfChallenge.getText();
        if (this.challenge.length() == 0) {
            if (this.format == CsrType.SPKAC) {
                JOptionPane.showMessageDialog(this, res.getString("DGenerateCsr.ChallengeRequiredForSpkac.message"), this.getTitle(), 2);
                return;
            }
            this.challenge = null;
        }
        this.unstructuredName = this.jtfUnstructuredName.getText();
        if (this.unstructuredName.length() == 0) {
            this.unstructuredName = null;
        }
        this.addExtensionsWanted = this.jcbExtensions.isSelected();
        String csrFileStr = this.jtfCsrFile.getText().trim();
        if (csrFileStr.length() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DGenerateCsr.CsrFileRequired.message"), this.getTitle(), 2);
            return;
        }
        File csrFile = new File(csrFileStr);
        if (csrFile.isFile() && (selected = JOptionPane.showConfirmDialog(this, message = MessageFormat.format(res.getString("DGenerateCsr.OverWriteCsrFile.message"), csrFile), this.getTitle(), 0)) != 0) {
            return;
        }
        this.csrFile = csrFile;
        this.generateSelected = true;
        this.closeDialog();
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA", "BC");
        PrivateKey privateKey = keyGen.genKeyPair().getPrivate();
        X500Principal dn = new X500Principal("CN=test,OU=Test Department,O=Test Organisation,C=US");
        DialogViewer.run(new DGenerateCsr(new JFrame(), "alias (test)", dn, privateKey, KeyPairType.RSA, ""));
    }
}

