/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.kse.crypto.CryptoException;
import org.kse.crypto.keypair.KeyPairType;
import org.kse.crypto.signing.SignatureType;
import org.kse.crypto.x509.X500NameUtils;
import org.kse.crypto.x509.X509CertificateGenerator;
import org.kse.crypto.x509.X509CertificateVersion;
import org.kse.crypto.x509.X509ExtensionSet;
import org.kse.gui.CursorUtil;
import org.kse.gui.JEscDialog;
import org.kse.gui.crypto.JDistinguishedName;
import org.kse.gui.crypto.JValidityPeriod;
import org.kse.gui.datetime.JDateTime;
import org.kse.gui.dialogs.DialogHelper;
import org.kse.gui.dialogs.extensions.DAddExtensions;
import org.kse.gui.error.DError;
import org.kse.utilities.DialogViewer;

public class DGenerateKeyPairCert
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JLabel jlVersion;
    private JRadioButton jrbVersion1;
    private JRadioButton jrbVersion3;
    private JLabel jlSigAlg;
    private JComboBox<SignatureType> jcbSignatureAlgorithm;
    private JLabel jlValidityStart;
    private JDateTime jdtValidityStart;
    private JLabel jlValidityEnd;
    private JDateTime jdtValidityEnd;
    private JLabel jlValidityPeriod;
    private JValidityPeriod jvpValidityPeriod;
    private JLabel jlSerialNumber;
    private JTextField jtfSerialNumber;
    private JLabel jlName;
    private JDistinguishedName jdnName;
    private JButton jbAddExtensions;
    private JButton jbOK;
    private JButton jbCancel;
    private KeyPair keyPair;
    private KeyPairType keyPairType;
    private X509Certificate certificate;
    private X509ExtensionSet extensions = new X509ExtensionSet();
    private X509Certificate issuerCert;
    private PrivateKey issuerPrivateKey;
    private Provider provider;

    public DGenerateKeyPairCert(JFrame parent, String title, KeyPair keyPair, KeyPairType keyPairType, X509Certificate issuerCert, PrivateKey issuerPrivateKey, Provider provider) throws CryptoException {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.keyPair = keyPair;
        this.keyPairType = keyPairType;
        this.issuerCert = issuerCert;
        this.issuerPrivateKey = issuerPrivateKey;
        this.provider = provider;
        this.initComponents(title);
    }

    private void initComponents(String title) throws CryptoException {
        this.jlVersion = new JLabel(res.getString("DGenerateKeyPairCert.jlVersion.text"));
        this.jrbVersion1 = new JRadioButton(res.getString("DGenerateKeyPairCert.jrbVersion1.text"));
        this.jrbVersion1.setToolTipText(res.getString("DGenerateKeyPairCert.jrbVersion1.tooltip"));
        this.jrbVersion3 = new JRadioButton(res.getString("DGenerateKeyPairCert.jrbVersion3.text"));
        this.jrbVersion3.setToolTipText(res.getString("DGenerateKeyPairCert.jrbVersion3.tooltip"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.jrbVersion1);
        buttonGroup.add(this.jrbVersion3);
        this.jrbVersion3.setSelected(true);
        this.jlSigAlg = new JLabel(res.getString("DGenerateKeyPairCert.jlSigAlg.text"));
        this.jcbSignatureAlgorithm = new JComboBox();
        this.jcbSignatureAlgorithm.setToolTipText(res.getString("DGenerateKeyPairCert.jcbSignatureAlgorithm.tooltip"));
        this.jcbSignatureAlgorithm.setMaximumRowCount(10);
        if (this.issuerPrivateKey != null) {
            KeyPairType issuerKeyPairType = KeyPairType.resolveJce(this.issuerPrivateKey.getAlgorithm());
            DialogHelper.populateSigAlgs(issuerKeyPairType, this.issuerPrivateKey, this.jcbSignatureAlgorithm);
        } else {
            DialogHelper.populateSigAlgs(this.keyPairType, this.keyPair.getPrivate(), this.jcbSignatureAlgorithm);
        }
        Date now = new Date();
        this.jlValidityStart = new JLabel(res.getString("DGenerateKeyPairCert.jlValidityStart.text"));
        this.jdtValidityStart = new JDateTime(res.getString("DGenerateKeyPairCert.jdtValidityStart.text"), false);
        this.jdtValidityStart.setDateTime(now);
        this.jdtValidityStart.setToolTipText(res.getString("DGenerateKeyPairCert.jdtValidityStart.tooltip"));
        this.jlValidityPeriod = new JLabel(res.getString("DGenerateKeyPairCert.jlValidityPeriod.text"));
        this.jvpValidityPeriod = new JValidityPeriod(0);
        this.jvpValidityPeriod.setToolTipText(res.getString("DGenerateKeyPairCert.jvpValidityPeriod.tooltip"));
        this.jlValidityEnd = new JLabel(res.getString("DGenerateKeyPairCert.jlValidityEnd.text"));
        this.jdtValidityEnd = new JDateTime(res.getString("DGenerateKeyPairCert.jdtValidityEnd.text"), false);
        this.jdtValidityEnd.setDateTime(new Date(now.getTime() + TimeUnit.DAYS.toMillis(365L)));
        this.jdtValidityEnd.setToolTipText(res.getString("DGenerateKeyPairCert.jdtValidityEnd.tooltip"));
        this.jlSerialNumber = new JLabel(res.getString("DGenerateKeyPairCert.jlSerialNumber.text"));
        this.jtfSerialNumber = new JTextField("" + this.generateSerialNumber(), 20);
        this.jtfSerialNumber.setToolTipText(res.getString("DGenerateKeyPairCert.jtfSerialNumber.tooltip"));
        this.jlName = new JLabel(res.getString("DGenerateKeyPairCert.jlName.text"));
        this.jdnName = new JDistinguishedName(res.getString("DGenerateKeyPairCert.jdnName.title"), 30, true);
        this.jdnName.setToolTipText(res.getString("DGenerateKeyPairCert.jdnName.tooltip"));
        this.jbAddExtensions = new JButton(res.getString("DGenerateKeyPairCert.jbAddExtensions.text"));
        this.jbAddExtensions.setMnemonic(res.getString("DGenerateKeyPairCert.jbAddExtensions.mnemonic").charAt(0));
        this.jbAddExtensions.setToolTipText(res.getString("DGenerateKeyPairCert.jbAddExtensions.tooltip"));
        this.jbCancel = new JButton(res.getString("DGenerateKeyPairCert.jbCancel.text"));
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbOK = new JButton(res.getString("DGenerateKeyPairCert.jbOK.text"));
        Container pane = this.getContentPane();
        pane.setLayout((LayoutManager)new MigLayout("insets dialog, fill", "[right]unrel[]", "[]unrel[]"));
        pane.add((Component)this.jlVersion, "");
        pane.add((Component)this.jrbVersion1, "split 2");
        pane.add((Component)this.jrbVersion3, "wrap");
        pane.add((Component)this.jlSigAlg, "");
        pane.add(this.jcbSignatureAlgorithm, "wrap");
        pane.add((Component)this.jlValidityStart, "");
        pane.add((Component)this.jdtValidityStart, "wrap");
        pane.add((Component)this.jlValidityPeriod, "");
        pane.add((Component)this.jvpValidityPeriod, "wrap");
        pane.add((Component)this.jlValidityEnd, "");
        pane.add((Component)this.jdtValidityEnd, "wrap");
        pane.add((Component)this.jlSerialNumber, "");
        pane.add((Component)this.jtfSerialNumber, "wrap");
        pane.add((Component)this.jlName, "");
        pane.add((Component)this.jdnName, "wrap");
        pane.add((Component)this.jbAddExtensions, "spanx");
        pane.add((Component)new JSeparator(), "spanx, growx, wrap 15:push");
        pane.add((Component)this.jbCancel, "spanx, split 2, tag cancel");
        pane.add((Component)this.jbOK, "tag ok");
        this.jvpValidityPeriod.addApplyActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Date startDate = DGenerateKeyPairCert.this.jdtValidityStart.getDateTime();
                if (startDate == null) {
                    startDate = new Date();
                    DGenerateKeyPairCert.this.jdtValidityStart.setDateTime(startDate);
                }
                Date validityEnd = DGenerateKeyPairCert.this.jvpValidityPeriod.getValidityEnd(startDate);
                DGenerateKeyPairCert.this.jdtValidityEnd.setDateTime(validityEnd);
            }
        });
        this.jbAddExtensions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DGenerateKeyPairCert.this);
                    DGenerateKeyPairCert.this.addExtensionsPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DGenerateKeyPairCert.this);
                }
            }
        });
        this.jrbVersion3.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DGenerateKeyPairCert.this.jbAddExtensions.setEnabled(DGenerateKeyPairCert.this.jrbVersion3.isSelected());
            }
        });
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DGenerateKeyPairCert.this.okPressed();
            }
        });
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DGenerateKeyPairCert.this.cancelPressed();
            }
        });
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DGenerateKeyPairCert.this.cancelPressed();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DGenerateKeyPairCert.this.closeDialog();
            }
        });
        this.setTitle(title);
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void addExtensionsPressed() {
        PublicKey subjectPublicKey = this.keyPair.getPublic();
        PublicKey caPublicKey = null;
        X500Name caIssuerName = null;
        BigInteger caSerialNumber = null;
        if (this.issuerCert != null) {
            caIssuerName = X500NameUtils.x500PrincipalToX500Name(this.issuerCert.getIssuerX500Principal());
            caPublicKey = this.issuerCert.getPublicKey();
            caSerialNumber = this.issuerCert.getSerialNumber();
        } else {
            caIssuerName = this.jdnName.getDistinguishedName();
            caPublicKey = this.keyPair.getPublic();
            String serialNumberStr = this.jtfSerialNumber.getText().trim();
            if (serialNumberStr.length() != 0) {
                try {
                    caSerialNumber = this.parseDecOrHex(serialNumberStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        DAddExtensions dAddExtensions = new DAddExtensions(this, this.extensions, caPublicKey, caIssuerName, caSerialNumber, subjectPublicKey);
        dAddExtensions.setLocationRelativeTo(this);
        dAddExtensions.setVisible(true);
        if (dAddExtensions.getExtensions() != null) {
            this.extensions = dAddExtensions.getExtensions();
        }
    }

    private BigInteger parseDecOrHex(String input) {
        try {
            return new BigInteger(input);
        }
        catch (NumberFormatException nfe) {
            if (input.startsWith("0x")) {
                return new BigInteger(input.substring(2), 16);
            }
            if (input.matches("^\\p{XDigit}+$")) {
                return new BigInteger(input, 16);
            }
            throw nfe;
        }
    }

    private boolean generateCertificate() {
        BigInteger serialNumber;
        Date validityStart = this.jdtValidityStart.getDateTime();
        Date validityEnd = this.jdtValidityEnd.getDateTime();
        String serialNumberStr = this.jtfSerialNumber.getText().trim();
        if (serialNumberStr.length() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DGenerateKeyPairCert.ValReqSerialNumber.message"), this.getTitle(), 2);
            return false;
        }
        try {
            serialNumber = this.parseDecOrHex(serialNumberStr);
            if (serialNumber.compareTo(BigInteger.ONE) < 0) {
                JOptionPane.showMessageDialog(this, res.getString("DGenerateKeyPairCert.SerialNumberNonZero.message"), this.getTitle(), 2);
                return false;
            }
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, res.getString("DGenerateKeyPairCert.SerialNumberNotInteger.message"), this.getTitle(), 2);
            return false;
        }
        X500Name x500Name = this.jdnName.getDistinguishedName();
        if (x500Name == null || x500Name.toString().isEmpty()) {
            JOptionPane.showMessageDialog(this, res.getString("DGenerateKeyPairCert.NameValueReq.message"), this.getTitle(), 2);
            return false;
        }
        try {
            SignatureType signatureType = (SignatureType)((Object)this.jcbSignatureAlgorithm.getSelectedItem());
            X509CertificateGenerator generator = this.jrbVersion1.isSelected() ? new X509CertificateGenerator(X509CertificateVersion.VERSION1) : new X509CertificateGenerator(X509CertificateVersion.VERSION3);
            this.certificate = this.issuerPrivateKey == null ? generator.generateSelfSigned(x500Name, validityStart, validityEnd, this.keyPair.getPublic(), this.keyPair.getPrivate(), signatureType, serialNumber, this.extensions, this.provider) : generator.generate(x500Name, X500NameUtils.x500PrincipalToX500Name(this.issuerCert.getSubjectX500Principal()), validityStart, validityEnd, this.keyPair.getPublic(), this.issuerPrivateKey, signatureType, serialNumber, this.extensions, this.provider);
        }
        catch (CryptoException e) {
            DError.displayError(this, (Throwable)e);
            this.closeDialog();
        }
        return true;
    }

    private long generateSerialNumber() {
        return System.currentTimeMillis() / 1000L;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    private void okPressed() {
        if (this.generateCertificate()) {
            this.closeDialog();
        }
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA", "BC");
        keyGen.initialize(1024);
        KeyPair keyPair = keyGen.genKeyPair();
        DGenerateKeyPairCert dialog = new DGenerateKeyPairCert(new JFrame(), "test", keyPair, KeyPairType.RSA, null, null, (Provider)new BouncyCastleProvider());
        DialogViewer.run(dialog);
    }
}

