/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.Provider;
import java.security.Security;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.kse.ApplicationSettings;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.CursorUtil;
import org.kse.gui.FileChooserFactory;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;
import org.kse.gui.error.DProblem;
import org.kse.gui.error.Problem;
import org.kse.version.JavaVersion;

public class DOpenPkcs11KeyStore
extends JEscDialog {
    private static final long serialVersionUID = 3188619209680032281L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/resources");
    private transient ApplicationSettings applicationSettings = ApplicationSettings.getInstance();
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JRadioButton jrbUseExisting;
    private JLabel jlSelectProvider;
    private JComboBox<String> jcbPkcs11Provider;
    private JRadioButton jrbCreateNew;
    private JLabel jlP11Library;
    private JComboBox<String> jtfP11Library;
    private JButton jbP11LibraryBrowse;
    private JLabel jlSlotListIndex;
    private JSpinner jspSlotListIndex;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private Provider selectedProvider;

    public DOpenPkcs11KeyStore(JFrame parent) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.setTitle(res.getString("DOpenPkcs11KeyStore.Title"));
        this.initComponents();
    }

    private void initComponents() {
        this.jrbUseExisting = new JRadioButton(res.getString("DOpenPkcs11KeyStore.jrbUseExisting.text"), false);
        PlatformUtil.setMnemonic((AbstractButton)this.jrbUseExisting, res.getString("DOpenPkcs11KeyStore.jrbUseExisting.mnemonic").charAt(0));
        this.jlSelectProvider = new JLabel(res.getString("DOpenPkcs11KeyStore.jlSelectProvider.text"));
        this.jcbPkcs11Provider = new JComboBox<String>(new DefaultComboBoxModel<String>(this.getPkcs11ProviderList()));
        this.jcbPkcs11Provider.setToolTipText(res.getString("DOpenPkcs11KeyStore.jcbPkcs11Provider.tooltip"));
        this.jrbCreateNew = new JRadioButton(res.getString("DOpenPkcs11KeyStore.jrbCreateNew.text"), false);
        PlatformUtil.setMnemonic((AbstractButton)this.jrbCreateNew, res.getString("DOpenPkcs11KeyStore.jrbCreateNew.mnemonic").charAt(0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.jrbUseExisting);
        buttonGroup.add(this.jrbCreateNew);
        if (this.getPkcs11ProviderList().length > 0) {
            this.jrbUseExisting.setSelected(true);
        } else {
            this.jrbCreateNew.setSelected(true);
            this.jrbUseExisting.setEnabled(false);
            this.jlSelectProvider.setEnabled(false);
            this.jcbPkcs11Provider.setEnabled(false);
        }
        this.jlP11Library = new JLabel(res.getString("DOpenPkcs11KeyStore.jlP11Library.text"));
        this.jtfP11Library = new JComboBox();
        this.jtfP11Library.setToolTipText(res.getString("DOpenPkcs11KeyStore.jtfP11Library.tooltip"));
        this.jtfP11Library.setEditable(true);
        this.jtfP11Library.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        this.jtfP11Library.setModel(new DefaultComboBoxModel<String>(this.getLibraryList()));
        this.jbP11LibraryBrowse = new JButton();
        this.jbP11LibraryBrowse.setIcon(new ImageIcon(this.getClass().getResource("images/open.png")));
        this.jbP11LibraryBrowse.setToolTipText(res.getString("DOpenPkcs11KeyStore.jbP11LibraryBrowse.tooltip"));
        this.jlSlotListIndex = new JLabel(res.getString("DOpenPkcs11KeyStore.jlSlotListIndex.text"));
        this.jspSlotListIndex = new JSpinner();
        this.jspSlotListIndex.setModel(new SpinnerNumberModel(0, 0, 65000, 1));
        this.jspSlotListIndex.setToolTipText(res.getString("DOpenPkcs11KeyStore.jspSlotListIndex.tooltip"));
        this.jbOK = new JButton(res.getString("DOpenPkcs11KeyStore.jbOK.text"));
        this.jbCancel = new JButton(res.getString("DOpenPkcs11KeyStore.jbCancel.text"));
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        Container pane = this.getContentPane();
        pane.setLayout((LayoutManager)new MigLayout("insets dialog, fill", "[para]rel[]rel[grow][]", ""));
        pane.add((Component)this.jrbUseExisting, "spanx, wrap");
        pane.add((Component)this.jlSelectProvider, "skip");
        pane.add(this.jcbPkcs11Provider, "growx, wrap unrel");
        pane.add((Component)this.jrbCreateNew, "spanx, wrap");
        pane.add((Component)this.jlP11Library, "skip");
        pane.add(this.jtfP11Library, "");
        pane.add((Component)this.jbP11LibraryBrowse, "wrap");
        pane.add((Component)this.jlSlotListIndex, "skip");
        pane.add((Component)this.jspSlotListIndex, "wrap para");
        pane.add((Component)new JSeparator(), "spanx, growx, wrap para");
        pane.add((Component)this.jpButtons, "right, spanx");
        this.jbP11LibraryBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DOpenPkcs11KeyStore.this);
                    DOpenPkcs11KeyStore.this.browsePressed();
                }
                finally {
                    CursorUtil.setCursorFree(DOpenPkcs11KeyStore.this);
                }
            }
        });
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DOpenPkcs11KeyStore.this.cancelPressed();
            }
        });
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DOpenPkcs11KeyStore.this.cancelPressed();
            }
        });
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DOpenPkcs11KeyStore.this.okPressed();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DOpenPkcs11KeyStore.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private String[] getPkcs11ProviderList() {
        Provider[] providers = Security.getProviders("KeyStore.PKCS11");
        if (providers == null) {
            return new String[0];
        }
        String[] providerNames = new String[providers.length];
        for (int i = 0; i < providers.length; ++i) {
            providerNames[i] = providers[i].getName();
        }
        return providerNames;
    }

    private String[] getLibraryList() {
        String p11Libs = this.applicationSettings.getP11Libs();
        String[] libs = p11Libs.split(";");
        return libs;
    }

    private void browsePressed() {
        JFileChooser chooser = FileChooserFactory.getLibFileChooser();
        File currentLibFile = new File(((String)this.jtfP11Library.getSelectedItem()).trim());
        if (currentLibFile.getParentFile() != null && currentLibFile.getParentFile().exists()) {
            chooser.setCurrentDirectory(currentLibFile.getParentFile());
            chooser.setSelectedFile(currentLibFile);
        } else {
            chooser.setCurrentDirectory(CurrentDirectory.get());
        }
        chooser.setDialogTitle(res.getString("DOpenPkcs11KeyStore.SelectLib.Title"));
        chooser.setMultiSelectionEnabled(false);
        chooser.setApproveButtonText(res.getString("DOpenPkcs11KeyStore.SelectLib.button"));
        int rtnValue = chooser.showOpenDialog(this);
        if (rtnValue == 0) {
            File chosenFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(chosenFile);
            String libPath = chosenFile.toString();
            this.jtfP11Library.addItem(libPath);
            this.jtfP11Library.setSelectedItem(libPath);
        }
    }

    private void okPressed() {
        final String selectedLib = ((String)this.jtfP11Library.getSelectedItem()).trim();
        try {
            if (this.jrbUseExisting.isSelected()) {
                String providerName = (String)this.jcbPkcs11Provider.getSelectedItem();
                this.selectedProvider = Security.getProvider(providerName);
                if (this.selectedProvider == null) {
                    JOptionPane.showMessageDialog(this, res.getString("DOpenPkcs11KeyStore.providerNotInstalled.message"), this.getTitle(), 2);
                }
            } else {
                if (selectedLib.isEmpty()) {
                    JOptionPane.showMessageDialog(this, res.getString("DOpenPkcs11KeyStore.noLibSelected.message"), this.getTitle(), 2);
                    return;
                }
                String pkcs11ConfigSettings = "name = Slot" + this.jspSlotListIndex.getValue() + "\nlibrary = " + selectedLib + "\nslotListIndex = " + this.jspSlotListIndex.getValue() + "";
                ByteArrayInputStream confStream = new ByteArrayInputStream(pkcs11ConfigSettings.getBytes());
                Provider p11Provider = null;
                if (JavaVersion.getJreVersion().isAtLeast(JavaVersion.JRE_VERSION_9)) {
                    p11Provider = Security.getProvider("SunPKCS11");
                    pkcs11ConfigSettings = "--" + pkcs11ConfigSettings;
                    Method method = Provider.class.getMethod("configure", String.class);
                    p11Provider = (Provider)method.invoke((Object)p11Provider, pkcs11ConfigSettings);
                } else {
                    Class<?> cl = Class.forName("sun.security.pkcs11.SunPKCS11");
                    Constructor<?> cons = cl.getConstructor(InputStream.class);
                    p11Provider = (Provider)cons.newInstance(confStream);
                }
                Security.addProvider(p11Provider);
                this.selectedProvider = p11Provider;
                this.applicationSettings.addP11Lib(selectedLib);
            }
            this.closeDialog();
        }
        catch (Exception e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (DOpenPkcs11KeyStore.this.isShowing()) {
                        String problemStr = MessageFormat.format(res.getString("DOpenPkcs11KeyStore.ProblemLoadingProvider.Problem"), selectedLib);
                        String[] causes = new String[]{res.getString("DOpenPkcs11KeyStore.NotPkcs11Lib.Cause"), res.getString("DOpenPkcs11KeyStore.32with64bit.Cause"), res.getString("DOpenPkcs11KeyStore.64bitBeforeJRE8.Cause"), res.getString("DOpenPkcs11KeyStore.WrongConfiguration.Cause")};
                        Problem problem = new Problem(problemStr, causes, e);
                        DProblem dProblem = new DProblem(DOpenPkcs11KeyStore.this, res.getString("DOpenPkcs11KeyStore.ProblemLoadingProvider.Title"), problem);
                        dProblem.setLocationRelativeTo(DOpenPkcs11KeyStore.this);
                        dProblem.setVisible(true);
                    }
                }
            });
        }
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public Provider getSelectedProvider() {
        return this.selectedProvider;
    }
}

