/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.awt.Component;
import java.math.BigInteger;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.kse.utilities.StringUtils;

public class RevokedCertsTableCellRend
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;

    @Override
    public Component getTableCellRendererComponent(JTable jtRevokedCerts, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        JLabel cell = (JLabel)super.getTableCellRendererComponent(jtRevokedCerts, value, isSelected, hasFocus, row, col);
        if (col == 0) {
            cell.setText(this.formatSerialNumberAsHexString((BigInteger)value));
        } else {
            cell.setText(StringUtils.formatDate((Date)value));
        }
        cell.setBorder(new EmptyBorder(0, 5, 0, 5));
        return cell;
    }

    private String formatSerialNumberAsHexString(BigInteger serialNumber) {
        String hexSerialNumber = serialNumber.toString(16).toUpperCase();
        StringBuffer strBuff = new StringBuffer();
        strBuff.append("0x");
        for (int i = 0; i < hexSerialNumber.length(); ++i) {
            strBuff.append(hexSerialNumber.charAt(i));
            if ((i + 1) % 4 != 0 || i + 1 == hexSerialNumber.length()) continue;
            strBuff.append(' ');
        }
        return strBuff.toString();
    }
}

