/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.extensions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.Provider;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.kse.crypto.keypair.KeyPairType;
import org.kse.crypto.keypair.KeyPairUtil;
import org.kse.crypto.x509.X509ExtensionSet;
import org.kse.crypto.x509.X509ExtensionSetLoadException;
import org.kse.crypto.x509.X509ExtensionSetUpdater;
import org.kse.crypto.x509.X509ExtensionType;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.CursorUtil;
import org.kse.gui.FileChooserFactory;
import org.kse.gui.JEscDialog;
import org.kse.gui.JKseTable;
import org.kse.gui.PlatformUtil;
import org.kse.gui.dialogs.extensions.DAddExtensionType;
import org.kse.gui.dialogs.extensions.DAuthorityInformationAccess;
import org.kse.gui.dialogs.extensions.DAuthorityKeyIdentifier;
import org.kse.gui.dialogs.extensions.DBasicConstraints;
import org.kse.gui.dialogs.extensions.DCertificatePolicies;
import org.kse.gui.dialogs.extensions.DExtendedKeyUsage;
import org.kse.gui.dialogs.extensions.DExtension;
import org.kse.gui.dialogs.extensions.DInhibitAnyPolicy;
import org.kse.gui.dialogs.extensions.DIssuerAlternativeName;
import org.kse.gui.dialogs.extensions.DKeyUsage;
import org.kse.gui.dialogs.extensions.DNameConstraints;
import org.kse.gui.dialogs.extensions.DNetscapeBaseUrl;
import org.kse.gui.dialogs.extensions.DNetscapeCaPolicyUrl;
import org.kse.gui.dialogs.extensions.DNetscapeCaRevocationUrl;
import org.kse.gui.dialogs.extensions.DNetscapeCertificateRenewalUrl;
import org.kse.gui.dialogs.extensions.DNetscapeCertificateType;
import org.kse.gui.dialogs.extensions.DNetscapeComment;
import org.kse.gui.dialogs.extensions.DNetscapeRevocationUrl;
import org.kse.gui.dialogs.extensions.DNetscapeSslServerName;
import org.kse.gui.dialogs.extensions.DPolicyConstraints;
import org.kse.gui.dialogs.extensions.DPolicyMappings;
import org.kse.gui.dialogs.extensions.DPrivateKeyUsagePeriod;
import org.kse.gui.dialogs.extensions.DSelectStandardExtensionTemplate;
import org.kse.gui.dialogs.extensions.DSubjectAlternativeName;
import org.kse.gui.dialogs.extensions.DSubjectInformationAccess;
import org.kse.gui.dialogs.extensions.DSubjectKeyIdentifier;
import org.kse.gui.dialogs.extensions.ExtensionsTableCellRend;
import org.kse.gui.dialogs.extensions.ExtensionsTableHeadRend;
import org.kse.gui.dialogs.extensions.ExtensionsTableModel;
import org.kse.gui.error.DError;
import org.kse.utilities.DialogViewer;
import org.kse.utilities.oid.ObjectIdComparator;
import org.kse.utilities.os.OperatingSystem;

public class DAddExtensions
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/extensions/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpExtensions;
    private JPanel jpExtensionButtons;
    private JButton jbAdd;
    private JButton jbEdit;
    private JButton jbToggleCriticality;
    private JButton jbRemove;
    private JScrollPane jspExtensionsTable;
    private JKseTable jtExtensions;
    private JPanel jpLoadSaveTemplate;
    private JButton jbSelectStandardTemplate;
    private JButton jbLoadTemplate;
    private JButton jbSaveTemplate;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private X509ExtensionSet extensions = new X509ExtensionSet();
    private PublicKey issuerPublicKey;
    private X500Name issuerCertName;
    private BigInteger issuerCertSerialNumber;
    private PublicKey subjectPublicKey;

    public DAddExtensions(JFrame parent, String title, X509ExtensionSet extensions, PublicKey issuerPublicKey, X500Name issuerCertName, BigInteger issuerCertSerialNumber, PublicKey subjectPublicKey) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.setTitle(res.getString("DAddExtensions.Title"));
        this.extensions = extensions;
        this.issuerPublicKey = issuerPublicKey;
        this.issuerCertName = issuerCertName;
        this.issuerCertSerialNumber = issuerCertSerialNumber;
        this.subjectPublicKey = subjectPublicKey;
        this.initComponents();
    }

    public DAddExtensions(JDialog parent, X509ExtensionSet extensions, PublicKey issuerPublicKey, X500Name issuerCertName, BigInteger issuerCertSerialNumber, PublicKey subjectPublicKey) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.setTitle(res.getString("DAddExtensions.Title"));
        this.extensions = (X509ExtensionSet)extensions.clone();
        this.issuerPublicKey = issuerPublicKey;
        this.issuerCertName = issuerCertName;
        this.issuerCertSerialNumber = issuerCertSerialNumber;
        this.subjectPublicKey = subjectPublicKey;
        this.initComponents();
    }

    private void initComponents() {
        this.jbAdd = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/add_ext.png"))));
        this.jbAdd.setMargin(new Insets(2, 2, 0, 0));
        this.jbAdd.setToolTipText(res.getString("DAddExtensions.jbAdd.tooltip"));
        this.jbAdd.setMnemonic(res.getString("DAddExtensions.jbAdd.mnemonic").charAt(0));
        this.jbAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DAddExtensions.this);
                    DAddExtensions.this.addPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DAddExtensions.this);
                }
            }
        });
        this.jbEdit = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/edit_ext.png"))));
        this.jbEdit.setMargin(new Insets(2, 2, 0, 0));
        this.jbEdit.setToolTipText(res.getString("DAddExtensions.jbEdit.tooltip"));
        this.jbEdit.setMnemonic(res.getString("DAddExtensions.jbEdit.mnemonic").charAt(0));
        this.jbEdit.setEnabled(false);
        this.jbEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DAddExtensions.this);
                    DAddExtensions.this.editPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DAddExtensions.this);
                }
            }
        });
        this.jbToggleCriticality = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/toggle_ext_crit.png"))));
        this.jbToggleCriticality.setMargin(new Insets(2, 2, 0, 0));
        this.jbToggleCriticality.setToolTipText(res.getString("DAddExtensions.jbToggleCriticality.tooltip"));
        this.jbToggleCriticality.setMnemonic(res.getString("DAddExtensions.jbToggleCriticality.mnemonic").charAt(0));
        this.jbToggleCriticality.setEnabled(false);
        this.jbToggleCriticality.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DAddExtensions.this);
                    DAddExtensions.this.toggleCriticalityPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DAddExtensions.this);
                }
            }
        });
        this.jbRemove = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/remove_ext.png"))));
        this.jbRemove.setMargin(new Insets(2, 2, 0, 0));
        this.jbRemove.setToolTipText(res.getString("DAddExtensions.jbRemove.tooltip"));
        this.jbRemove.setMnemonic(res.getString("DAddExtensions.jbRemove.mnemonic").charAt(0));
        this.jbRemove.setEnabled(false);
        this.jbRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DAddExtensions.this);
                    DAddExtensions.this.removePressed();
                }
                finally {
                    CursorUtil.setCursorFree(DAddExtensions.this);
                }
            }
        });
        this.jpExtensionButtons = new JPanel();
        this.jpExtensionButtons.setLayout(new BoxLayout(this.jpExtensionButtons, 1));
        this.jpExtensionButtons.add(Box.createVerticalGlue());
        this.jpExtensionButtons.add(this.jbAdd);
        this.jpExtensionButtons.add(Box.createVerticalStrut(3));
        this.jpExtensionButtons.add(this.jbEdit);
        this.jpExtensionButtons.add(Box.createVerticalStrut(3));
        this.jpExtensionButtons.add(this.jbToggleCriticality);
        this.jpExtensionButtons.add(Box.createVerticalStrut(3));
        this.jpExtensionButtons.add(this.jbRemove);
        this.jpExtensionButtons.add(Box.createVerticalGlue());
        ExtensionsTableModel extensionsTableModel = new ExtensionsTableModel();
        this.jtExtensions = new JKseTable(extensionsTableModel);
        TableRowSorter<ExtensionsTableModel> sorter = new TableRowSorter<ExtensionsTableModel>(extensionsTableModel);
        sorter.setComparator(2, new ObjectIdComparator());
        this.jtExtensions.setRowSorter(sorter);
        this.jtExtensions.setShowGrid(false);
        this.jtExtensions.setRowMargin(0);
        this.jtExtensions.getColumnModel().setColumnMargin(0);
        this.jtExtensions.getTableHeader().setReorderingAllowed(false);
        this.jtExtensions.setAutoResizeMode(4);
        this.jtExtensions.setRowHeight(Math.max(18, this.jtExtensions.getRowHeight()));
        for (int i = 0; i < this.jtExtensions.getColumnCount(); ++i) {
            TableColumn column = this.jtExtensions.getColumnModel().getColumn(i);
            column.setHeaderRenderer(new ExtensionsTableHeadRend(this.jtExtensions.getTableHeader().getDefaultRenderer()));
            column.setCellRenderer(new ExtensionsTableCellRend());
        }
        TableColumn criticalCol = this.jtExtensions.getColumnModel().getColumn(0);
        criticalCol.setResizable(false);
        criticalCol.setMinWidth(28);
        criticalCol.setMaxWidth(28);
        criticalCol.setPreferredWidth(28);
        ListSelectionModel selectionModel = this.jtExtensions.getSelectionModel();
        selectionModel.setSelectionMode(0);
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    try {
                        CursorUtil.setCursorBusy(DAddExtensions.this);
                        DAddExtensions.this.updateButtonControls();
                    }
                    finally {
                        CursorUtil.setCursorFree(DAddExtensions.this);
                    }
                }
            }
        });
        this.jtExtensions.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DAddExtensions.this.maybeEditExtension(evt);
            }
        });
        this.jtExtensions.addKeyListener(new KeyAdapter(){
            boolean deleteLastPressed = false;

            @Override
            public void keyPressed(KeyEvent evt) {
                if (!OperatingSystem.isMacOs()) {
                    this.deleteLastPressed = evt.getKeyCode() == 127;
                }
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                if (!OperatingSystem.isMacOs() && this.deleteLastPressed && evt.getKeyCode() == 127) {
                    try {
                        CursorUtil.setCursorBusy(DAddExtensions.this);
                        this.deleteLastPressed = false;
                        DAddExtensions.this.removeSelectedExtension();
                    }
                    finally {
                        CursorUtil.setCursorFree(DAddExtensions.this);
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                if (OperatingSystem.isMacOs() && evt.getKeyChar() == '\b') {
                    try {
                        CursorUtil.setCursorBusy(DAddExtensions.this);
                        DAddExtensions.this.removeSelectedExtension();
                    }
                    finally {
                        CursorUtil.setCursorFree(DAddExtensions.this);
                    }
                }
            }
        });
        this.jspExtensionsTable = PlatformUtil.createScrollPane(this.jtExtensions, 20, 31);
        this.jspExtensionsTable.getViewport().setBackground(this.jtExtensions.getBackground());
        this.jbSelectStandardTemplate = new JButton(res.getString("DAddExtensions.jbSelectStandardTemplate.text"));
        this.jbSelectStandardTemplate.setMnemonic(res.getString("DAddExtensions.jbSelectStandardTemplate.mnemonic").charAt(0));
        this.jbSelectStandardTemplate.setToolTipText(res.getString("DAddExtensions.jbSelectStandardTemplate.tooltip"));
        this.jbSelectStandardTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DAddExtensions.this);
                    DAddExtensions.this.selectStandardTemplatePressed();
                }
                finally {
                    CursorUtil.setCursorFree(DAddExtensions.this);
                }
            }
        });
        this.jbLoadTemplate = new JButton(res.getString("DAddExtensions.jbLoadTemplate.text"));
        this.jbLoadTemplate.setMnemonic(res.getString("DAddExtensions.jbLoadTemplate.mnemonic").charAt(0));
        this.jbLoadTemplate.setToolTipText(res.getString("DAddExtensions.jbLoadTemplate.tooltip"));
        this.jbLoadTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DAddExtensions.this);
                    DAddExtensions.this.loadTemplatePressed();
                }
                finally {
                    CursorUtil.setCursorFree(DAddExtensions.this);
                }
            }
        });
        this.jbSaveTemplate = new JButton(res.getString("DAddExtensions.jbSaveTemplate.text"));
        this.jbSaveTemplate.setMnemonic(res.getString("DAddExtensions.jbSaveTemplate.mnemonic").charAt(0));
        this.jbSaveTemplate.setToolTipText(res.getString("DAddExtensions.jbSaveTemplate.tooltip"));
        this.jbSaveTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DAddExtensions.this);
                    DAddExtensions.saveTemplatePressed(DAddExtensions.this.extensions, DAddExtensions.this);
                }
                finally {
                    CursorUtil.setCursorFree(DAddExtensions.this);
                }
            }
        });
        this.jpLoadSaveTemplate = new JPanel();
        this.jpLoadSaveTemplate.setLayout(new BoxLayout(this.jpLoadSaveTemplate, 0));
        this.jpLoadSaveTemplate.add(Box.createHorizontalGlue());
        this.jpLoadSaveTemplate.add(this.jbSelectStandardTemplate);
        this.jpLoadSaveTemplate.add(Box.createHorizontalStrut(5));
        this.jpLoadSaveTemplate.add(this.jbLoadTemplate);
        this.jpLoadSaveTemplate.add(Box.createHorizontalStrut(5));
        this.jpLoadSaveTemplate.add(this.jbSaveTemplate);
        this.jpExtensions = new JPanel(new BorderLayout(5, 5));
        this.jpExtensions.setPreferredSize(new Dimension(450, 200));
        this.jpExtensions.add((Component)this.jspExtensionsTable, "Center");
        this.jpExtensions.add((Component)this.jpExtensionButtons, "East");
        this.jpExtensions.add((Component)this.jpLoadSaveTemplate, "South");
        this.jpExtensions.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        this.jbOK = new JButton(res.getString("DAddExtensions.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DAddExtensions.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DAddExtensions.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DAddExtensions.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DAddExtensions.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.reloadExtensionsTable();
        this.selectFirstExtensionInTable();
        this.updateButtonControls();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpExtensions, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DAddExtensions.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void addPressed() {
        DAddExtensionType dAddExtensionType = new DAddExtensionType(this, this.extensions);
        dAddExtensionType.setLocationRelativeTo(this);
        dAddExtensionType.setVisible(true);
        X509ExtensionType extensionTypeToAdd = dAddExtensionType.getExtensionType();
        if (extensionTypeToAdd == null) {
            return;
        }
        boolean isCritical = dAddExtensionType.isExtensionCritical();
        byte[] extensionValue = null;
        DExtension dExtension = null;
        switch (extensionTypeToAdd) {
            case AUTHORITY_INFORMATION_ACCESS: {
                dExtension = new DAuthorityInformationAccess(this);
                break;
            }
            case AUTHORITY_KEY_IDENTIFIER: {
                dExtension = new DAuthorityKeyIdentifier(this, this.issuerPublicKey, this.issuerCertName, this.issuerCertSerialNumber);
                break;
            }
            case BASIC_CONSTRAINTS: {
                dExtension = new DBasicConstraints(this);
                break;
            }
            case CERTIFICATE_POLICIES: {
                dExtension = new DCertificatePolicies(this);
                break;
            }
            case EXTENDED_KEY_USAGE: {
                dExtension = new DExtendedKeyUsage(this);
                break;
            }
            case INHIBIT_ANY_POLICY: {
                dExtension = new DInhibitAnyPolicy(this);
                break;
            }
            case ISSUER_ALTERNATIVE_NAME: {
                dExtension = new DIssuerAlternativeName(this);
                break;
            }
            case KEY_USAGE: {
                dExtension = new DKeyUsage(this);
                break;
            }
            case NAME_CONSTRAINTS: {
                dExtension = new DNameConstraints(this);
                break;
            }
            case NETSCAPE_BASE_URL: {
                dExtension = new DNetscapeBaseUrl(this);
                break;
            }
            case NETSCAPE_CA_POLICY_URL: {
                dExtension = new DNetscapeCaPolicyUrl(this);
                break;
            }
            case NETSCAPE_CA_REVOCATION_URL: {
                dExtension = new DNetscapeCaRevocationUrl(this);
                break;
            }
            case NETSCAPE_CERTIFICATE_RENEWAL_URL: {
                dExtension = new DNetscapeCertificateRenewalUrl(this);
                break;
            }
            case NETSCAPE_CERTIFICATE_TYPE: {
                dExtension = new DNetscapeCertificateType(this);
                break;
            }
            case NETSCAPE_COMMENT: {
                dExtension = new DNetscapeComment(this);
                break;
            }
            case NETSCAPE_REVOCATION_URL: {
                dExtension = new DNetscapeRevocationUrl(this);
                break;
            }
            case NETSCAPE_SSL_SERVER_NAME: {
                dExtension = new DNetscapeSslServerName(this);
                break;
            }
            case POLICY_CONSTRAINTS: {
                dExtension = new DPolicyConstraints(this);
                break;
            }
            case POLICY_MAPPINGS: {
                dExtension = new DPolicyMappings(this);
                break;
            }
            case PRIVATE_KEY_USAGE_PERIOD: {
                dExtension = new DPrivateKeyUsagePeriod(this);
                break;
            }
            case SUBJECT_ALTERNATIVE_NAME: {
                dExtension = new DSubjectAlternativeName(this);
                break;
            }
            case SUBJECT_INFORMATION_ACCESS: {
                dExtension = new DSubjectInformationAccess(this);
                break;
            }
            case SUBJECT_KEY_IDENTIFIER: {
                dExtension = new DSubjectKeyIdentifier(this, this.subjectPublicKey);
                break;
            }
            default: {
                return;
            }
        }
        dExtension.setLocationRelativeTo(this);
        dExtension.setVisible(true);
        extensionValue = dExtension.getValue();
        if (extensionValue == null) {
            return;
        }
        byte[] extensionValueOctet = null;
        try {
            extensionValueOctet = new DEROctetString(extensionValue).getEncoded("DER");
        }
        catch (IOException e) {
            return;
        }
        this.extensions.addExtension(extensionTypeToAdd.oid(), isCritical, extensionValueOctet);
        this.reloadExtensionsTable();
        this.selectExtensionInTable(extensionTypeToAdd.oid());
        this.updateButtonControls();
    }

    private void editPressed() {
        this.editSelectedExtension();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeEditExtension(MouseEvent evt) {
        Point point;
        int row;
        if (evt.getClickCount() > 1 && (row = this.jtExtensions.rowAtPoint(point = new Point(evt.getX(), evt.getY()))) != -1) {
            try {
                CursorUtil.setCursorBusy(this);
                this.jtExtensions.setRowSelectionInterval(row, row);
                this.editSelectedExtension();
            }
            finally {
                CursorUtil.setCursorFree(this);
            }
        }
    }

    private void editSelectedExtension() {
        try {
            int selectedRow = this.jtExtensions.getSelectedRow();
            if (selectedRow != -1) {
                String oid = ((ASN1ObjectIdentifier)this.jtExtensions.getValueAt(selectedRow, 2)).getId();
                X509ExtensionType extensionType = X509ExtensionType.resolveOid(oid);
                byte[] extensionValue = ASN1OctetString.getInstance((Object)this.extensions.getExtensionValue(oid)).getOctets();
                boolean isCritical = this.extensions.getCriticalExtensionOIDs().contains(oid);
                byte[] newExtensionValue = null;
                DExtension dExtension = null;
                switch (extensionType) {
                    case AUTHORITY_INFORMATION_ACCESS: {
                        dExtension = new DAuthorityInformationAccess(this, extensionValue);
                        break;
                    }
                    case AUTHORITY_KEY_IDENTIFIER: {
                        dExtension = new DAuthorityKeyIdentifier(this, extensionValue, this.issuerPublicKey);
                        break;
                    }
                    case BASIC_CONSTRAINTS: {
                        dExtension = new DBasicConstraints(this, extensionValue);
                        break;
                    }
                    case CERTIFICATE_POLICIES: {
                        dExtension = new DCertificatePolicies(this, extensionValue);
                        break;
                    }
                    case EXTENDED_KEY_USAGE: {
                        dExtension = new DExtendedKeyUsage(this, extensionValue);
                        break;
                    }
                    case INHIBIT_ANY_POLICY: {
                        dExtension = new DInhibitAnyPolicy(this, extensionValue);
                        break;
                    }
                    case ISSUER_ALTERNATIVE_NAME: {
                        dExtension = new DIssuerAlternativeName(this, extensionValue);
                        break;
                    }
                    case KEY_USAGE: {
                        dExtension = new DKeyUsage(this, extensionValue);
                        break;
                    }
                    case NAME_CONSTRAINTS: {
                        dExtension = new DNameConstraints(this, extensionValue);
                        break;
                    }
                    case NETSCAPE_BASE_URL: {
                        dExtension = new DNetscapeBaseUrl(this, extensionValue);
                        break;
                    }
                    case NETSCAPE_CERTIFICATE_RENEWAL_URL: {
                        dExtension = new DNetscapeCertificateRenewalUrl(this, extensionValue);
                        break;
                    }
                    case NETSCAPE_CA_POLICY_URL: {
                        dExtension = new DNetscapeCaPolicyUrl(this, extensionValue);
                        break;
                    }
                    case NETSCAPE_CA_REVOCATION_URL: {
                        dExtension = new DNetscapeCaRevocationUrl(this, extensionValue);
                        break;
                    }
                    case NETSCAPE_CERTIFICATE_TYPE: {
                        dExtension = new DNetscapeCertificateType(this, extensionValue);
                        break;
                    }
                    case NETSCAPE_COMMENT: {
                        dExtension = new DNetscapeComment(this, extensionValue);
                        break;
                    }
                    case NETSCAPE_REVOCATION_URL: {
                        dExtension = new DNetscapeRevocationUrl(this, extensionValue);
                        break;
                    }
                    case NETSCAPE_SSL_SERVER_NAME: {
                        dExtension = new DNetscapeSslServerName(this, extensionValue);
                        break;
                    }
                    case POLICY_CONSTRAINTS: {
                        dExtension = new DPolicyConstraints(this, extensionValue);
                        break;
                    }
                    case POLICY_MAPPINGS: {
                        dExtension = new DPolicyMappings(this, extensionValue);
                        break;
                    }
                    case PRIVATE_KEY_USAGE_PERIOD: {
                        dExtension = new DPrivateKeyUsagePeriod(this, extensionValue);
                        break;
                    }
                    case SUBJECT_ALTERNATIVE_NAME: {
                        dExtension = new DSubjectAlternativeName(this, extensionValue);
                        break;
                    }
                    case SUBJECT_INFORMATION_ACCESS: {
                        dExtension = new DSubjectInformationAccess(this, extensionValue);
                        break;
                    }
                    case SUBJECT_KEY_IDENTIFIER: {
                        dExtension = new DSubjectKeyIdentifier(this, extensionValue, this.subjectPublicKey);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                dExtension.setLocationRelativeTo(this);
                dExtension.setVisible(true);
                newExtensionValue = dExtension.getValue();
                if (newExtensionValue == null) {
                    return;
                }
                byte[] newExtensionValueOctet = new DEROctetString(newExtensionValue).getEncoded("DER");
                this.extensions.addExtension(oid, isCritical, newExtensionValueOctet);
                this.reloadExtensionsTable();
                this.selectExtensionInTable(oid);
                this.updateButtonControls();
            }
        }
        catch (IOException e) {
            DError.displayError(this, (Throwable)e);
        }
    }

    private void toggleCriticalityPressed() {
        int selectedRow = this.jtExtensions.getSelectedRow();
        if (selectedRow != -1) {
            String oid = ((ASN1ObjectIdentifier)this.jtExtensions.getValueAt(selectedRow, 2)).getId();
            this.extensions.toggleExtensionCriticality(oid);
            this.reloadExtensionsTable();
            this.selectFirstExtensionInTable();
            this.updateButtonControls();
        }
    }

    private void removePressed() {
        this.removeSelectedExtension();
    }

    private void removeSelectedExtension() {
        int selectedRow = this.jtExtensions.getSelectedRow();
        if (selectedRow != -1) {
            String oid = ((ASN1ObjectIdentifier)this.jtExtensions.getValueAt(selectedRow, 2)).getId();
            this.extensions.removeExtension(oid);
            this.reloadExtensionsTable();
            this.selectFirstExtensionInTable();
            this.updateButtonControls();
        }
    }

    private ExtensionsTableModel getExtensionsTableModel() {
        return (ExtensionsTableModel)this.jtExtensions.getModel();
    }

    private void selectFirstExtensionInTable() {
        if (this.getExtensionsTableModel().getRowCount() > 0) {
            this.jtExtensions.changeSelection(0, 0, false, false);
        }
    }

    private void selectExtensionInTable(String oid) {
        for (int i = 0; i < this.jtExtensions.getRowCount(); ++i) {
            if (!oid.equals(((ASN1ObjectIdentifier)this.jtExtensions.getValueAt(i, 2)).getId())) continue;
            this.jtExtensions.changeSelection(i, 0, false, false);
            return;
        }
    }

    private void reloadExtensionsTable() {
        this.getExtensionsTableModel().load(this.extensions);
    }

    private void updateButtonControls() {
        int selectedRow = this.jtExtensions.getSelectedRow();
        if (selectedRow == -1) {
            this.jbEdit.setEnabled(false);
            this.jbToggleCriticality.setEnabled(false);
            this.jbRemove.setEnabled(false);
        } else {
            this.jbEdit.setEnabled(true);
            this.jbToggleCriticality.setEnabled(true);
            this.jbRemove.setEnabled(true);
        }
    }

    private void selectStandardTemplatePressed() {
        DSelectStandardExtensionTemplate dSelectStdCertTemplate = new DSelectStandardExtensionTemplate(this, this.issuerPublicKey, this.subjectPublicKey);
        dSelectStdCertTemplate.setLocationRelativeTo(this);
        dSelectStdCertTemplate.setVisible(true);
        if (!dSelectStdCertTemplate.wasCancelled()) {
            this.extensions = dSelectStdCertTemplate.getExtensionSet();
            this.reloadExtensionsTable();
            this.selectFirstExtensionInTable();
        }
    }

    private void loadTemplatePressed() {
        JFileChooser chooser = FileChooserFactory.getCetFileChooser();
        chooser.setCurrentDirectory(CurrentDirectory.get());
        chooser.setDialogTitle(res.getString("DAddExtensions.LoadCet.Title"));
        chooser.setMultiSelectionEnabled(false);
        chooser.setApproveButtonText(res.getString("DAddExtensions.CetLoad.button"));
        int rtnValue = chooser.showOpenDialog(this);
        if (rtnValue == 0) {
            File loadFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(loadFile);
            try {
                this.extensions = X509ExtensionSet.load(new FileInputStream(loadFile));
                X509ExtensionSetUpdater.update(this.extensions, this.subjectPublicKey, this.issuerPublicKey, this.issuerCertName, this.issuerCertSerialNumber);
                this.reloadExtensionsTable();
                this.selectFirstExtensionInTable();
                this.updateButtonControls();
            }
            catch (X509ExtensionSetLoadException ex) {
                JOptionPane.showMessageDialog(this, MessageFormat.format(res.getString("DAddExtensions.InvalidCetFile.message"), loadFile), res.getString("DAddExtensions.LoadCet.Title"), 2);
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(this, MessageFormat.format(res.getString("DAddExtensions.NoReadFile.message"), loadFile), res.getString("DAddExtensions.LoadCet.Title"), 2);
            }
            catch (Exception ex) {
                DError.displayError(this, (Throwable)ex);
            }
        }
    }

    public static void saveTemplatePressed(X509ExtensionSet extensionsToSave, JDialog parentComponent) {
        JFileChooser chooser = FileChooserFactory.getCetFileChooser();
        chooser.setCurrentDirectory(CurrentDirectory.get());
        chooser.setDialogTitle(res.getString("DAddExtensions.SaveCet.Title"));
        chooser.setMultiSelectionEnabled(false);
        int rtnValue = chooser.showSaveDialog(parentComponent);
        if (rtnValue == 0) {
            String message;
            int selected;
            File saveFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(saveFile);
            if (saveFile.isFile() && (selected = JOptionPane.showConfirmDialog(parentComponent, message = MessageFormat.format(res.getString("DAddExtensions.OverWriteFile.message"), saveFile), res.getString("DAddExtensions.SaveCet.Title"), 0)) != 0) {
                return;
            }
            try {
                extensionsToSave.save(new FileOutputStream(saveFile));
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(parentComponent, MessageFormat.format(res.getString("DAddExtensions.NoWriteFile.message"), saveFile), res.getString("DAddExtensions.SaveCet.Title"), 2);
            }
            catch (IOException ex) {
                DError.displayError(parentComponent, (Throwable)ex);
            }
        }
    }

    public X509ExtensionSet getExtensions() {
        return this.extensions;
    }

    private void okPressed() {
        this.closeDialog();
    }

    private void cancelPressed() {
        this.extensions = null;
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) throws Exception {
        KeyPair keyPair = KeyPairUtil.generateKeyPair(KeyPairType.RSA, 1024, (Provider)new BouncyCastleProvider());
        DAddExtensions dialog = new DAddExtensions(new JFrame(), "Add Extensions", new X509ExtensionSet(), keyPair.getPublic(), new X500Name("cn=test"), BigInteger.ONE, keyPair.getPublic());
        DialogViewer.run(dialog);
    }
}

